/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.controller.busi;

import com.tydic.payment.pay.bo.BaseRspInfoBO;
import com.tydic.payment.pay.bo.PayCenterRspBo;
import com.tydic.payment.pay.exception.BusinessException;
import com.tydic.payment.pay.web.bo.MerchantInfoBoStr;
import com.tydic.payment.pay.web.bo.req.QueryMerchantIdAndNameReqBo;
import com.tydic.payment.pay.web.service.QueryMerchantInfoWebService;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/pay/rest/merchantInfoM"})
public class MerchantInfoMController {
    private static final Logger log = LoggerFactory.getLogger(MerchantInfoMController.class);
    @Reference(interfaceClass=QueryMerchantInfoWebService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private QueryMerchantInfoWebService queryMerchantInfoWebService;

    @RequestMapping(value={"/query/merchant/baseInfo"}, method={RequestMethod.POST})
    @ResponseBody
    public PayCenterRspBo<MerchantInfoBoStr> queryMerchantBaseInfo(QueryMerchantIdAndNameReqBo reqBo) {
        log.info("\u8fdb\u5165\u5546\u6237\u7ba1\u7406controller  ->  \u5f53\u524d\u65b9\u6cd5\uff1a\u67e5\u8be2\u5546\u6237\u57fa\u672c\u4fe1\u606f");
        try {
            PayCenterRspBo payCenterRspBo = new PayCenterRspBo();
            payCenterRspBo.setRespCode("8888");
            payCenterRspBo.setRespDesc("\u5931\u8d25");
            if (reqBo == null) {
                payCenterRspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
                return payCenterRspBo;
            }
            if (StringUtils.isEmpty((Object)reqBo.getMerchantId())) {
                payCenterRspBo.setRespDesc("\u5546\u6237ID\u4e0d\u80fd\u4e3a\u7a7a");
                return payCenterRspBo;
            }
            MerchantInfoBoStr rsp = this.queryMerchantInfoWebService.queryMerchantBaseInfo(reqBo);
            payCenterRspBo.setData((BaseRspInfoBO)rsp);
            payCenterRspBo.setRespCode(rsp.getRspCode());
            payCenterRspBo.setRespDesc(rsp.getRspName());
            return payCenterRspBo;
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_INTFCE_SERVICE_ERROR", e.getMessage());
        }
    }
}

