/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.controller.comb;

import com.tydic.payment.pay.ability.AliH5PayAbilityService;
import com.tydic.payment.pay.ability.PayProOneCodeDealWxAbilityService;
import com.tydic.payment.pay.ability.PayProOneCodePayProcessRequestAbilityService;
import com.tydic.payment.pay.ability.QueryPayParametersAbilityService;
import com.tydic.payment.pay.ability.WXJsapiPayAbilityService;
import com.tydic.payment.pay.ability.bo.PayProOneCodeDealWxAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProOneCodeDealWxAbilityRspBo;
import com.tydic.payment.pay.ability.bo.PayProOneCodePayProcessRequestAbilityServiceReqBo;
import com.tydic.payment.pay.ability.bo.PayProOneCodePayProcessRequestAbilityServiceRspBo;
import com.tydic.payment.pay.busi.PayOrderBusiService;
import com.tydic.payment.pay.busi.PayProQueryPayOrdersWithOrderIdService;
import com.tydic.payment.pay.busi.UniQrCodeCreateScanStateBusiService;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/pay/rest/qrCode"})
public class UniQrCodePayController {
    private static final Logger LOGGER = LoggerFactory.getLogger(UniQrCodePayController.class);
    @Reference(interfaceClass=QueryPayParametersAbilityService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private QueryPayParametersAbilityService queryPayParametersAbilityService;
    @Reference(interfaceClass=AliH5PayAbilityService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private AliH5PayAbilityService aliH5PayAbilityService;
    @Reference(interfaceClass=WXJsapiPayAbilityService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private WXJsapiPayAbilityService wXJsapiPayAbilityService;
    @Reference(interfaceClass=PayOrderBusiService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private PayOrderBusiService payOrderBusiService;
    @Reference(interfaceClass=UniQrCodeCreateScanStateBusiService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private UniQrCodeCreateScanStateBusiService uniQrCodeCreateScanStateBusiService;
    @Reference(interfaceClass=PayProQueryPayOrdersWithOrderIdService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private PayProQueryPayOrdersWithOrderIdService payProQueryPayOrdersWithOrderIdService;
    @Reference(interfaceClass=PayProOneCodePayProcessRequestAbilityService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private PayProOneCodePayProcessRequestAbilityService payProOneCodePayProcessRequestAbilityService;
    @Reference(interfaceClass=PayProOneCodeDealWxAbilityService.class, version="2.0-SNAPSHOT", group="PAY_GROUP_LOCAL")
    private PayProOneCodeDealWxAbilityService payProOneCodeDealWxAbilityService;

    @RequestMapping(value={"/uniQrCodePay/{orderId}/{totalFee}"})
    public void uniQrCodePayNew(HttpServletRequest request, HttpServletResponse response, @PathVariable String orderId, @PathVariable String totalFee) throws IOException {
        LOGGER.info("\u8fdb\u5165\u4e00\u7801\u4ed8\u6d4b\u8bd5");
        String userAgent = request.getHeader("User-Agent");
        PayProOneCodePayProcessRequestAbilityServiceReqBo oneCodeReq = new PayProOneCodePayProcessRequestAbilityServiceReqBo();
        oneCodeReq.setBasePath(this.getContextPath(request));
        oneCodeReq.setOrderId(orderId);
        oneCodeReq.setTotalFee(totalFee);
        oneCodeReq.setUserAgent(userAgent);
        PayProOneCodePayProcessRequestAbilityServiceRspBo retBo = this.payProOneCodePayProcessRequestAbilityService.processRequest(oneCodeReq);
        response.sendRedirect(retBo.getRedirectUrl());
    }

    @RequestMapping(value={"/dealWxScan/{orderId}/{totalFee}"})
    public void dealWxScan(HttpServletRequest request, HttpServletResponse response, @PathVariable String orderId, @PathVariable String totalFee) throws IOException {
        LOGGER.info("\u83b7\u53d6code");
        StringBuffer basePath = this.getContextPath(request);
        String code = request.getParameter("code");
        PayProOneCodeDealWxAbilityReqBo oneCodeDealWxReqBo = new PayProOneCodeDealWxAbilityReqBo();
        oneCodeDealWxReqBo.setBasePath(basePath);
        oneCodeDealWxReqBo.setOrderId(orderId);
        oneCodeDealWxReqBo.setTotalFee(totalFee);
        oneCodeDealWxReqBo.setCode(code);
        PayProOneCodeDealWxAbilityRspBo oneCodeDealWxRetBo = this.payProOneCodeDealWxAbilityService.dealOneCodeWx(oneCodeDealWxReqBo);
        response.sendRedirect(oneCodeDealWxRetBo.getRedirectUrl());
    }

    private StringBuffer getContextPath(HttpServletRequest request) {
        int defaultPort = 80;
        int port = request.getServerPort();
        if (defaultPort == port) {
            return new StringBuffer(request.getScheme()).append("://").append(request.getServerName()).append(request.getContextPath()).append("/");
        }
        return new StringBuffer(request.getScheme()).append("://").append(request.getServerName()).append(":").append(port).append(request.getContextPath()).append("/");
    }
}

