/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.payment.pay.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.payment.pay.common.util.HttpClientUtils;
import com.tydic.payment.pay.rsa.util.EncodeUtil;
import com.tydic.payment.pay.sdk.PayCenterClient;
import com.tydic.payment.pay.sdk.PayCenterRequest;
import com.tydic.payment.pay.sdk.PayCenterResponse;
import com.tydic.payment.pay.sdk.PayCenterSdkException;
import java.io.IOException;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class DefaultPayCenterClient
implements PayCenterClient {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private String busiCode;
    private String publicKey;
    private String signkey;
    private String serverUrl;

    public DefaultPayCenterClient(String serverUrl, String busiCode, String publicKey, String signkey) {
        if (StringUtils.isEmpty((Object)serverUrl)) {
            throw new PayCenterSdkException("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1aserverUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)busiCode)) {
            throw new PayCenterSdkException("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1abusiCode\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)publicKey)) {
            throw new PayCenterSdkException("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1apublicKey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)signkey)) {
            throw new PayCenterSdkException("\u5165\u53c2\u6821\u9a8c\u5931\u8d25\uff1asignkey\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.busiCode = busiCode;
        this.publicKey = publicKey;
        this.signkey = signkey;
        this.serverUrl = serverUrl;
    }

    @Override
    public <T extends PayCenterResponse> T execute(PayCenterRequest<T> request, Class<T> targetClass) {
        PayCenterResponse retBo;
        System.out.println("\u5165\u53c2\uff1a" + JSON.toJSONString(request));
        try {
            retBo = (PayCenterResponse)targetClass.newInstance();
        }
        catch (Exception e) {
            throw new PayCenterSdkException("\u76ee\u6807\u5bf9\u8c61\u5b9e\u4f8b\u5316\u5931\u8d25", e);
        }
        String content = null;
        try {
            content = EncodeUtil.publicEncode((String)JSONObject.toJSONString(request), (String)this.publicKey, (String)this.signkey);
        }
        catch (Exception e) {
            throw new PayCenterSdkException("\u52a0\u5bc6\u5f02\u5e38", e);
        }
        HashMap<String, String> postMap = new HashMap<String, String>();
        postMap.put("busiCode", this.busiCode);
        postMap.put("content", content);
        this.LOGGER.info("\u53d1\u9001content\u4e3a\uff1a" + content);
        System.out.println("\u53d1\u9001content\u4e3a\uff1a" + content);
        String resultStr = null;
        try {
            resultStr = HttpClientUtils.doPost((String)this.serverUrl, postMap);
        }
        catch (IOException e) {
            throw new PayCenterSdkException("\u670d\u52a1\u8bf7\u6c42\u7f51\u7edc\u5f02\u5e38", e);
        }
        JSONObject jsonObject = JSON.parseObject((String)resultStr);
        String respCode = jsonObject.getString("respCode");
        String respDesc = jsonObject.getString("respDesc");
        if ("0000".equals(respCode)) {
            String rspContent = null;
            try {
                rspContent = EncodeUtil.publicDecode((String)jsonObject.getString("content"), (String)this.publicKey);
            }
            catch (Exception e) {
                throw new PayCenterSdkException("\u8fd4\u56de\u6570\u636e\u89e3\u5bc6\u5f02\u5e38", e);
            }
            retBo = (PayCenterResponse)JSON.parseObject((String)rspContent, targetClass);
        }
        retBo.setRespCode(respCode);
        retBo.setRespDesc(respDesc);
        return (T)retBo;
    }

    public String getBusiCode() {
        return this.busiCode;
    }

    public void setBusiCode(String busiCode) {
        this.busiCode = busiCode;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getSignkey() {
        return this.signkey;
    }

    public void setSignkey(String signkey) {
        this.signkey = signkey;
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }
}

