/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.ListUtils;
import com.tydic.agreement.ability.AgrDicDictionaryAbilityService;
import com.tydic.agreement.ability.bo.AgrOperateDicDictionaryAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrOperateDicDictionaryAbilityRspBO;
import com.tydic.agreement.ability.bo.AgrQryDicDictionaryByListAbilityReqBO;
import com.tydic.agreement.ability.bo.AgrQryDicDictionaryByListAbilityRspBO;
import com.tydic.commodity.bo.busi.UccDictionaryAddReqBO;
import com.tydic.commodity.bo.busi.UccDictionaryAddRspBO;
import com.tydic.commodity.bo.busi.UccDictionaryDeleteReqBO;
import com.tydic.commodity.bo.busi.UccDictionaryDeleteRspBO;
import com.tydic.commodity.bo.busi.UccDictionaryReqBO;
import com.tydic.commodity.bo.busi.UccDictionaryRspBO;
import com.tydic.commodity.bo.busi.UccDictionaryUpdateReqBO;
import com.tydic.commodity.bo.busi.UccDictionaryUpdateRspBO;
import com.tydic.commodity.busi.api.UccDicDictionaryService;
import com.tydic.order.pec.ability.es.others.UocPebDictionaryAbilityService;
import com.tydic.order.uoc.bo.other.dic.UocCoreDictionaryCreateReqBO;
import com.tydic.order.uoc.bo.other.dic.UocCoreDictionaryCreateRspBO;
import com.tydic.order.uoc.bo.other.dic.UocCoreDictionaryDeleteReqBO;
import com.tydic.order.uoc.bo.other.dic.UocCoreDictionaryDeleteRspBO;
import com.tydic.order.uoc.bo.other.dic.UocCoreDictionaryReqBO;
import com.tydic.order.uoc.bo.other.dic.UocCoreDictionaryRspBO;
import com.tydic.order.uoc.bo.other.dic.UocCoreDictionaryUpdateReqBO;
import com.tydic.order.uoc.bo.other.dic.UocCoreDictionaryUpdateRspBO;
import com.tydic.pesapp.commom.dao.ComPesDicConfigMapper;
import com.tydic.pesapp.common.ability.ComPesDictionaryOperateService;
import com.tydic.pesapp.common.ability.bo.ComPesDicDataOperateReqBO;
import com.tydic.pesapp.common.ability.bo.ComPesDicDataOperateRspBO;
import com.tydic.pesapp.common.ability.bo.ComPesDicDataQueryReqBO;
import com.tydic.pesapp.common.ability.bo.ComPesDicDataQueryRspBO;
import com.tydic.pesapp.common.ability.bo.ComPesDictionaryCodeBO;
import com.tydic.pesapp.common.po.ComPesDicConfigPO;
import com.tydic.pfscext.api.busi.FscDictionaryBusiService;
import com.tydic.pfscext.api.busi.bo.FscDictionaryBusiReqBo;
import com.tydic.pfscext.api.busi.bo.FscDictionaryBusiRspBo;
import com.tydic.pfscext.api.busi.bo.FscDictionaryCreateBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryCreateBusiRspBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryDeleteBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryDeleteBusiRspBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryUpdateBusiReqBO;
import com.tydic.pfscext.api.busi.bo.FscDictionaryUpdateBusiRspBO;
import com.tydic.umc.ability.DictionaryAbilityService;
import com.tydic.umc.ability.bo.DictionaryAbilityRspBO;
import com.tydic.umc.ability.bo.QueryDictionaryAbilityReqBO;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umc.common.UmcDicDictionaryReqBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ComPesDictionaryOperateServiceImpl
implements ComPesDictionaryOperateService {
    public static final int DICTIONARY_KEY_EXPIRE = 3600;
    public static final String DICTIONARY_KEY_PREFIX = "PES_DIC_";
    public static final String RSP_CODE_SUCCESS = "0000";
    public static final String RSP_CODE_FAILURE = "9999";
    public static final String PEB_CODE = "PEB";
    public static final String UMC_CODE = "UMC";
    public static final String UCC_CODE = "UCC";
    public static final String FSC_CODE = "FSC";
    public static final String AGR_CODE = "AGR";
    public static final Integer QUERY = 0;
    public static final Integer INSERT = 1;
    public static final Integer UPDATE = 2;
    public static final Integer DELETE = 3;
    private static final Logger LOGGER = LoggerFactory.getLogger(ComPesDictionaryOperateServiceImpl.class);
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private ComPesDicConfigMapper pesDicConfigMapper;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_DEV")
    private UocPebDictionaryAbilityService uocPebDictionaryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="service")
    private DictionaryAbilityService umcDictionaryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UCC_GROUP_DEV")
    private UccDicDictionaryService uccDicDictionaryService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="FSC_GROUP_DEV")
    private FscDictionaryBusiService fscDictionaryBusiService;
    @HSFConsumer(serviceVersion="2.0.0", serviceGroup="AGR_GROUP_DEV")
    private AgrDicDictionaryAbilityService agrDicDictionaryAbilityService;
    private static Map<String, BiFunction<Integer, ComPesDictionaryCodeBO, List<ComPesDictionaryCodeBO>>> dicActionMap = Maps.newHashMapWithExpectedSize((int)4);

    public ComPesDictionaryOperateServiceImpl() {
        dicActionMap.put(PEB_CODE, this::callPebDicService);
        dicActionMap.put(UMC_CODE, this::callUmcDicService);
        dicActionMap.put(UCC_CODE, this::callUccDicService);
        dicActionMap.put(FSC_CODE, this::callFscDicService);
        dicActionMap.put(AGR_CODE, this::callAgrDicService);
    }

    public ComPesDicDataQueryRspBO queryCodeList(ComPesDicDataQueryReqBO reqBO) {
        ComPesDicDataQueryRspBO rspBO = new ComPesDicDataQueryRspBO();
        if (CollectionUtils.isEmpty((Collection)reqBO.getConfigKeys())) {
            rspBO.setRespCode(RSP_CODE_FAILURE);
            rspBO.setRespDesc("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            return rspBO;
        }
        HashMap<String, List<ComPesDictionaryCodeBO>> rspData = Maps.newHashMapWithExpectedSize((int)reqBO.getConfigKeys().size());
        List<String> callConfigKeys = this.cacheDataProcess(reqBO.getConfigKeys(), (Map<String, List<ComPesDictionaryCodeBO>>)rspData);
        if (!CollectionUtils.isEmpty(callConfigKeys)) {
            List<ComPesDicConfigPO> configList = this.pesDicConfigMapper.getListByConfigKeys(callConfigKeys);
            if (CollectionUtils.isEmpty(configList)) {
                rspBO.setRespCode(RSP_CODE_FAILURE);
                rspBO.setRespDesc("\u83b7\u53d6\u5b57\u5178\u914d\u7f6e\u4e3a\u7a7a\uff0ccallConfigKeys=" + callConfigKeys.toString());
                return rspBO;
            }
            Map<String, ComPesDicConfigPO> dicMap = configList.stream().collect(Collectors.toMap(ComPesDicConfigPO::getConfigKey, Function.identity()));
            HashMap<String, ComPesDicConfigPO> pCodeMap = new HashMap<String, ComPesDicConfigPO>();
            for (ComPesDicConfigPO comPesDicConfigPO : configList) {
                pCodeMap.put(comPesDicConfigPO.getPCode(), comPesDicConfigPO);
            }
            pCodeMap.keySet().forEach(pCodeKey -> this.cacheClient.delete(pCodeKey));
            this.dicDataProcess(callConfigKeys, dicMap, rspData);
        }
        if (rspData != null && (StringUtils.isNotBlank((CharSequence)reqBO.getCode()) || StringUtils.isNotBlank((CharSequence)reqBO.getTitle()))) {
            HashMap<String, List<ComPesDictionaryCodeBO>> tempRspData = new HashMap<String, List<ComPesDictionaryCodeBO>>();
            for (String key : rspData.keySet()) {
                List tempDicCodeList = (List)rspData.get(key);
                ArrayList<ComPesDictionaryCodeBO> newDicCodeList = new ArrayList<ComPesDictionaryCodeBO>();
                if (tempDicCodeList != null) {
                    for (ComPesDictionaryCodeBO comPesDictionaryCodeBO : tempDicCodeList) {
                        if (StringUtils.isNotBlank((CharSequence)reqBO.getCode()) && !comPesDictionaryCodeBO.getCode().contains(reqBO.getCode()) || StringUtils.isNotBlank((CharSequence)reqBO.getTitle()) && !comPesDictionaryCodeBO.getTitle().contains(reqBO.getTitle())) continue;
                        newDicCodeList.add(comPesDictionaryCodeBO);
                    }
                }
                tempRspData.put(key, newDicCodeList);
            }
            rspData = tempRspData;
        }
        rspBO.setData((Map)rspData);
        rspBO.setRespCode(RSP_CODE_SUCCESS);
        rspBO.setRespDesc("\u83b7\u53d6\u6570\u636e\u6210\u529f");
        return rspBO;
    }

    public ComPesDicDataOperateRspBO dealCodeOperate(ComPesDicDataOperateReqBO reqBO) {
        if (reqBO.getOperateType() == null) {
            throw new ZTBusinessException("\u4f20\u5165[operateType]\u4e3a\u7a7a");
        }
        if (!(INSERT.equals(reqBO.getOperateType()) || UPDATE.equals(reqBO.getOperateType()) || DELETE.equals(reqBO.getOperateType()))) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u7684\u64cd\u4f5c\u7c7b\u578b[operateType]");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getCenter())) {
            throw new ZTBusinessException("\u4f20\u5165[center]\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getConfigKey())) {
            throw new ZTBusinessException("\u4f20\u5165[configKey]\u4e3a\u7a7a");
        }
        if (dicActionMap.get(reqBO.getCenter()) == null) {
            throw new ZTBusinessException("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + reqBO.getCenter());
        }
        List<ComPesDictionaryCodeBO> rspInfo = dicActionMap.get(reqBO.getCenter()).apply(reqBO.getOperateType(), reqBO.getDictionaryCode());
        ComPesDicDataOperateRspBO rspBO = new ComPesDicDataOperateRspBO();
        rspBO.setRespCode(rspInfo.get(0).getRespCode());
        rspBO.setRespDesc(rspInfo.get(0).getRespDesc());
        if (RSP_CODE_SUCCESS.equals(rspBO.getRespCode())) {
            ComPesDicDataQueryReqBO refreshReqBO = new ComPesDicDataQueryReqBO();
            refreshReqBO.setConfigKeys(Collections.singletonList(reqBO.getConfigKey()));
            this.refreshCodeList(refreshReqBO);
        }
        return rspBO;
    }

    public void refreshCodeList(ComPesDicDataQueryReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getConfigKeys())) {
            LOGGER.error("\u4f20\u5165[configKeys]\u4e3a\u7a7a");
            return;
        }
        reqBO.getConfigKeys().forEach(config -> this.cacheClient.delete(DICTIONARY_KEY_PREFIX + config));
        this.queryCodeList(reqBO);
    }

    private List<String> cacheDataProcess(List<String> configKeys, Map<String, List<ComPesDictionaryCodeBO>> rspData) {
        ArrayList notExistsKeys = Lists.newArrayListWithExpectedSize((int)configKeys.size());
        for (String configKey : configKeys) {
            List dicList = (List)this.cacheClient.get(DICTIONARY_KEY_PREFIX + configKey);
            if (CollectionUtils.isEmpty((Collection)dicList)) {
                notExistsKeys.add(configKey);
                continue;
            }
            rspData.put(configKey, dicList);
        }
        return notExistsKeys;
    }

    private void dicDataProcess(List<String> configKeys, Map<String, ComPesDicConfigPO> dicMap, Map<String, List<ComPesDictionaryCodeBO>> rspData) {
        for (String configKey : configKeys) {
            if (dicMap.get(configKey) == null) {
                rspData.put(configKey, Lists.newArrayList());
                LOGGER.error("\u672a\u83b7\u53d6\u5230\u5b57\u5178\u914d\u7f6e\uff0cconfigKey=" + configKey);
                continue;
            }
            ComPesDicConfigPO dicInfo = dicMap.get(configKey);
            if (dicActionMap.get(dicInfo.getCenter()) == null) {
                rspData.put(configKey, Lists.newArrayList());
                LOGGER.error("\u4e0d\u652f\u6301\u8c03\u7528\u8be5\u4e2d\u5fc3\u5b57\u5178\u670d\u52a1\uff0ccenter=" + dicInfo.getCenter());
                continue;
            }
            ComPesDictionaryCodeBO param = new ComPesDictionaryCodeBO();
            param.setPCode(dicInfo.getPCode());
            List<ComPesDictionaryCodeBO> dicList = dicActionMap.get(dicInfo.getCenter()).apply(QUERY, param);
            rspData.put(configKey, dicList);
            if (CollectionUtils.isEmpty(dicList)) {
                LOGGER.info("{}\u5b57\u5178\u670d\u52a1\u672a\u8fd4\u56de\u5b57\u5178\u6570\u636e\uff0cpCode={}", (Object)dicInfo.getCenter(), (Object)dicInfo.getPCode());
                continue;
            }
            this.cacheClient.set(DICTIONARY_KEY_PREFIX + configKey, dicList, ComPesDictionaryOperateServiceImpl.getExpireSeconds(3600, 10));
        }
    }

    public static int getExpireSeconds(int radix, int range) {
        return radix * (new Random().nextInt(range) + 1);
    }

    private List<ComPesDictionaryCodeBO> callAgrDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            AgrQryDicDictionaryByListAbilityReqBO agrQryDicDictionaryByListAbilityReqBO = new AgrQryDicDictionaryByListAbilityReqBO();
            agrQryDicDictionaryByListAbilityReqBO.setpCode(dictionaryCode.getPCode());
            AgrQryDicDictionaryByListAbilityRspBO agrQryDicDictionaryByListAbilityRspBO = this.agrDicDictionaryAbilityService.queryDicDictionaryByList(agrQryDicDictionaryByListAbilityReqBO);
            List rows = agrQryDicDictionaryByListAbilityRspBO.getRows();
            return CollectionUtils.isEmpty((Collection)rows) ? Lists.newArrayList() : ListUtils.copyListProperties((List)rows, ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            AgrOperateDicDictionaryAbilityReqBO agrOperateDicDictionaryAbilityReqBO = new AgrOperateDicDictionaryAbilityReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)agrOperateDicDictionaryAbilityReqBO);
            agrOperateDicDictionaryAbilityReqBO.setOperType(Integer.valueOf(1));
            AgrOperateDicDictionaryAbilityRspBO agrOperateDicDictionaryAbilityRspBO = this.agrDicDictionaryAbilityService.operateDicDictionary(agrOperateDicDictionaryAbilityReqBO);
            rspBO.setRespCode(agrOperateDicDictionaryAbilityRspBO.getRespCode());
            rspBO.setRespDesc(agrOperateDicDictionaryAbilityRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            AgrOperateDicDictionaryAbilityReqBO agrOperateDicDictionaryAbilityReqBO = new AgrOperateDicDictionaryAbilityReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)agrOperateDicDictionaryAbilityReqBO);
            agrOperateDicDictionaryAbilityReqBO.setOperType(Integer.valueOf(3));
            AgrOperateDicDictionaryAbilityRspBO agrOperateDicDictionaryAbilityRspBO = this.agrDicDictionaryAbilityService.operateDicDictionary(agrOperateDicDictionaryAbilityReqBO);
            rspBO.setRespCode(agrOperateDicDictionaryAbilityRspBO.getRespCode());
            rspBO.setRespDesc(agrOperateDicDictionaryAbilityRspBO.getRespDesc());
        } else {
            AgrOperateDicDictionaryAbilityReqBO agrOperateDicDictionaryAbilityReqBO = new AgrOperateDicDictionaryAbilityReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)agrOperateDicDictionaryAbilityReqBO);
            agrOperateDicDictionaryAbilityReqBO.setOperType(Integer.valueOf(2));
            AgrOperateDicDictionaryAbilityRspBO agrOperateDicDictionaryAbilityRspBO = this.agrDicDictionaryAbilityService.operateDicDictionary(agrOperateDicDictionaryAbilityReqBO);
            rspBO.setRespCode(agrOperateDicDictionaryAbilityRspBO.getRespCode());
            rspBO.setRespDesc(agrOperateDicDictionaryAbilityRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callPebDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            UocCoreDictionaryReqBO reqBO = new UocCoreDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            UocCoreDictionaryRspBO qryRspBO = this.uocPebDictionaryAbilityService.qryDic(reqBO);
            List rspList = qryRspBO.getRows();
            return CollectionUtils.isEmpty((Collection)rspList) ? Lists.newArrayList() : ListUtils.copyListProperties((List)rspList, ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UocCoreDictionaryCreateReqBO reqBO = new UocCoreDictionaryCreateReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setpCode(dictionaryCode.getPCode());
            UocCoreDictionaryCreateRspBO addRspBO = this.uocPebDictionaryAbilityService.createDic(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UocCoreDictionaryUpdateReqBO reqBO = new UocCoreDictionaryUpdateReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setpCode(dictionaryCode.getPCode());
            UocCoreDictionaryUpdateRspBO updateRspBO = this.uocPebDictionaryAbilityService.updateDic(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            UocCoreDictionaryDeleteReqBO reqBO = new UocCoreDictionaryDeleteReqBO();
            reqBO.setpCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            UocCoreDictionaryDeleteRspBO delRspBO = this.uocPebDictionaryAbilityService.deleteDic(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUmcDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            QueryDictionaryAbilityReqBO reqBO = new QueryDictionaryAbilityReqBO();
            reqBO.setPcode(dictionaryCode.getPCode());
            UmcRspListBO qryRspBO = this.umcDictionaryAbilityService.queryBypCodeBackPo(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : ListUtils.copyListProperties((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UmcDicDictionaryReqBO reqBO = new UmcDicDictionaryReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            DictionaryAbilityRspBO addRspBO = this.umcDictionaryAbilityService.addDicDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UmcDicDictionaryReqBO reqBO = new UmcDicDictionaryReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            DictionaryAbilityRspBO updateRspBO = this.umcDictionaryAbilityService.updateDicDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            UmcDicDictionaryReqBO reqBO = new UmcDicDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            DictionaryAbilityRspBO delRspBO = this.umcDictionaryAbilityService.deleteDicDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callUccDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            UccDictionaryReqBO reqBO = new UccDictionaryReqBO();
            reqBO.setPCode(dictionaryCode.getPCode());
            UccDictionaryRspBO qryRspBO = this.uccDicDictionaryService.queryDictionary(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : ListUtils.copyListProperties((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            UccDictionaryAddReqBO reqBO = new UccDictionaryAddReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            UccDictionaryAddRspBO addRspBO = this.uccDicDictionaryService.insertDictionary(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            UccDictionaryUpdateReqBO reqBO = new UccDictionaryUpdateReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            UccDictionaryUpdateRspBO updateRspBO = this.uccDicDictionaryService.updateDictionary(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            UccDictionaryDeleteReqBO reqBO = new UccDictionaryDeleteReqBO();
            reqBO.setPtypeCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            UccDictionaryDeleteRspBO delRspBO = this.uccDicDictionaryService.deleteDictionary(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }

    private List<ComPesDictionaryCodeBO> callFscDicService(Integer operateType, ComPesDictionaryCodeBO dictionaryCode) {
        ComPesDictionaryCodeBO rspBO = new ComPesDictionaryCodeBO();
        if (QUERY.equals(operateType)) {
            FscDictionaryBusiReqBo reqBO = new FscDictionaryBusiReqBo();
            reqBO.setpCode(dictionaryCode.getPCode());
            FscDictionaryBusiRspBo qryRspBO = this.fscDictionaryBusiService.qryDic(reqBO);
            return CollectionUtils.isEmpty((Collection)qryRspBO.getRows()) ? Lists.newArrayList() : ListUtils.copyListProperties((List)qryRspBO.getRows(), ComPesDictionaryCodeBO.class);
        }
        if (INSERT.equals(operateType)) {
            FscDictionaryCreateBusiReqBO reqBO = new FscDictionaryCreateBusiReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setpCode(dictionaryCode.getPCode());
            FscDictionaryCreateBusiRspBO addRspBO = this.fscDictionaryBusiService.createDic(reqBO);
            rspBO.setRespCode(addRspBO.getRespCode());
            rspBO.setRespDesc(addRspBO.getRespDesc());
        } else if (UPDATE.equals(operateType)) {
            FscDictionaryUpdateBusiReqBO reqBO = new FscDictionaryUpdateBusiReqBO();
            BeanUtils.copyProperties((Object)dictionaryCode, (Object)reqBO);
            reqBO.setpCode(dictionaryCode.getPCode());
            FscDictionaryUpdateBusiRspBO updateRspBO = this.fscDictionaryBusiService.updateDic(reqBO);
            rspBO.setRespCode(updateRspBO.getRespCode());
            rspBO.setRespDesc(updateRspBO.getRespDesc());
        } else {
            FscDictionaryDeleteBusiReqBO reqBO = new FscDictionaryDeleteBusiReqBO();
            reqBO.setpCode(dictionaryCode.getPCode());
            reqBO.setCode(dictionaryCode.getCode());
            FscDictionaryDeleteBusiRspBO delRspBO = this.fscDictionaryBusiService.deleteDic(reqBO);
            rspBO.setRespCode(delRspBO.getRespCode());
            rspBO.setRespDesc(delRspBO.getRespDesc());
        }
        return Collections.singletonList(rspBO);
    }
}

