/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.config;

import cn.hutool.core.util.ReflectUtil;
import cn.hutool.core.util.StrUtil;
import com.tydic.pesapp.base.api.utils.PesappRspUtil;
import com.tydic.pesapp.commom.dao.UmcInfoRspDescConvertMapper;
import com.tydic.pesapp.common.po.UmcInfoRspDescConvertPo;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Aspect
@Order(value=0)
public class AppCenterAbilityRespDescResoverAspect {
    private static final Logger log = LoggerFactory.getLogger(AppCenterAbilityRespDescResoverAspect.class);
    private Map<String, String> respCodeMap = new HashMap<String, String>();
    @Autowired
    private UmcInfoRspDescConvertMapper umcInfoRspDescConvertMapper;
    @Value(value="${pesapp.common.respcode.convert.enable:true}")
    private boolean convertEnable;

    public void cleanCache() {
        log.info("\u6e05\u9664respMsg\u7f13\u5b58");
        this.respCodeMap.clear();
    }

    @Pointcut(value="execution(public * com.tydic.merchant.mmc.ability..*.*(..)) ")
    public void abilityPointCut() {
    }

    @Around(value="abilityPointCut()")
    public Object throwAopTreat(ProceedingJoinPoint pjp) throws Throwable {
        Object rspObj = null;
        try {
            String respCode;
            rspObj = pjp.proceed();
            if (this.convertEnable && !"0000".equals(respCode = PesappRspUtil.getRespCode((Object)rspObj))) {
                String newRespDesc;
                if (this.respCodeMap.isEmpty()) {
                    UmcInfoRspDescConvertPo qryPo = new UmcInfoRspDescConvertPo();
                    List<UmcInfoRspDescConvertPo> umcInfoRspDescConvertPos = this.umcInfoRspDescConvertMapper.qryByCondition(qryPo);
                    for (UmcInfoRspDescConvertPo descConvertPo : umcInfoRspDescConvertPos) {
                        this.respCodeMap.put(descConvertPo.getCenterRespCode(), descConvertPo.getAppMsg());
                    }
                }
                if (!StrUtil.isEmpty((CharSequence)(newRespDesc = this.respCodeMap.get(respCode)))) {
                    PesappRspUtil.setRespDesc((Object)rspObj, (String)newRespDesc);
                }
            }
        }
        catch (Throwable e) {
            String message = e.getMessage();
            if (rspObj != null) {
                PesappRspUtil.setRespDesc((Object)rspObj, (String)message);
            } else if (pjp.getClass() == MethodInvocationProceedingJoinPoint.class) {
                MethodInvocationProceedingJoinPoint methodPjp = (MethodInvocationProceedingJoinPoint)pjp;
                Object methodInvocation = ReflectUtil.getFieldValue((Object)methodPjp, (String)"methodInvocation");
                Method method = (Method)ReflectUtil.getFieldValue((Object)methodInvocation, (String)"method");
                Class<?> returnType = method.getReturnType();
                Object createObj = returnType.newInstance();
                PesappRspUtil.setRespDesc(createObj, (String)message);
                PesappRspUtil.setCommonErrorRespDesc(createObj);
                rspObj = createObj;
            }
            log.error("\u8c03\u7528\u5f02\u5e38:{}", (Object)message);
        }
        return rspObj;
    }
}

