/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.ability.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.pesapp.common.ability.ComRfOrderCountDayReportService;
import com.tydic.pesapp.common.ability.bo.ComRfOrderCountDayListPageReqBO;
import com.tydic.pesapp.common.ability.bo.ComRfOrderCountDayListPageRspBO;
import com.tydic.pesapp.common.ability.bo.ComRfOrderCountDayReportBO;
import com.tydic.pesapp.common.ability.bo.ComRfOrderCountDayReportReqBO;
import com.tydic.pesapp.common.ability.bo.ComRfOrderCountDayReportRspBO;
import com.tydic.pesapp.ref.db.HiveDruidTemplate;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class ComRfOrderCountDayReportServiceImpl
implements ComRfOrderCountDayReportService {
    private static final Logger log = LoggerFactory.getLogger(ComRfOrderCountDayReportServiceImpl.class);
    @Autowired
    HiveDruidTemplate hiveDruidTemplate;

    public ComRfOrderCountDayReportRspBO queryRfOrderCountDayReport(ComRfOrderCountDayReportReqBO comRfOrderCountDayReportReqBO) {
        StringBuffer sql = new StringBuffer("select * from order_count_day_report where 1=1");
        if (StringUtils.isNotBlank((CharSequence)comRfOrderCountDayReportReqBO.getDayTimeStart())) {
            sql.append(" and day_time >= '");
            sql.append(comRfOrderCountDayReportReqBO.getDayTimeStart());
            sql.append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)comRfOrderCountDayReportReqBO.getDayTimeEnd())) {
            sql.append(" and day_time <= '");
            sql.append(comRfOrderCountDayReportReqBO.getDayTimeEnd());
            sql.append("'");
        }
        log.info("Running: " + sql);
        ComRfOrderCountDayReportRspBO result = new ComRfOrderCountDayReportRspBO();
        List data = new ArrayList();
        try {
            data = this.hiveDruidTemplate.createNewJdbcTemplate().query(sql.toString(), (RowMapper)new RowMapper<ComRfOrderCountDayReportBO>(){

                public ComRfOrderCountDayReportBO mapRow(ResultSet rs, int index) throws SQLException {
                    ComRfOrderCountDayReportBO comRfOrderCountDayReportBO = new ComRfOrderCountDayReportBO();
                    comRfOrderCountDayReportBO.setDayTime(rs.getString("day_time"));
                    comRfOrderCountDayReportBO.setLoginNum(Long.valueOf(rs.getLong("login_num")));
                    comRfOrderCountDayReportBO.setOrderNum(Long.valueOf(rs.getLong("order_num")));
                    comRfOrderCountDayReportBO.setTotalPaySale(Double.valueOf((double)rs.getLong("total_pay_sale") / 10000.0));
                    comRfOrderCountDayReportBO.setPayOrderNum(Long.valueOf(rs.getLong("pay_order_num")));
                    comRfOrderCountDayReportBO.setPayItemNum(Long.valueOf(rs.getLong("pay_item_num")));
                    comRfOrderCountDayReportBO.setCloseOrderNum(Long.valueOf(rs.getLong("close_order_num")));
                    comRfOrderCountDayReportBO.setAsOrderNum(Long.valueOf(rs.getLong("as_order_num")));
                    comRfOrderCountDayReportBO.setAsOrderSucNum(Long.valueOf(rs.getLong("as_order_suc_num")));
                    comRfOrderCountDayReportBO.setRefundOrderNum(Long.valueOf(rs.getLong("refund_order_num")));
                    comRfOrderCountDayReportBO.setRefundOrderSale(Long.valueOf(rs.getLong("refund_order_sale")));
                    return comRfOrderCountDayReportBO;
                }
            });
            result.setData(data);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return result;
    }

    public ComRfOrderCountDayListPageRspBO queryRfOrderCountDayListPage(ComRfOrderCountDayListPageReqBO comRfOrderCountDayListPageReqBO) {
        if (StringUtils.isBlank((CharSequence)comRfOrderCountDayListPageReqBO.getPurNo())) {
            comRfOrderCountDayListPageReqBO.setPurNo("#ALL");
        }
        Integer pageNo = 1;
        Integer pageSize = 10;
        Integer recordsTotal = 0;
        Integer total = 0;
        Integer startRowNum = 0;
        if (comRfOrderCountDayListPageReqBO.getPageNo() != null || comRfOrderCountDayListPageReqBO.getPageNo() >= 1) {
            pageNo = comRfOrderCountDayListPageReqBO.getPageNo();
        }
        if (comRfOrderCountDayListPageReqBO.getPageSize() != null || comRfOrderCountDayListPageReqBO.getPageSize() >= 1) {
            pageSize = comRfOrderCountDayListPageReqBO.getPageSize();
        }
        startRowNum = (pageNo - 1) * pageSize + 1;
        StringBuffer countRecordsTotalSql = new StringBuffer("select * from order_count_day_temp where pur_no = '#empty'");
        if (StringUtils.isNotBlank((CharSequence)comRfOrderCountDayListPageReqBO.getDayTimeStart())) {
            countRecordsTotalSql.append(" and day_time >= '");
            countRecordsTotalSql.append(comRfOrderCountDayListPageReqBO.getDayTimeStart());
            countRecordsTotalSql.append("'");
        }
        if (StringUtils.isNotBlank((CharSequence)comRfOrderCountDayListPageReqBO.getDayTimeEnd())) {
            countRecordsTotalSql.append(" and day_time <= '");
            countRecordsTotalSql.append(comRfOrderCountDayListPageReqBO.getDayTimeEnd());
            countRecordsTotalSql.append("'");
        }
        ComRfOrderCountDayListPageRspBO result = new ComRfOrderCountDayListPageRspBO();
        try {
            log.info("Running: " + countRecordsTotalSql);
            List countList = new ArrayList();
            countList = this.hiveDruidTemplate.createNewJdbcTemplate().query(countRecordsTotalSql.toString(), (RowMapper)new RowMapper<ComRfOrderCountDayReportBO>(){

                public ComRfOrderCountDayReportBO mapRow(ResultSet rs, int index) throws SQLException {
                    ComRfOrderCountDayReportBO comRfOrderCountDayReportBO = new ComRfOrderCountDayReportBO();
                    return comRfOrderCountDayReportBO;
                }
            });
            if (countList != null && countList.size() > 0) {
                recordsTotal = countList.size();
            }
            total = recordsTotal / pageSize + 1;
            result.setPageNo(pageNo);
            result.setTotal(total);
            result.setRecordsTotal(recordsTotal);
            if (pageSize > total) {
                pageSize = total;
            }
            StringBuffer selectLoginNumSql = countRecordsTotalSql.append(" and rnum >= ").append(startRowNum).append(" limit " + pageSize);
            log.info("Running: " + selectLoginNumSql);
            List loginNumList = new ArrayList();
            loginNumList = this.hiveDruidTemplate.createNewJdbcTemplate().query(selectLoginNumSql.toString(), (RowMapper)new RowMapper<ComRfOrderCountDayReportBO>(){

                public ComRfOrderCountDayReportBO mapRow(ResultSet rs, int index) throws SQLException {
                    ComRfOrderCountDayReportBO comRfOrderCountDayReportBO = new ComRfOrderCountDayReportBO();
                    comRfOrderCountDayReportBO.setDayTime(rs.getString("day_time"));
                    comRfOrderCountDayReportBO.setLoginNum(Long.valueOf(rs.getLong("login_num")));
                    return comRfOrderCountDayReportBO;
                }
            });
            if (loginNumList != null && loginNumList.size() > 0) {
                StringBuffer selectPurNoReportSql = new StringBuffer("select * from order_count_day_report where pur_no = '");
                selectPurNoReportSql.append(comRfOrderCountDayListPageReqBO.getPurNo());
                selectPurNoReportSql.append("'");
                if (StringUtils.isNotBlank((CharSequence)comRfOrderCountDayListPageReqBO.getDayTimeStart())) {
                    selectPurNoReportSql.append(" and day_time >= '");
                    selectPurNoReportSql.append(comRfOrderCountDayListPageReqBO.getDayTimeStart());
                    selectPurNoReportSql.append("'");
                }
                if (StringUtils.isNotBlank((CharSequence)comRfOrderCountDayListPageReqBO.getDayTimeEnd())) {
                    selectPurNoReportSql.append(" and day_time <= '");
                    selectPurNoReportSql.append(comRfOrderCountDayListPageReqBO.getDayTimeEnd());
                    selectPurNoReportSql.append("'");
                }
                selectPurNoReportSql.append(" and rnum >= ");
                selectPurNoReportSql.append(startRowNum);
                selectPurNoReportSql.append(" limit ");
                selectPurNoReportSql.append(pageSize);
                log.info("Running: " + selectPurNoReportSql);
                List purNoReportList = new ArrayList();
                purNoReportList = this.hiveDruidTemplate.createNewJdbcTemplate().query(selectPurNoReportSql.toString(), (RowMapper)new RowMapper<ComRfOrderCountDayReportBO>(){

                    public ComRfOrderCountDayReportBO mapRow(ResultSet rs, int index) throws SQLException {
                        ComRfOrderCountDayReportBO comRfOrderCountDayReportBO = new ComRfOrderCountDayReportBO();
                        comRfOrderCountDayReportBO.setDayTime(rs.getString("day_time"));
                        comRfOrderCountDayReportBO.setLoginNum(Long.valueOf(rs.getLong("login_num")));
                        comRfOrderCountDayReportBO.setOrderNum(Long.valueOf(rs.getLong("order_num")));
                        comRfOrderCountDayReportBO.setTotalPaySale(Double.valueOf((double)rs.getLong("total_pay_sale") / 10000.0));
                        comRfOrderCountDayReportBO.setPayOrderNum(Long.valueOf(rs.getLong("pay_order_num")));
                        comRfOrderCountDayReportBO.setPayItemNum(Long.valueOf(rs.getLong("pay_item_num")));
                        comRfOrderCountDayReportBO.setCloseOrderNum(Long.valueOf(rs.getLong("close_order_num")));
                        comRfOrderCountDayReportBO.setAsOrderNum(Long.valueOf(rs.getLong("as_order_num")));
                        comRfOrderCountDayReportBO.setAsOrderSucNum(Long.valueOf(rs.getLong("as_order_suc_num")));
                        comRfOrderCountDayReportBO.setRefundOrderNum(Long.valueOf(rs.getLong("refund_order_num")));
                        comRfOrderCountDayReportBO.setRefundOrderSale(Long.valueOf(rs.getLong("refund_order_sale")));
                        return comRfOrderCountDayReportBO;
                    }
                });
                if (purNoReportList != null && purNoReportList.size() > 0) {
                    ArrayList<ComRfOrderCountDayReportBO> orderCountDayReportList = new ArrayList<ComRfOrderCountDayReportBO>();
                    for (ComRfOrderCountDayReportBO loginNumBO : loginNumList) {
                        for (ComRfOrderCountDayReportBO purNoReportBO : purNoReportList) {
                            if (!loginNumBO.getDayTime().equals(purNoReportBO.getDayTime())) continue;
                            Long loginNum = loginNumBO.getLoginNum();
                            BeanUtils.copyProperties((Object)purNoReportBO, (Object)loginNumBO);
                            loginNumBO.setLoginNum(loginNum);
                            break;
                        }
                        orderCountDayReportList.add(loginNumBO);
                    }
                    result.setRows(orderCountDayReportList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw new ZTBusinessException("\u67e5\u8be2\u5206\u9875\u62a5\u8868\u6267\u884c\u5931\u8d25");
        }
        return result;
    }
}

