/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.ability.impl;

import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pesapp.common.ability.PesappCommonBatchDownloadService;
import com.tydic.pesapp.common.ability.bo.PesappCommonAttachmentInfoBO;
import com.tydic.pesapp.common.ability.bo.PesappCommonBatchDownloadReqBO;
import com.tydic.pesapp.common.ability.bo.PesappCommonBatchDownloadRspBO;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class PesappCommonBatchDownloadServiceImpl
implements PesappCommonBatchDownloadService {
    private static final Logger log = LoggerFactory.getLogger(PesappCommonBatchDownloadServiceImpl.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "pesapp-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PesappCommonBatchDownloadRspBO batchDownload(PesappCommonBatchDownloadReqBO reqBO) {
        PesappCommonBatchDownloadRspBO rspBO = new PesappCommonBatchDownloadRspBO();
        URL rootPath = PesappCommonBatchDownloadServiceImpl.class.getResource("/");
        String rootPathStr = rootPath.getPath() + "temp" + System.currentTimeMillis();
        File directoryFile = new File(rootPathStr);
        if (!directoryFile.exists()) {
            directoryFile.mkdir();
        }
        CloseableHttpClient httpClient = HttpClientBuilder.create().build();
        if (reqBO.getBatchFile() != null) {
            for (PesappCommonAttachmentInfoBO attachmentInfoBO : reqBO.getBatchFile()) {
                HttpGet httpGet = new HttpGet(attachmentInfoBO.getAttachmentAddr());
                CloseableHttpResponse response = null;
                InputStream content = null;
                FileOutputStream fileOutputStream = null;
                try {
                    response = httpClient.execute((HttpUriRequest)httpGet);
                    if (response.getStatusLine().getStatusCode() == 200) {
                        int len;
                        HttpEntity responseEntity = response.getEntity();
                        File downloadFile = new File(rootPathStr + "/" + attachmentInfoBO.getAttachmentName());
                        content = responseEntity.getContent();
                        fileOutputStream = new FileOutputStream(downloadFile);
                        byte[] buff = new byte[1024];
                        while ((len = content.read(buff)) != -1) {
                            fileOutputStream.write(buff, 0, len);
                        }
                        fileOutputStream.flush();
                        continue;
                    }
                    log.error(attachmentInfoBO.getAttachmentName() + "\u4e0b\u8f7d\u5931\u8d25\uff01");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                finally {
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (content != null) {
                        try {
                            content.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    if (response == null) continue;
                    try {
                        response.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            String fileUrl;
            String zipFileName = UUID.randomUUID().toString().replaceAll("-", "") + ".zip";
            File zipFile = new File(rootPathStr + "/" + zipFileName);
            this.generateZipFile(directoryFile.listFiles(), zipFile);
            FileInputStream inputStream = new FileInputStream(zipFile);
            String path = this.fileClient.uploadFileByInputStream(PATH, zipFileName, (InputStream)inputStream);
            if ("OSS".equals(this.fileType)) {
                fileUrl = this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                fileUrl = this.fastdfsTrackerServers.substring(0, this.fastdfsTrackerServers.indexOf(":") + 1) + this.fastdfsHttpTrackerHttpPort + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                fileUrl = "";
            }
            rspBO.setCompressFileUrl(fileUrl);
            this.deleteTempFile(directoryFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }

    private boolean deleteTempFile(File file) {
        if (file.isDirectory()) {
            File[] subFiles = file.listFiles();
            if (subFiles != null) {
                int subFileCount = subFiles.length;
                int deleteFileCount = 0;
                for (File subFile : subFiles) {
                    if (!subFile.delete()) continue;
                    ++deleteFileCount;
                }
                if (subFileCount == deleteFileCount) {
                    return file.delete();
                }
                return false;
            }
            return file.delete();
        }
        return file.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateZipFile(File[] subFiles, File zipFile) {
        if (!zipFile.exists()) {
            try {
                zipFile.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream fileOutputStream = null;
        ZipOutputStream zipOutputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileOutputStream = new FileOutputStream(zipFile);
            zipOutputStream = new ZipOutputStream(fileOutputStream);
            ZipEntry zipEntry = null;
            if (subFiles != null) {
                for (File subFile : subFiles) {
                    int len;
                    fileInputStream = new FileInputStream(subFile);
                    zipEntry = new ZipEntry(subFile.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    byte[] buff = new byte[1024];
                    while ((len = fileInputStream.read(buff)) != -1) {
                        zipOutputStream.write(buff, 0, len);
                    }
                }
                zipOutputStream.closeEntry();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (zipOutputStream != null) {
                    zipOutputStream.close();
                }
                if (fileOutputStream != null) {
                    fileOutputStream.close();
                }
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

