/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.authority.controller.workday;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.workday.bo.DeleteSpecialDateByIdReqBO;
import com.ohaotian.authority.workday.bo.QrySpecialDateReqBO;
import com.ohaotian.authority.workday.bo.SelectEndWorkdayReqBO;
import com.ohaotian.authority.workday.bo.SelectSpecialDayByIdReqBO;
import com.ohaotian.authority.workday.bo.SelectSpecialDayByIdRspBO;
import com.ohaotian.authority.workday.bo.SelectWorkDayCountByDateReqBO;
import com.ohaotian.authority.workday.bo.SpecialDateReqBO;
import com.ohaotian.authority.workday.service.AddSpecialDateService;
import com.ohaotian.authority.workday.service.DeleteSpecialDateByIdService;
import com.ohaotian.authority.workday.service.QrySpecialDateService;
import com.ohaotian.authority.workday.service.SelectEndWorkdayService;
import com.ohaotian.authority.workday.service.SelectSpecialDayByIdService;
import com.ohaotian.authority.workday.service.SelectWorkDayCountByDateService;
import com.ohaotian.authority.workday.service.UpdateSpecialDateService;
import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pesapp.common.authority.controller.logger.LoggerController;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/author/workday"}, method={RequestMethod.GET, RequestMethod.POST})
public class WorkdayController {
    private static final Logger log = LoggerFactory.getLogger(WorkdayController.class);
    private Logger logger = LoggerFactory.getLogger(LoggerController.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private AddSpecialDateService addSpecialDateService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private DeleteSpecialDateByIdService deleteSpecialDateByIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private UpdateSpecialDateService updateSpecialDateService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectSpecialDayByIdService selectSpecialDayByIdService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectWorkDayCountByDateService selectWorkDayCountByDateService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private SelectEndWorkdayService selectEndWorkdayService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="AUTH_GROUP_DEV")
    private QrySpecialDateService qrySpecialDateService;

    @RequestMapping(value={"/addSpecialDate"})
    @BusiResponseBody
    public Object addSpecialDate(@RequestBody SpecialDateReqBO reqBO) {
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        reqBO.setDayId(Long.valueOf(l));
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage") || UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            reqBO.setType(Integer.valueOf(1));
            this.addSpecialDateService.addSpecialDate(reqBO);
        } else if (UmcMemInfoHelper.hasAuthority((String)"auth:tenant:manage")) {
            UmcMemInfoBO currentUser = UmcMemInfoHelper.getCurrentUser();
            reqBO.setReqTenantId(currentUser.getTenantId());
            reqBO.setType(Integer.valueOf(2));
            this.addSpecialDateService.addSpecialDate(reqBO);
        }
        return null;
    }

    @RequestMapping(value={"/deleteSpecialDate"})
    @BusiResponseBody
    public Object deleteSpecialDate(String dayIds) {
        List longs = JSON.parseArray((String)dayIds, Long.class);
        DeleteSpecialDateByIdReqBO reqBO = new DeleteSpecialDateByIdReqBO();
        reqBO.setDayIds(longs);
        this.deleteSpecialDateByIdService.deleteSpecialDateById(reqBO);
        return null;
    }

    @RequestMapping(value={"/updateSpecialDate"})
    @BusiResponseBody
    public Object updateSpecialDate(@RequestBody SpecialDateReqBO reqBO) {
        try {
            SelectSpecialDayByIdReqBO specialDayByIdReqBO = new SelectSpecialDayByIdReqBO();
            specialDayByIdReqBO.setDayId(reqBO.getDayId());
            SelectSpecialDayByIdRspBO selectSpecialDayByIdRspBO = this.selectSpecialDayByIdService.selectSpecialDayById(specialDayByIdReqBO);
        }
        catch (Exception e) {
            this.logger.error("\u7f16\u8f91", (Throwable)e);
        }
        this.updateSpecialDateService.updateSpecialDate(reqBO);
        return null;
    }

    @RequestMapping(value={"/selectSpecialDate"})
    @BusiResponseBody
    public Object selectSpecialDate(@RequestBody SelectSpecialDayByIdReqBO reqBO) {
        return this.selectSpecialDayByIdService.selectSpecialDayById(reqBO);
    }

    @RequestMapping(value={"/selectworkday"})
    @BusiResponseBody
    public Object selectworkday(@RequestBody SelectWorkDayCountByDateReqBO reqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage") || UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectWorkDayCountByDateService.selectCountWorkDay(reqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:tenant:manage")) {
            UmcMemInfoBO currentUser = UmcMemInfoHelper.getCurrentUser();
            reqBO.setTenantId(currentUser.getTenantId());
            return this.selectWorkDayCountByDateService.selectCountWorkDay(reqBO);
        }
        return null;
    }

    @RequestMapping(value={"/selectEndWorkday"})
    @BusiResponseBody
    public Object selectEndWorkday(@RequestBody SelectEndWorkdayReqBO reqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage") || UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectEndWorkdayService.selectEndWorkday(reqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:tenant:manage")) {
            UmcMemInfoBO currentUser = UmcMemInfoHelper.getCurrentUser();
            reqBO.setTenantId(currentUser.getTenantId());
            return this.selectEndWorkdayService.selectEndWorkday(reqBO);
        }
        return null;
    }

    @RequestMapping(value={"/query"})
    @BusiResponseBody
    public Object query(@RequestBody QrySpecialDateReqBO reqBO) {
        ArrayList specialDateBOList = new ArrayList();
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage") || UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.qrySpecialDateService.qrySpecialDate(reqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:tenant:manage")) {
            UmcMemInfoBO currentUser = UmcMemInfoHelper.getCurrentUser();
            reqBO.setTenantId(currentUser.getTenantId());
            return this.qrySpecialDateService.qrySpecialDate(reqBO);
        }
        return specialDateBOList;
    }
}

