/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.pesapp.common.ability.bo.ComUocFileAppBO;
import com.tydic.pesapp.common.ability.bo.ComUocFileUploadAppReqBO;
import com.tydic.pesapp.common.ability.bo.ComUocFileUploadAppRspBO;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/common/uoc/fileGeneration"})
public class ComUocFileUpLoadController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ComUocFileUpLoadController.class);
    @Autowired
    private FileClient fileClient;
    private static final String path = "pesapp-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${fastdfs.httpTrackerHttpPort:}")
    private String fastdfsHttpTrackerHttpPort;
    @Value(value="${fastdfs.trackerServers:}")
    private String fastdfsTrackerServers;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    @PostMapping(value={"/upload"})
    @BusiResponseBody
    public ComUocFileUploadAppRspBO upload(MultipartFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        ArrayList<ComUocFileAppBO> list = new ArrayList<ComUocFileAppBO>();
        for (MultipartFile file : files) {
            InputStream inputStream = null;
            try {
                inputStream = file.getInputStream();
                String fileName = file.getOriginalFilename();
                String suffix = fileName.substring(fileName.lastIndexOf("."));
                byte[] bytes = new byte[inputStream.available()];
                inputStream.read(bytes);
                ComUocFileAppBO comUocFileAppBO = new ComUocFileAppBO();
                comUocFileAppBO.setFile(bytes);
                comUocFileAppBO.setFileName(fileName);
                comUocFileAppBO.setFileType(suffix);
                list.add(comUocFileAppBO);
            }
            catch (Exception e) {
                throw new ZTBusinessException("\u6587\u4ef6\u4e0a\u4f20\u5931\u8d25");
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.debug("\u6587\u4ef6\u4e0a\u4f20\u5173\u95ed\u6d41\u5931\u8d25");
                }
            }
        }
        ComUocFileUploadAppReqBO reqBO = new ComUocFileUploadAppReqBO();
        reqBO.setFiles(list);
        return this.upload(reqBO);
    }

    private ComUocFileUploadAppRspBO upload(ComUocFileUploadAppReqBO reqBO) {
        ArrayList fileList = new ArrayList();
        for (ComUocFileAppBO file : reqBO.getFiles()) {
            String fileUrl;
            ByteArrayInputStream inputStream = new ByteArrayInputStream(file.getFile());
            String fileName = UUID.randomUUID().toString().replaceAll("-", "") + file.getFileType();
            String path = this.fileClient.uploadFileByInputStream(path, fileName, (InputStream)inputStream);
            if ("OSS".equals(this.fileType)) {
                String httphead = "https://";
                if (path.endsWith(".jpg") || path.endsWith(".jpeg") || path.endsWith(".png")) {
                    httphead = "http://";
                }
                fileUrl = httphead + this.ossFileUrl + path;
            } else if ("FASTDFS".equals(this.fileType)) {
                FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
                fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
            } else {
                throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
            }
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", file.getFileName());
            map.put("url", fileUrl);
            fileList.add(map);
        }
        ComUocFileUploadAppRspBO rspBO = new ComUocFileUploadAppRspBO();
        rspBO.setFileList(fileList);
        return rspBO;
    }
}

