/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.common.authority.controller.role;

import com.alibaba.fastjson.JSON;
import com.ohaotian.authority.constant.Constants;
import com.ohaotian.authority.organisation.bo.POrdIdBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByTenantIdReqBO;
import com.ohaotian.authority.organisation.bo.SelectOrgByTenantIdRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBO;
import com.ohaotian.authority.organisation.bo.TreePathRspBOS;
import com.ohaotian.authority.organisation.service.SelectOrgByTenantIdBusiService;
import com.ohaotian.authority.organisation.service.SelectOrgStatusService;
import com.ohaotian.authority.organisation.service.SelectOrgTreePathService;
import com.ohaotian.authority.role.bo.CreatRoleReqBO;
import com.ohaotian.authority.role.bo.DeleteRoleReqBO;
import com.ohaotian.authority.role.bo.HasAllUserListBO;
import com.ohaotian.authority.role.bo.HasUserListBO;
import com.ohaotian.authority.role.bo.OrgBO;
import com.ohaotian.authority.role.bo.RoleInfoBO;
import com.ohaotian.authority.role.bo.RoleStatusReqBO;
import com.ohaotian.authority.role.bo.SaveOrgGrantUsersReqBO;
import com.ohaotian.authority.role.bo.SaveRoleConfigMenusReqBO;
import com.ohaotian.authority.role.bo.SaveRoleOrgsReqBO;
import com.ohaotian.authority.role.bo.SearchRolesRspBO;
import com.ohaotian.authority.role.bo.SelectAlreadyAndNorUsersReqBO;
import com.ohaotian.authority.role.bo.SelectOrgDistributeRspBO;
import com.ohaotian.authority.role.bo.SelectRoleByIdReqBO;
import com.ohaotian.authority.role.bo.SelectRolesPageReqBO;
import com.ohaotian.authority.role.bo.UpdateRoleByIDReqBO;
import com.ohaotian.authority.role.service.CreatRoleBusiService;
import com.ohaotian.authority.role.service.DeleteRoleBusiService;
import com.ohaotian.authority.role.service.RestartRoleByIdBusiService;
import com.ohaotian.authority.role.service.SaveOrgGrantUsersBusiService;
import com.ohaotian.authority.role.service.SaveRoleConfigMenusBusiService;
import com.ohaotian.authority.role.service.SaveRoleOrgsService;
import com.ohaotian.authority.role.service.SelectAdminRolesPageBusiService;
import com.ohaotian.authority.role.service.SelectAllUserByRoleId;
import com.ohaotian.authority.role.service.SelectAlreadyUser;
import com.ohaotian.authority.role.service.SelectHasOrgsByRoleService;
import com.ohaotian.authority.role.service.SelectOrgRolesPageService;
import com.ohaotian.authority.role.service.SelectOverAllRolesPageService;
import com.ohaotian.authority.role.service.SelectRoleByIdBusiService;
import com.ohaotian.authority.role.service.SelectRoleInfoByIdService;
import com.ohaotian.authority.role.service.SelectRolesPageBusiService;
import com.ohaotian.authority.role.service.SelectTenantRolesPageService;
import com.ohaotian.authority.role.service.StopRoleByIdBusiService;
import com.ohaotian.authority.role.service.UpdateRoleByIDBusiService;
import com.ohaotian.authority.user.bo.SaveUserAuthReqBO;
import com.ohaotian.authority.user.service.SaveRoleAuthService;
import com.ohaotian.plugin.base.bo.RspPage;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.pesapp.base.api.JsonBusiResponseBody;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/common/author/role"}, method={RequestMethod.GET, RequestMethod.POST})
public class RoleController {
    private static final Logger logger = LoggerFactory.getLogger(RoleController.class);
    @Autowired
    private CreatRoleBusiService creatRoleBusiService;
    @Autowired
    private StopRoleByIdBusiService stopRoleByIdBusiService;
    @Autowired
    private RestartRoleByIdBusiService restartRoleByIdBusiService;
    @Autowired
    private UpdateRoleByIDBusiService updateRoleByIDBusiService;
    @Autowired
    private SelectRoleByIdBusiService selectRoleByIdBusiService;
    @Autowired
    private SelectRolesPageBusiService selectRolesPageBusiService;
    @Autowired
    private SelectAdminRolesPageBusiService selectAdminRolesPageBusiService;
    @Autowired
    private SelectAllUserByRoleId selectAllUserByRoleId;
    @Autowired
    private SelectAlreadyUser selectAlreadyUser;
    @Autowired
    private SaveOrgGrantUsersBusiService saveOrgGrantUsersBusiService;
    @Autowired
    private SelectHasOrgsByRoleService selectHasOrgsByRoleService;
    @Autowired
    private SaveRoleOrgsService saveRoleOrgsService;
    @Autowired
    private SelectOrgTreePathService selectOrgTreePathService;
    @Autowired
    private SaveRoleAuthService saveRoleAuthService;
    @Autowired
    private SaveRoleConfigMenusBusiService saveRoleConfigMenusBusiService;
    @Autowired
    private DeleteRoleBusiService deleteRoleBusiService;
    @Autowired
    private SelectOverAllRolesPageService selectOverAllRolesPageService;
    @Autowired
    private SelectTenantRolesPageService selectTenantRolesPageService;
    @Autowired
    private SelectRoleInfoByIdService selectRoleInfoByIdService;
    @Autowired
    private SelectOrgRolesPageService selectOrgRolesPageService;
    @Autowired
    private SelectOrgStatusService selectOrgStatusService;
    @Autowired
    private SelectOrgByTenantIdBusiService selectOrgByTenantIdBusiService;

    @RequestMapping(value={"/alreadyAndNorUsers"})
    @JsonBusiResponseBody
    public Object getAlreadyAndNorUsers(@RequestBody SelectAlreadyAndNorUsersReqBO reqBO) {
        if (reqBO.getOrgId() == null || reqBO.getRoleId() == null) {
            throw new ZTBusinessException("\u89d2\u8272id\u6216\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        HasUserListBO hasAllUserListBO = this.selectAllUserByRoleId.selectAllUserByRoleId(reqBO);
        List allUser = hasAllUserListBO.getAllUser();
        HasUserListBO hasUserListBO = this.selectAlreadyUser.selectAlreadyDistributeUser(reqBO);
        List user = hasUserListBO.getAllUser();
        allUser.removeAll(user);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(user);
        orgDistributeRspBO.setNotGrantRoles(allUser);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/commit"})
    @JsonBusiResponseBody
    public Object commit(@RequestBody SaveOrgGrantUsersReqBO reqBO) {
        this.saveOrgGrantUsersBusiService.saveOrgGrantUsers(reqBO);
        return null;
    }

    @RequestMapping(value={"/alreadyAndNorOrg"})
    @JsonBusiResponseBody
    public Object getAlreadyAndNorOrg(@RequestBody SelectAlreadyAndNorUsersReqBO reqBO) {
        POrdIdBO pOrdIdBO = new POrdIdBO();
        pOrdIdBO.setParentId(reqBO.getOrgId());
        LinkedList<OrgBO> allOrgs = new LinkedList<OrgBO>();
        TreePathRspBOS treePathRspBOS = this.selectOrgTreePathService.selectOrgTreePath(pOrdIdBO);
        if (treePathRspBOS != null && treePathRspBOS.getTreePathRspBOList() != null && treePathRspBOS.getTreePathRspBOList().size() > 0) {
            for (TreePathRspBO bo : treePathRspBOS.getTreePathRspBOList()) {
                OrgBO orgBO = new OrgBO();
                orgBO.setOrgId(bo.getOrganisationId());
                orgBO.setTitle(bo.getTitle());
                orgBO.setOrgTreePath(bo.getOrgTreePath());
                allOrgs.add(orgBO);
            }
        }
        HasAllUserListBO hasOrgsByRole = this.selectHasOrgsByRoleService.getHasOrgsByRole(reqBO);
        List hasOrgs = hasOrgsByRole.getAllUser();
        allOrgs.removeAll(hasOrgs);
        SelectOrgDistributeRspBO orgDistributeRspBO = new SelectOrgDistributeRspBO();
        orgDistributeRspBO.setHasGrantRoles(hasOrgs);
        orgDistributeRspBO.setNotGrantRoles(allOrgs);
        return orgDistributeRspBO;
    }

    @RequestMapping(value={"/orgCommit"})
    @JsonBusiResponseBody
    public Object orgCommit(@RequestBody SaveRoleOrgsReqBO reqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:org:manage")) {
            reqBO.setAuthIdentity("auth:org:manage");
        }
        this.saveRoleOrgsService.saveRoleOrgs(reqBO);
        return null;
    }

    @PostMapping(value={"/creatRole"})
    @JsonBusiResponseBody
    public Object creatRole(@RequestBody CreatRoleReqBO creatRoleReqBO) throws Exception {
        SelectOrgByTenantIdRspBO select;
        SelectOrgByTenantIdReqBO reqBO;
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage")) {
            if (creatRoleReqBO.getTenantIdReq() == null) {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_OVERALL);
                creatRoleReqBO.setOrgTreePath(null);
            } else {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
                reqBO = new SelectOrgByTenantIdReqBO();
                reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
                select = this.selectOrgByTenantIdBusiService.select(reqBO);
                if (select != null) {
                    creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
                }
            }
        } else if (UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            if (creatRoleReqBO.getTenantIdReq() == null) {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_PART);
            } else {
                creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
                reqBO = new SelectOrgByTenantIdReqBO();
                reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
                select = this.selectOrgByTenantIdBusiService.select(reqBO);
                if (select != null) {
                    creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
                }
            }
        } else if (UmcMemInfoHelper.hasAuthority((String)"auth:tenant:manage")) {
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_TENANT);
            reqBO = new SelectOrgByTenantIdReqBO();
            reqBO.setTenantIdReq(creatRoleReqBO.getTenantIdReq());
            select = this.selectOrgByTenantIdBusiService.select(reqBO);
            if (select != null) {
                creatRoleReqBO.setOrgTreePath(select.getOrgTreePath());
            }
        } else if (UmcMemInfoHelper.hasAuthority((String)"auth:org:manage")) {
            creatRoleReqBO.setUserAuthIdentity("auth:org:manage");
            creatRoleReqBO.setRoleType(Constants.ORG_TYPE_MANAGER);
        }
        Sequence sequence = Sequence.getInstance();
        long l = sequence.nextId();
        creatRoleReqBO.setRoleId(Long.valueOf(l));
        this.creatRoleBusiService.creatRole(creatRoleReqBO);
        return null;
    }

    @PostMapping(value={"/stop"})
    @JsonBusiResponseBody
    public Object stopRole(@RequestBody RoleStatusReqBO roleStatusReqBO) {
        this.stopRoleByIdBusiService.stopRoleById(roleStatusReqBO);
        return null;
    }

    @PostMapping(value={"/restart"})
    @JsonBusiResponseBody
    public Object restartRole(@RequestBody RoleStatusReqBO roleStatusReqBO) {
        this.restartRoleByIdBusiService.restartRoleById(roleStatusReqBO);
        return null;
    }

    @PostMapping(value={"/selectRole"})
    @JsonBusiResponseBody
    public Object selectRole(@RequestBody SelectRoleByIdReqBO selectRoleByIdReqBO) {
        return this.selectRoleByIdBusiService.selectRoleById(selectRoleByIdReqBO);
    }

    @PostMapping(value={"/updateRole"})
    @JsonBusiResponseBody
    public Object updateRole(@RequestBody UpdateRoleByIDReqBO updateRoleByIDReqBO) throws Exception {
        try {
            SelectRoleByIdReqBO reqBO = new SelectRoleByIdReqBO();
            reqBO.setRoleId(updateRoleByIDReqBO.getRoleId());
            RoleInfoBO roleInfoBO = this.selectRoleInfoByIdService.selectById(reqBO);
        }
        catch (Exception e) {
            logger.error("\u7f16\u8f91\u89d2\u8272", (Throwable)e);
        }
        this.updateRoleByIDBusiService.updateRoleByID(updateRoleByIDReqBO);
        return null;
    }

    @RequestMapping(value={"/selectRoles"})
    @JsonBusiResponseBody
    public RspPage<SearchRolesRspBO> selectRoles(@RequestBody SelectRolesPageReqBO rolesPageReqBO) {
        UmcMemInfoBO user;
        RspPage rsp = new RspPage();
        if (UmcMemInfoHelper.hasAuthority((String)"auth:system:manage")) {
            return this.selectRolesPageBusiService.selectRolesPage(rolesPageReqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:overall:manage")) {
            return this.selectOverAllRolesPageService.selectOverAllRolesPage(rolesPageReqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:tenant:manage")) {
            return this.selectTenantRolesPageService.selectTenantRolesPage(rolesPageReqBO);
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:org:manage") && (user = UmcMemInfoHelper.getCurrentUser()).getUserId() != null) {
            rolesPageReqBO.setmUserId(user.getUserId());
            return this.selectOrgRolesPageService.selectOrgRolesPage(rolesPageReqBO);
        }
        return rsp;
    }

    @RequestMapping(value={"/authUserCommit"})
    @JsonBusiResponseBody
    public Object authUserCommit(@RequestBody SaveUserAuthReqBO saveUserAuthReqBO) {
        if (StringUtils.isEmpty((Object)saveUserAuthReqBO.getJson())) {
            throw new ZTBusinessException("\u8bf7\u91cd\u65b0\u9009\u62e9");
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:org:manage")) {
            saveUserAuthReqBO.setAuthIdentity("auth:org:manage");
        }
        this.saveRoleAuthService.saveRoleAuthService(saveUserAuthReqBO);
        return null;
    }

    @RequestMapping(value={"/configMenus"})
    @JsonBusiResponseBody
    public Object configMenus(@RequestBody SaveRoleConfigMenusReqBO saveRoleConfigMenusReqBO) {
        if (UmcMemInfoHelper.hasAuthority((String)"auth:org:manage")) {
            saveRoleConfigMenusReqBO.setOrgTreePath(saveRoleConfigMenusReqBO.getOrgTreePath());
            saveRoleConfigMenusReqBO.setAuthIdentity("auth:org:manage");
            this.saveRoleConfigMenusBusiService.saveRoleConfigMenus(saveRoleConfigMenusReqBO);
        } else {
            this.saveRoleConfigMenusBusiService.saveRoleConfigMenus(saveRoleConfigMenusReqBO);
        }
        return null;
    }

    @RequestMapping(value={"/delete"})
    @JsonBusiResponseBody
    public Object delete(@RequestBody DeleteRoleReqBO deleteRoleReqBO) {
        try {
            SelectRoleByIdReqBO reqBO = new SelectRoleByIdReqBO();
            reqBO.setRoleId(deleteRoleReqBO.getRoleId());
            reqBO.setAuthIdentity(deleteRoleReqBO.getRoleAuthIdentity());
            RoleInfoBO roleInfoBO = this.selectRoleInfoByIdService.selectById(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5220\u9664", (Throwable)e);
        }
        if (UmcMemInfoHelper.hasAuthority((String)"auth:org:manage")) {
            deleteRoleReqBO.setRoleAuthIdentity("auth:org:manage");
        }
        this.deleteRoleBusiService.deleteRole(deleteRoleReqBO);
        return null;
    }

    @PostMapping(value={"/batchStop"})
    @JsonBusiResponseBody
    public Object batchStopRoles(String roles) {
        List longList = JSON.parseArray((String)roles, Long.class);
        for (Long role : longList) {
            RoleStatusReqBO roleStatusReqBO = new RoleStatusReqBO();
            roleStatusReqBO.setRoleId(role);
            this.stopRoleByIdBusiService.stopRoleById(roleStatusReqBO);
        }
        return null;
    }

    @PostMapping(value={"/batchRestart"})
    @JsonBusiResponseBody
    public Object restartRole(String roles) {
        List longList = JSON.parseArray((String)roles, Long.class);
        for (Long role : longList) {
            RoleStatusReqBO roleStatusReqBO = new RoleStatusReqBO();
            roleStatusReqBO.setRoleId(role);
            this.restartRoleByIdBusiService.restartRoleById(roleStatusReqBO);
        }
        return null;
    }
}

