/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.zone.supp.controller;

import com.ohaotian.plugin.base.annotation.BusiResponseBody;
import com.tydic.pesapp.zone.supp.ability.bo.SupplierSalePriceAdjustReqDto;
import com.tydic.pesapp.zone.supp.ability.bo.SupplierSalePriceAdjustRspDto;
import com.tydic.pesapp.zone.supp.controller.BaseController;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"std-specialarea/suppliermgnt/supplier/informationmgnt"})
public class SupplierSalePriceAdjustController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SupplierSalePriceAdjustController.class);

    @RequestMapping(value={"/supplierSalePriceAdjust"}, method={RequestMethod.POST})
    @BusiResponseBody
    public SupplierSalePriceAdjustRspDto supplierSalePriceAdjust(@RequestBody SupplierSalePriceAdjustReqDto supplierSalePriceAdjustReqDto) {
        SupplierSalePriceAdjustRspDto rspDto = new SupplierSalePriceAdjustRspDto();
        BigDecimal salePrice = supplierSalePriceAdjustReqDto.getSalePrice();
        BigDecimal purchasePrice = supplierSalePriceAdjustReqDto.getPurchasePrice();
        int quantity = supplierSalePriceAdjustReqDto.getQuantity();
        if (salePrice == null) {
            rspDto.setCode("0001");
            rspDto.setMessage("\u9500\u552e\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspDto;
        }
        if (purchasePrice == null) {
            rspDto.setCode("0001");
            rspDto.setMessage("\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspDto;
        }
        if (salePrice.compareTo(purchasePrice) == -1) {
            rspDto.setCode("0002");
            rspDto.setMessage("\u9500\u552e\u5355\u4ef7\u4e0d\u80fd\u5c0f\u4e8e\u91c7\u8d2d\u5355\u4ef7");
            return rspDto;
        }
        BigDecimal outMarkUpRate = BigDecimal.valueOf(0L);
        if (purchasePrice.compareTo(BigDecimal.ZERO) == 0) {
            rspDto.setCode("0002");
            rspDto.setMessage("\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u4e3a0");
            return rspDto;
        }
        outMarkUpRate = salePrice.divide(purchasePrice, 2, 1).subtract(BigDecimal.valueOf(1L)).multiply(BigDecimal.valueOf(100L)).setScale(0, 1);
        BigDecimal outTotalPurchasePrice = purchasePrice.multiply(BigDecimal.valueOf(quantity));
        BigDecimal outTotalSalePrice = salePrice.multiply(BigDecimal.valueOf(quantity));
        rspDto.setTotalPurchasePrice(outTotalPurchasePrice);
        rspDto.setTotalSalePrice(outTotalSalePrice);
        rspDto.setMarkUpRate(outMarkUpRate);
        return rspDto;
    }
}

