/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.contract.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FtpUtil {
    private static final Logger log = LoggerFactory.getLogger(FtpUtil.class);
    @Value(value="${ftp.hostname}")
    private String ftpHost;
    @Value(value="${ftp.port}")
    private int ftpPort;
    @Value(value="${ftp.username}")
    private String ftpUserName;
    @Value(value="${ftp.password}")
    private String ftpPassword;
    @Value(value="${ftp.ftpPath}")
    private String ftpPath;
    @Value(value="${ftp.localPath}")
    private String localPath;

    private FTPClient getFTPClient() {
        FTPClient ftpClient = new FTPClient();
        try {
            ftpClient.setDefaultTimeout(20000);
            ftpClient.setDataTimeout(3600000);
            ftpClient.setConnectTimeout(60000);
            ftpClient.connect(this.ftpHost, this.ftpPort);
            ftpClient.login(this.ftpUserName, this.ftpPassword);
            ftpClient.setBufferSize(4096);
            ftpClient.setKeepAlive(true);
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            if (FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                log.info("\u767b\u9646\u6210\u529f" + this.ftpHost + ":" + this.ftpPort);
            } else {
                log.info("\u767b\u9646\u5931\u8d25\uff0c\u7528\u6237\u540d\u6216\u8005\u5bc6\u7801\u9519\u8bef" + this.ftpHost + ":" + this.ftpPort);
                ftpClient.disconnect();
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
            log.error("ftp\u5730\u5740\u53ef\u80fd\u9519\u8bef");
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("ftp\u7aef\u53e3\u9519\u8bef");
        }
        return ftpClient;
    }

    public void downloadFtpFile(String fileName) {
        FTPClient ftpClient = null;
        try {
            ftpClient = this.getFTPClient();
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(this.ftpPath);
            File localFile = new File(this.localPath + File.separatorChar + fileName);
            FileOutputStream os = new FileOutputStream(localFile);
            ftpClient.retrieveFile(fileName, (OutputStream)os);
            ((OutputStream)os).close();
            ftpClient.logout();
        }
        catch (FileNotFoundException e) {
            log.error("\u6ca1\u6709\u627e\u5230" + this.ftpPath + "\u6587\u4ef6");
            e.printStackTrace();
        }
        catch (SocketException e) {
            log.error("\u8fde\u63a5FTP\u5931\u8d25.");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\u3002");
        }
    }

    public InputStream downFile(String fileName) {
        log.error("downFile____fileName=[" + fileName + "]");
        FTPClient ftpClient = null;
        InputStream in = null;
        try {
            ftpClient = this.getFTPClient();
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(this.ftpPath);
            in = ftpClient.retrieveFileStream(fileName);
            ftpClient.logout();
        }
        catch (FileNotFoundException e) {
            log.error("\u6ca1\u6709\u627e\u5230" + this.ftpPath + "\u6587\u4ef6");
            e.printStackTrace();
        }
        catch (SocketException e) {
            log.error("\u8fde\u63a5FTP\u5931\u8d25.");
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error("\u6587\u4ef6\u8bfb\u53d6\u9519\u8bef\u3002");
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String fileName, InputStream input) {
        boolean success = false;
        FTPClient ftpClient = null;
        try {
            ftpClient = this.getFTPClient();
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion((int)reply)) {
                ftpClient.disconnect();
                boolean bl = success;
                return bl;
            }
            ftpClient.setControlEncoding("UTF-8");
            ftpClient.setFileType(2);
            ftpClient.enterLocalPassiveMode();
            ftpClient.changeWorkingDirectory(this.ftpPath);
            ftpClient.storeFile(fileName, input);
            input.close();
            ftpClient.logout();
            success = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (ftpClient.isConnected()) {
                try {
                    ftpClient.disconnect();
                }
                catch (IOException iOException) {}
            }
        }
        return success;
    }
}

