/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.mall.ability.impl;

import com.alibaba.boot.hsf.annotation.HSFConsumer;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.order.extend.ability.saleorder.PebSelfCreateOrderAbilityService;
import com.tydic.order.extend.bo.saleorder.PebSelfCreateOrderReqBO;
import com.tydic.order.extend.bo.saleorder.PebSelfCreateOrderRspBO;
import com.tydic.order.third.intf.bo.umc.EnterpriseAccountBO;
import com.tydic.order.third.intf.bo.umc.EnterpriseOrgBO;
import com.tydic.pesapp.mall.ability.PesappMallGenerateOrdersService;
import com.tydic.pesapp.mall.ability.bo.PesappMallGenerateOrdersItemInfoBO;
import com.tydic.pesapp.mall.ability.bo.PesappMallGenerateOrdersReqBO;
import com.tydic.pesapp.mall.ability.bo.PesappMallGenerateOrdersRspBO;
import com.tydic.umc.ability.DictionaryAbilityService;
import com.tydic.umc.ability.UmcQryAgreeSignAbilityService;
import com.tydic.umc.ability.bo.DicDictionaryBO;
import com.tydic.umc.ability.bo.QueryDictionaryAbilityReqBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgDetailAbilityRspBO;
import com.tydic.umc.ability.bo.UmcEnterpriseOrgQueryAbilityReqBO;
import com.tydic.umc.ability.org.UmcEnterpriseOrgQueryAbilityService;
import com.tydic.umc.base.bo.UmcRspListBO;
import com.tydic.umcext.ability.account.UmcQryEnterpriseAccountDetailAbilityService;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityReqBO;
import com.tydic.umcext.ability.account.bo.UmcQryEnterpriseAccountDetailAbilityRspBO;
import com.tydic.usc.api.ability.UscGoodsListDelAbilityService;
import com.tydic.usc.api.ability.bo.GoodsInfoIdAbilityBO;
import com.tydic.usc.api.ability.bo.UscGoodsListDelAbilityReqBO;
import com.tydic.usc.api.ability.bo.UscGoodsListDelAbilityRspBO;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PesappMallGenerateOrdersServiceImpl
implements PesappMallGenerateOrdersService {
    private static final Logger log = LoggerFactory.getLogger(PesappMallGenerateOrdersServiceImpl.class);
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UOC_GROUP_DEV")
    private PebSelfCreateOrderAbilityService pebSelfCreateOrderAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private DictionaryAbilityService dictionaryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcQryEnterpriseAccountDetailAbilityService umcQryEnterpriseAccountDetailAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcEnterpriseOrgQueryAbilityService umcEnterpriseOrgQueryAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="UMC_GROUP_DEV")
    private UmcQryAgreeSignAbilityService umcQryAgreeSignAbilityService;
    @HSFConsumer(serviceVersion="1.0.0", serviceGroup="USC_GROUP_DEV")
    private UscGoodsListDelAbilityService uscGoodsListDelAbilityService;

    public PesappMallGenerateOrdersRspBO generateSelfOrders(PesappMallGenerateOrdersReqBO reqBO) {
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getSaleOrderItemList())) {
            ArrayList collect = reqBO.getSaleOrderItemList().stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<PesappMallGenerateOrdersItemInfoBO>(Comparator.comparing(PesappMallGenerateOrdersItemInfoBO::getSkuId))), ArrayList::new));
            if (collect.size() < reqBO.getSaleOrderItemList().size()) {
                throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u6709\u91cd\u590d\u5546\u54c1ID");
            }
        } else {
            throw new ZTBusinessException("\u5165\u53c2\u5546\u54c1\u8be6\u60c5\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PebSelfCreateOrderReqBO pebSelfCreateOrderReqBO = (PebSelfCreateOrderReqBO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), PebSelfCreateOrderReqBO.class);
        pebSelfCreateOrderReqBO.setUmcEnterpriseAccountBO(this.qryEnterpriseAccountDetail(reqBO.getPurchaserAccount()));
        this.qryOrgEffAccount(pebSelfCreateOrderReqBO);
        pebSelfCreateOrderReqBO.setTax(Long.valueOf(5L));
        PebSelfCreateOrderRspBO pebSelfCreateOrderRspBO = this.pebSelfCreateOrderAbilityService.dealPebSelfCreateOrder(pebSelfCreateOrderReqBO);
        if (!"0000".equals(pebSelfCreateOrderRspBO.getRespCode())) {
            throw new ZTBusinessException(pebSelfCreateOrderRspBO.getRespDesc());
        }
        this.removeGoodsList(reqBO);
        return (PesappMallGenerateOrdersRspBO)JSON.parseObject((String)JSON.toJSONString((Object)pebSelfCreateOrderRspBO), PesappMallGenerateOrdersRspBO.class);
    }

    private Integer getPayCancelOvertime(PesappMallGenerateOrdersReqBO reqBO) {
        if (reqBO.getPayType().equals(Integer.parseInt("1"))) {
            return Integer.valueOf(this.getDic("Pesapp_CONFIG_11"));
        }
        if (reqBO.getPayType().equals(Integer.parseInt("2"))) {
            String closeCycle = this.getDic("Pesapp_CONFIG_14");
            String startingTimeStr = this.getDic("Pesapp_CONFIG_15");
            Date startingTime = DateUtils.strToDate((String)startingTimeStr, (String)"yyyy-MM-dd'T'HH:mm:ss.S'Z'");
            if ("1".equals(closeCycle)) {
                Instant instant = startingTime.toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime temporal1 = LocalDateTime.ofInstant(instant, zone);
                Date nowDate = new Date();
                instant = nowDate.toInstant();
                LocalDateTime temporal2 = LocalDateTime.ofInstant(instant, zone);
                long betweenYear = ChronoUnit.MONTHS.between(temporal1, temporal2);
                Date endDate = DateUtils.getDateByMonth((Date)startingTime, (Integer)((int)betweenYear + 1));
                return (int)((endDate.getTime() - nowDate.getTime()) / 3600000L);
            }
            if ("2".equals(closeCycle)) {
                Instant instant = startingTime.toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime temporal1 = LocalDateTime.ofInstant(instant, zone);
                Date nowDate = new Date();
                instant = nowDate.toInstant();
                LocalDateTime temporal2 = LocalDateTime.ofInstant(instant, zone);
                long betweenWeek = ChronoUnit.WEEKS.between(temporal1, temporal2);
                Date endDate = DateUtils.getDate((Date)startingTime, (Integer)((int)((betweenWeek + 1L) * 7L)));
                return (int)((endDate.getTime() - nowDate.getTime()) / 3600000L);
            }
            if ("3".equals(closeCycle)) {
                Instant instant = startingTime.toInstant();
                ZoneId zone = ZoneId.systemDefault();
                LocalDateTime temporal1 = LocalDateTime.ofInstant(instant, zone);
                Date nowDate = new Date();
                instant = nowDate.toInstant();
                LocalDateTime temporal2 = LocalDateTime.ofInstant(instant, zone);
                long betweenQuarterly = ChronoUnit.MONTHS.between(temporal1, temporal2);
                Date endDate = DateUtils.getDateByMonth((Date)startingTime, (Integer)(((int)betweenQuarterly + 1) * 3));
                return (int)((endDate.getTime() - nowDate.getTime()) / 3600000L);
            }
            throw new ZTBusinessException("\u672a\u77e5\u6388\u4fe1\u652f\u4ed8\u81ea\u52a8\u5173\u95ed\u65f6\u95f4\u5468\u671f\u5f00\u59cb\u7c7b\u578b\uff1a" + closeCycle);
        }
        throw new ZTBusinessException("\u672a\u77e5\u652f\u4ed8\u65b9\u5f0f\uff1a" + reqBO.getPayType());
    }

    private String getDic(String pcode) {
        QueryDictionaryAbilityReqBO queryParam = new QueryDictionaryAbilityReqBO();
        queryParam.setPcode(pcode);
        UmcRspListBO dicDictionaryBOUmcRspListBO = this.dictionaryAbilityService.queryBypCodeBackPo(queryParam);
        if (!"0000".equals(dicDictionaryBOUmcRspListBO.getRespCode())) {
            throw new ZTBusinessException(dicDictionaryBOUmcRspListBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)dicDictionaryBOUmcRspListBO.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2\u57fa\u7840\u6570\u636e\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff01");
        }
        String title = ((DicDictionaryBO)dicDictionaryBOUmcRspListBO.getRows().get(0)).getTitle();
        if (StringUtils.isBlank((CharSequence)title)) {
            throw new ZTBusinessException("\u67e5\u8be2\u57fa\u7840\u6570\u636e\u914d\u7f6e\u4e3a\u7a7a\uff0c\u8bf7\u914d\u7f6e\uff01");
        }
        return title;
    }

    private EnterpriseAccountBO qryEnterpriseAccountDetail(String purchaserAccount) {
        if (StringUtils.isBlank((CharSequence)purchaserAccount)) {
            throw new ZTBusinessException("\u5165\u53c2\u3010purchaserAccount\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        UmcQryEnterpriseAccountDetailAbilityReqBO account = new UmcQryEnterpriseAccountDetailAbilityReqBO();
        account.setAccountId(Long.valueOf(purchaserAccount));
        UmcQryEnterpriseAccountDetailAbilityRspBO rspBO = this.umcQryEnterpriseAccountDetailAbilityService.qryEnterpriseAccountDetail(account);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25" + rspBO.getRespDesc());
        }
        if (rspBO.getUmcEnterpriseAccountBO() == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u8d26\u5957\u4fe1\u606f\u5931\u8d25,\u8d26\u5957\u4fe1\u606f\u8be6\u60c5\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
        }
        return (EnterpriseAccountBO)JSON.parseObject((String)JSON.toJSONString((Object)rspBO.getUmcEnterpriseAccountBO()), EnterpriseAccountBO.class);
    }

    private void qryOrgEffAccount(PebSelfCreateOrderReqBO pebSelfCreateOrderReqBO) {
        UmcEnterpriseOrgQueryAbilityReqBO qryOrgEffAccountReqBO = new UmcEnterpriseOrgQueryAbilityReqBO();
        qryOrgEffAccountReqBO.setOrgIdWeb(pebSelfCreateOrderReqBO.getOrgIdIn());
        UmcEnterpriseOrgDetailAbilityRspBO rspBO = this.umcEnterpriseOrgQueryAbilityService.queryEnterpriseOrgByDetail(qryOrgEffAccountReqBO);
        if (!"0000".equals(rspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u91c7\u8d2d\u65b9\u4fe1\u606f\u5931\u8d25\uff1a" + rspBO.getRespDesc());
        }
        if (null == rspBO.getUmcEnterpriseOrgAbilityBO()) {
            throw new ZTBusinessException("\u67e5\u8be2\u91c7\u8d2d\u65b9\u4fe1\u606f\u4e3a\u7a7a");
        }
        pebSelfCreateOrderReqBO.setPurOrgInfoBO((EnterpriseOrgBO)JSON.parseObject((String)JSON.toJSONString((Object)rspBO.getUmcEnterpriseOrgAbilityBO()), EnterpriseOrgBO.class));
    }

    private void removeGoodsList(PesappMallGenerateOrdersReqBO reqBO) {
        UscGoodsListDelAbilityReqBO goodsListDelReqBO = new UscGoodsListDelAbilityReqBO();
        ArrayList<GoodsInfoIdAbilityBO> goodsInfoIdAbilityBOList = new ArrayList<GoodsInfoIdAbilityBO>(reqBO.getSaleOrderItemList().size());
        for (PesappMallGenerateOrdersItemInfoBO skuInfo : reqBO.getSaleOrderItemList()) {
            GoodsInfoIdAbilityBO goodsInfoIdBO = new GoodsInfoIdAbilityBO();
            goodsInfoIdBO.setSkuId(skuInfo.getSkuId());
            goodsInfoIdAbilityBOList.add(goodsInfoIdBO);
        }
        goodsListDelReqBO.setUserId(reqBO.getUserIdIn());
        goodsListDelReqBO.setMemberId(reqBO.getUserIdIn() + "");
        goodsListDelReqBO.setGoodsInfoList(goodsInfoIdAbilityBOList);
        try {
            log.debug("\u5220\u9664\u8d2d\u7269\u8f66\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)goodsListDelReqBO));
            UscGoodsListDelAbilityRspBO goodsListDelAbilityRspBO = this.uscGoodsListDelAbilityService.delGoodsList(goodsListDelReqBO);
            log.debug("\u5220\u9664\u8d2d\u7269\u8f66\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)goodsListDelAbilityRspBO));
        }
        catch (Exception e) {
            log.debug("\u5220\u9664\u8d2d\u7269\u8f66\u3001\u63a8\u9001\u5546\u54c1\u6708\u9500\u91cf\u6216\u8005\u63a8\u9001\u5546\u54c1\u95e8\u5e97\u9500\u91cf\u5931\u8d25:", (Throwable)e);
        }
    }
}

