/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.base.api.utils;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

@Component
public class RequestUniqueCheckUtil {
    @Autowired
    private CacheClient cacheClient;

    public void checkRequestUnique(@NotNull String className, @NotNull String methodName, @NotNull Object[] args, Integer expirationSeconds, String msg) {
        int defaultExpirationTime = 3;
        int expire = null != expirationSeconds && 0 < expirationSeconds ? expirationSeconds : 3;
        String key = className + "|" + methodName + "|" + JSON.toJSONString((Object)args);
        String md5DigestAsHex = DigestUtils.md5DigestAsHex((byte[])key.getBytes());
        Object cacheObj = this.cacheClient.get(md5DigestAsHex);
        if (null != cacheObj) {
            String message = StringUtils.hasText((String)msg) ? msg : expire + "\u79d2\u5185\u8bf7\u4e0d\u8981\u91cd\u590d\u64cd\u4f5c\uff01";
            throw new ZTBusinessException(message);
        }
        this.cacheClient.set(md5DigestAsHex, (Object)"RequestUniqueCheck", expire);
    }

    public void releaseRequestUniqueCheckCache(@NotNull String className, @NotNull String methodName, @NotNull Object[] args) {
        String key = className + "|" + methodName + "|" + JSON.toJSONString((Object)args);
        String md5DigestAsHex = DigestUtils.md5DigestAsHex((byte[])key.getBytes());
        this.cacheClient.delete(md5DigestAsHex);
    }
}

