/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.zone.supp.controller;

import com.tydic.pesapp.base.api.JsonBusiResponseBody;
import com.tydic.pesapp.zone.supp.ability.bo.SupplierPurchasePriceAdjustReqDto;
import com.tydic.pesapp.zone.supp.ability.bo.SupplierPurchasePriceAdjustRspDto;
import com.tydic.pesapp.zone.supp.controller.BaseController;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"std-specialarea/suppliermgnt/supplier/informationmgnt"})
public class SupplierPurchasePriceAdjustController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(SupplierPurchasePriceAdjustController.class);

    @RequestMapping(value={"/supplierPurchasePriceAdjust"}, method={RequestMethod.POST})
    @JsonBusiResponseBody
    public SupplierPurchasePriceAdjustRspDto supplierPurchasePriceAdjust(@RequestBody SupplierPurchasePriceAdjustReqDto supplierPurchasePriceAdjustReqDto) {
        SupplierPurchasePriceAdjustRspDto rspDto = new SupplierPurchasePriceAdjustRspDto();
        BigDecimal purchasePrice = supplierPurchasePriceAdjustReqDto.getPurchasePrice();
        BigDecimal markUpRate = supplierPurchasePriceAdjustReqDto.getMarkUpRate();
        int quantity = supplierPurchasePriceAdjustReqDto.getQuantity();
        if (purchasePrice == null) {
            rspDto.setCode("0001");
            rspDto.setMessage("\u91c7\u8d2d\u5355\u4ef7\u4e0d\u80fd\u4e3a\u7a7a");
            return rspDto;
        }
        BigDecimal outTotalPurchasePrice = purchasePrice.multiply(BigDecimal.valueOf(quantity));
        BigDecimal outSalePrice = purchasePrice.multiply(markUpRate.divide(BigDecimal.valueOf(100L)).add(BigDecimal.valueOf(1L))).setScale(2, 4);
        BigDecimal outTotalSalePrice = outSalePrice.multiply(BigDecimal.valueOf(quantity));
        rspDto.setTotalPurchasePrice(outTotalPurchasePrice);
        rspDto.setSalePrice(outSalePrice);
        rspDto.setTotalSalePrice(outTotalSalePrice);
        return rspDto;
    }
}

