/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pesapp.zone.controller;

import com.tydic.pesapp.base.api.JsonBusiResponseBody;
import com.tydic.pesapp.zone.ability.BmcPurchaserOrderApprovalService;
import com.tydic.pesapp.zone.ability.bo.OrderStationWebDto;
import com.tydic.pesapp.zone.ability.bo.PurchaserOrderApprovalReqDto;
import com.tydic.pesapp.zone.ability.bo.PurchaserOrderApprovalRspDto;
import com.tydic.pesapp.zone.controller.BaseController;
import com.tydic.umc.external.authority.bo.UmcStationWebBO;
import com.tydic.umc.security.base.UmcMemInfoBO;
import com.tydic.umc.security.base.UmcMemInfoHelper;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"std-specialarea/ordermgnt/purchaser/orderapproval"})
public class PurchaserOrderApprovalController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(PurchaserOrderApprovalController.class);
    @Autowired
    private BmcPurchaserOrderApprovalService apcsPurchaserOrderApprovalService;

    @RequestMapping(value={"/purchaserOrderApproval"}, method={RequestMethod.POST})
    @JsonBusiResponseBody
    PurchaserOrderApprovalRspDto dealOrderApproval(@RequestBody PurchaserOrderApprovalReqDto reqDto) {
        if (!this.authorize()) {
            return null;
        }
        UmcMemInfoBO userInfo = UmcMemInfoHelper.getCurrentUser();
        if (userInfo != null) {
            reqDto.setOperId(userInfo.getUserId().toString());
            reqDto.setOperName(userInfo.getUsername());
            reqDto.setOperDept(userInfo.getOrgId().toString());
            ArrayList<OrderStationWebDto> orderStationWebDtos = new ArrayList<OrderStationWebDto>();
            if (userInfo.getStationsList() != null && userInfo.getStationsList().size() > 0) {
                for (UmcStationWebBO umcStationWebBO : userInfo.getUmcStationsListWebExt()) {
                    OrderStationWebDto orderStationWebDto = new OrderStationWebDto();
                    orderStationWebDto.setStationId(umcStationWebBO.getStationId());
                    orderStationWebDtos.add(orderStationWebDto);
                }
            }
            reqDto.setStationWebBOList(orderStationWebDtos);
        }
        log.warn("\tuser name:\t" + userInfo.getUsername());
        PurchaserOrderApprovalRspDto rspDto = this.apcsPurchaserOrderApprovalService.dealOrderApproval(reqDto);
        return rspDto;
    }
}

