/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.common;

import com.itextpdf.text.Chunk;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.ExceptionConverter;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;

public class PDFShowPageFooterEvent
extends PdfPageEventHelper {
    private PdfTemplate total;
    private Rectangle rectangle;
    private Font zh;
    private Font pt;

    public PDFShowPageFooterEvent(Rectangle rectangle, Font zh, Font pt) {
        this.rectangle = rectangle;
        this.zh = zh;
        this.pt = pt;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(10.0f, 10.0f);
    }

    public void onStartPage(PdfWriter writer, Document document) {
        super.onStartPage(writer, document);
        try {
            Phrase pagination = new Phrase();
            pagination.add((Element)new Chunk(String.format("%s   /", writer.getPageNumber()), this.pt));
            ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)1, (Phrase)pagination, (float)(this.rectangle.getWidth() / 2.0f), (float)10.0f, (float)0.0f);
            Image image = Image.getInstance((PdfTemplate)this.total);
            image.setAbsolutePosition(this.rectangle.getWidth() / 2.0f + 17.0f, 10.0f);
            document.add((Element)image);
        }
        catch (DocumentException e) {
            throw new ExceptionConverter((Exception)((Object)e));
        }
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        ColumnText.showTextAligned((PdfContentByte)this.total, (int)0, (Phrase)new Phrase(new Chunk(String.valueOf(writer.getPageNumber() - 1), this.pt)), (float)0.0f, (float)0.0f, (float)0.0f);
    }
}

