/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.enums;

import com.tydic.pfsc.enums.BaseEnums;

public enum CompanyType implements BaseEnums
{
    OTHER(0, "-"),
    PURCHASER(1, "\u91c7\u8d2d\u5546"),
    SUPPLIER(2, "\u4f9b\u5e94\u5546");

    private String groupName = "COMPANY_TYPE";
    private Integer code;
    private String codeDescr;

    private CompanyType(Integer code, String codeDescr) {
        this.code = code;
        this.codeDescr = codeDescr;
    }

    @Override
    public String getGroupName() {
        return this.groupName;
    }

    @Override
    public String getCodeAsString() {
        return String.valueOf(this.code);
    }

    @Override
    public String getDescr() {
        return this.codeDescr;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getCodeDescr() {
        return this.codeDescr;
    }

    public static CompanyType convert(Integer code) {
        if (code == null) {
            return null;
        }
        for (CompanyType o : CompanyType.values()) {
            if (!o.getCode().equals(code)) continue;
            return o;
        }
        return null;
    }
}

