/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.utils;

import com.itextpdf.text.Document;
import com.itextpdf.text.Font;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.Rectangle;
import com.itextpdf.text.pdf.BaseFont;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfPageEventHelper;
import com.itextpdf.text.pdf.PdfTemplate;
import com.itextpdf.text.pdf.PdfWriter;

public class ItextPdfHeaderFooter
extends PdfPageEventHelper {
    public String header = "";
    public int presentFontSize = 12;
    public Rectangle pageSize = PageSize.A4;
    public PdfTemplate total;
    public BaseFont bf = null;
    public Font fontDetail = null;

    public ItextPdfHeaderFooter() {
    }

    public ItextPdfHeaderFooter(BaseFont bf, int presentFontSize, Rectangle pageSize) {
        this.bf = bf;
        this.presentFontSize = presentFontSize;
        this.pageSize = pageSize;
    }

    public ItextPdfHeaderFooter(String yeMei, int presentFontSize, Rectangle pageSize) {
        this.header = yeMei;
        this.presentFontSize = presentFontSize;
        this.pageSize = pageSize;
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public void setPresentFontSize(int presentFontSize) {
        this.presentFontSize = presentFontSize;
    }

    public void onOpenDocument(PdfWriter writer, Document document) {
        this.total = writer.getDirectContent().createTemplate(50.0f, 50.0f);
    }

    public void onEndPage(PdfWriter writer, Document document) {
        try {
            if (this.fontDetail == null) {
                this.fontDetail = new Font(this.bf, (float)this.presentFontSize, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ColumnText.showTextAligned((PdfContentByte)writer.getDirectContent(), (int)0, (Phrase)new Phrase(this.header, this.fontDetail), (float)document.left(), (float)(document.top() + 20.0f), (float)0.0f);
        int pageS = writer.getPageNumber();
        String foot1 = "\u7b2c " + pageS + " \u9875/\u5171";
        Phrase footer = new Phrase(foot1, this.fontDetail);
        float len = this.bf.getWidthPoint(foot1, (float)this.presentFontSize);
        PdfContentByte cb = writer.getDirectContent();
        ColumnText.showTextAligned((PdfContentByte)cb, (int)1, (Phrase)footer, (float)((document.rightMargin() + document.right() + document.leftMargin() - document.left() - len) / 2.0f + 20.0f), (float)(document.bottom() - 20.0f), (float)0.0f);
        cb.addTemplate(this.total, (document.rightMargin() + document.right() + document.leftMargin() - document.left()) / 2.0f + 20.0f, document.bottom() - 20.0f);
    }

    public void onCloseDocument(PdfWriter writer, Document document) {
        this.total.beginText();
        this.total.setFontAndSize(this.bf, (float)this.presentFontSize);
        String foot2 = " " + writer.getPageNumber() + " \u9875";
        Phrase footer = new Phrase(foot2, this.fontDetail);
        this.total.showText(foot2);
        this.total.endText();
        this.total.closePath();
    }
}

