/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.OutstockDetailMapper;
import com.tydic.pfsc.dao.OutstockInfoMapper;
import com.tydic.pfsc.dao.RecvAbleInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.StocksDetailMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.OutstockDetail;
import com.tydic.pfsc.dao.po.OutstockInfo;
import com.tydic.pfsc.dao.po.RecvAbleInfo;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.po.StocksDetail;
import com.tydic.pfsc.dao.vo.OutstockDetailVO;
import com.tydic.pfsc.dao.vo.RecvAbleInfoVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.StocksDetailVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.BusinessType;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OutstockInfoStatus;
import com.tydic.pfsc.enums.RecvAbleInfoRecvStatus;
import com.tydic.pfsc.enums.RecvAbleInfoRecvType;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.AccountantEngineService;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.BusiOutstockService;
import com.tydic.pfsc.service.atom.SourceMappingService;
import com.tydic.pfsc.service.atom.bo.AccountantEngineReqBO;
import com.tydic.pfsc.service.atom.bo.OutstockReqBO;
import com.tydic.pfsc.utils.FscStringUtils;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiOutstockServiceImpl
implements BusiOutstockService {
    private static final Logger logger = LoggerFactory.getLogger(BusiOutstockServiceImpl.class);
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private OutstockDetailMapper outstockDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private OutstockInfoMapper outstockInfoMapper;
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private RecvAbleInfoMapper recvAbleInfoMapper;
    @Autowired
    private AccountantEngineService accountantEngineService;
    @Autowired(required=false)
    private SourceMappingService sourceMappingService;

    @Override
    public PfscExtRspBaseBO insertAndUpdate(OutstockReqBO reqBO) {
        String applyNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u51fa\u5e93\u670d\u52a1\u5165\u53c2\uff1a" + (Object)((Object)reqBO));
        }
        if (!StringUtils.hasText((String)(applyNo = reqBO.getApplyNo()))) {
            throw new PfscExtBusinessException("0001", "\u5f00\u7968\u7533\u8bf7\u5355\u53f7[applyNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        String source = billApplyInfo.getSource();
        String applyType = billApplyInfo.getApplyType();
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setApplyNo(applyNo);
        saleInvoiceInfoVO.setInvoiceStatus(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode());
        List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
        BigDecimal writeoffAmt = BigDecimal.ZERO;
        if (OrderSource.CONSULT_PRICE.getCode().equals(source)) {
            SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setApplyNo(applyNo);
            List<SaleOrderInfo> orderList = this.saleItemInfoMapper.selectSumGroupByOrderId(saleItemInfoVO);
            for (SaleOrderInfo order : orderList) {
                Long orderId = order.getOrderId();
                String saleOrderCode = order.getSaleOrderCode();
                Object orderAmt = order.getOrderAmt();
                RecvAbleInfoVO recvAbleInfoVO = new RecvAbleInfoVO();
                recvAbleInfoVO.setOrderId(orderId);
                recvAbleInfoVO.setRecvType(RecvAbleInfoRecvType.ADVANCE_RECV.getCode());
                recvAbleInfoVO.setNeedAgainstAmtMoreThan(BigDecimal.ZERO);
                List<RecvAbleInfo> recvAbleInfoList = this.recvAbleInfoMapper.selectList(recvAbleInfoVO);
                for (RecvAbleInfo recvAbleInfo : recvAbleInfoList) {
                    RecvAbleInfo record;
                    BigDecimal needAgainstAmt = recvAbleInfo.getNeedAgainstAmt();
                    if (needAgainstAmt.compareTo((BigDecimal)orderAmt) >= 0) {
                        writeoffAmt = writeoffAmt.add((BigDecimal)orderAmt);
                        needAgainstAmt = needAgainstAmt.subtract((BigDecimal)orderAmt);
                        orderAmt = BigDecimal.ZERO;
                        record = new RecvAbleInfo();
                        record.setRecvableNo(recvAbleInfo.getRecvableNo());
                        record.setNeedAgainstAmt(needAgainstAmt);
                        this.recvAbleInfoMapper.updateByPrimaryKeySelective(record);
                        break;
                    }
                    writeoffAmt = writeoffAmt.add(needAgainstAmt);
                    orderAmt = ((BigDecimal)orderAmt).subtract(needAgainstAmt);
                    needAgainstAmt = BigDecimal.ZERO;
                    record = new RecvAbleInfo();
                    record.setRecvableNo(recvAbleInfo.getRecvableNo());
                    record.setNeedAgainstAmt(needAgainstAmt);
                    this.recvAbleInfoMapper.updateByPrimaryKeySelective(record);
                }
                if (((BigDecimal)orderAmt).compareTo(BigDecimal.ZERO) <= 0) continue;
                RecvAbleInfo record = new RecvAbleInfo();
                record.setRecvableNo(this.billSNService.getSnAsString(BillType.RECVABLE_ACCOUNT));
                record.setRecvType(RecvAbleInfoRecvType.ABLE_RECV.getCode());
                record.setRecvStatus(RecvAbleInfoRecvStatus.TO_RECEIVE.getCode());
                record.setOrderId(orderId);
                record.setSaleOrderCode(saleOrderCode);
                record.setSource(source);
                record.setPurchaseProjectId(billApplyInfo.getPurchaseProjectId());
                record.setRecvableAmt((BigDecimal)orderAmt);
                record.setWriteoffAmt(BigDecimal.ZERO);
                record.setNeedAgainstAmt(BigDecimal.ZERO);
                record.setInvoiceApyNo(billApplyInfo.getApplyNo());
                record.setOperUnitNo(billApplyInfo.getOperUnitNo());
                record.setSupplierNo(billApplyInfo.getSupplierNo());
                record.setPurchaseNo(billApplyInfo.getPurchaseNo());
                record.setRecvDate(null);
                record.setCreateDate(new Date());
                this.recvAbleInfoMapper.insert(record);
            }
        }
        String outstockNo = this.billSNService.getSnAsString(BillType.STOCK_OUT);
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal untaxAmt = BigDecimal.ZERO;
        BigDecimal amt = BigDecimal.ZERO;
        BigDecimal profits = BigDecimal.ZERO;
        HashSet<Long> seqSet = new HashSet<Long>();
        for (SaleInvoiceInfo invoice : saleInvoiceInfoList) {
            taxAmt = taxAmt.add(invoice.getTaxAmt());
            untaxAmt = untaxAmt.add(invoice.getUntaxAmt());
            amt = amt.add(invoice.getAmt());
            List<SaleInvoiceDetail> saleInvoiceDetaillist = this.saleInvoiceDetailMapper.selectByInvoiceNo(invoice.getInvoiceNo());
            for (SaleInvoiceDetail saleInvoiceDetail : saleInvoiceDetaillist) {
                OutstockDetail outstockDetail;
                SaleItemInfoVO saleItemInfoVO = null;
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                    saleItemInfoVO = new SaleItemInfoVO();
                    saleItemInfoVO.setApplyNo(applyNo);
                    saleItemInfoVO.setInspectionId(saleInvoiceDetail.getInspectionId());
                    saleItemInfoVO.setItemNo(saleInvoiceDetail.getItemNo());
                    saleItemInfoVO = this.saleItemInfoMapper.selectVOJoinSaleItemApplyInfo(saleItemInfoVO);
                } else {
                    saleItemInfoVO = new SaleItemInfoVO();
                    saleItemInfoVO.setInspectionId(saleInvoiceDetail.getInspectionId());
                    saleItemInfoVO.setItemNo(saleInvoiceDetail.getItemNo());
                    saleItemInfoVO = this.saleItemInfoMapper.selectVO(saleItemInfoVO);
                }
                OutstockDetailVO outstockDetailVO = new OutstockDetailVO();
                outstockDetailVO.setOutstockNo(outstockNo);
                outstockDetailVO.setInspectionId(saleInvoiceDetail.getInspectionId());
                outstockDetailVO.setItemNo(saleInvoiceDetail.getItemNo());
                List<OutstockDetail> outstockDetailList = this.outstockDetailMapper.selectList(outstockDetailVO);
                if (outstockDetailList.isEmpty()) {
                    outstockDetail = new OutstockDetail();
                    BeanUtils.copyProperties((Object)saleItemInfoVO, (Object)outstockDetail);
                    outstockDetail.setSeq(null);
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                        outstockDetail.setQuantity(saleItemInfoVO.getQuantityApply());
                    }
                    outstockDetail.setAmount(saleInvoiceDetail.getAmount());
                    outstockDetail.setUntaxAmt(saleInvoiceDetail.getUntaxAmt());
                    outstockDetail.setTaxAmt(saleInvoiceDetail.getTaxAmt());
                    outstockDetail.setOutstockNo(outstockNo);
                    outstockDetail.setInvoiceNo(invoice.getInvoiceNo());
                    outstockDetail.setInvoiceCode(invoice.getInvoiceCode());
                    this.outstockDetailMapper.insertSelective(outstockDetail);
                } else {
                    outstockDetail = outstockDetailList.get(0);
                    OutstockDetail forUpdate = new OutstockDetail();
                    forUpdate.setSeq(outstockDetail.getSeq());
                    if (!StringUtils.hasText((String)outstockDetail.getInvoiceNo()) || !outstockDetail.getInvoiceNo().contains(invoice.getInvoiceNo())) {
                        String invoiceNo = FscStringUtils.valueOf(outstockDetail.getInvoiceNo()) + "," + invoice.getInvoiceNo();
                        forUpdate.setInvoiceNo(invoiceNo);
                    }
                    forUpdate.setAmount(outstockDetail.getAmount().add(saleInvoiceDetail.getAmount()));
                    forUpdate.setUntaxAmt(outstockDetail.getUntaxAmt().add(saleInvoiceDetail.getUntaxAmt()));
                    forUpdate.setTaxAmt(outstockDetail.getTaxAmt().add(saleInvoiceDetail.getTaxAmt()));
                    this.outstockDetailMapper.updateByPrimaryKeySelective(forUpdate);
                }
                StocksDetail stocksDetail = this.stocksDetailMapper.selectByConditions(saleItemInfoVO.getInspectionId(), saleItemInfoVO.getPurchaseItemNo());
                if (stocksDetail == null) {
                    logger.error("\u8c03\u7528\u51fa\u5e93\u670d\u52a1\u5931\u8d25\u3002\u5e93\u5b58\u5546\u54c1[\u9a8c\u6536\u5355\u53f7=" + saleItemInfoVO.getInspectionId() + "\uff0c\u91c7\u8d2d\u5546\u54c1\u884c\u53f7=" + saleItemInfoVO.getPurchaseItemNo() + "]\u4e0d\u5b58\u5728\u3002\u5165\u53c2=" + (Object)((Object)reqBO));
                    throw new PfscExtBusinessException("18001", "\u8c03\u7528\u51fa\u5e93\u670d\u52a1\u5931\u8d25\u3002\u5e93\u5b58\u5546\u54c1[\u9a8c\u6536\u5355\u53f7=" + saleItemInfoVO.getInspectionId() + "\uff0c\u91c7\u8d2d\u5546\u54c1\u884c\u53f7=" + saleItemInfoVO.getPurchaseItemNo() + "]\u4e0d\u5b58\u5728\u3002");
                }
                profits = profits.add(saleInvoiceDetail.getUntaxAmt());
                if (seqSet.contains(stocksDetail.getSeq())) continue;
                BigDecimal untaxAmtReal = stocksDetail.getUntaxAmt();
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                    untaxAmtReal = untaxAmtReal.multiply(saleItemInfoVO.getQuantityApply()).divide(saleItemInfoVO.getQuantity(), 2, 4);
                }
                profits = profits.subtract(untaxAmtReal);
                StocksDetailVO stocksDetailVO = new StocksDetailVO();
                stocksDetailVO.setSeq(stocksDetail.getSeq());
                if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(applyType)) {
                    stocksDetailVO.setSaleQuantity(saleItemInfoVO.getQuantityApply());
                } else {
                    stocksDetailVO.setSaleQuantity(saleItemInfoVO.getQuantity());
                }
                this.stocksDetailMapper.updateRemainQuantity(stocksDetailVO);
                seqSet.add(stocksDetail.getSeq());
            }
        }
        OutstockInfo outstockInfo = new OutstockInfo();
        outstockInfo.setOutstockNo(outstockNo);
        outstockInfo.setOutstockDate(new Date());
        outstockInfo.setPurchaseNo(billApplyInfo.getPurchaseNo());
        outstockInfo.setPurchaseProjectId(billApplyInfo.getPurchaseProjectId());
        outstockInfo.setSource(source);
        outstockInfo.setCompanyOrg(billApplyInfo.getOperUnitNo());
        outstockInfo.setUntaxAmt(untaxAmt);
        outstockInfo.setTaxAmt(taxAmt);
        outstockInfo.setAmount(amt);
        outstockInfo.setWriteoffAmt(writeoffAmt);
        outstockInfo.setSupplierNo(billApplyInfo.getSupplierNo());
        outstockInfo.setApplyNo(applyNo);
        outstockInfo.setStatus(OutstockInfoStatus.NO_SUM.getCode());
        outstockInfo.setBranchCompany(billApplyInfo.getBranchCompany());
        this.outstockInfoMapper.insertSelective(outstockInfo);
        String targetSource = this.sourceMappingService.queryAccountingTargetSource(source);
        logger.debug("\u51fa\u5e93\u8bb0\u8d26,\u51fa\u5e93\u5355\u53f7=" + outstockNo + ",\u5e94\u7f34\u7a0e\u8d39=" + taxAmt + ",\u5229\u6da6=" + profits);
        AccountantEngineReqBO accBo = new AccountantEngineReqBO();
        accBo.setBusinessType(BusinessType.STOCK_OUT.getCode());
        accBo.setSource(targetSource);
        accBo.setOperUnit(billApplyInfo.getOperUnitNo());
        accBo.setServiceNo(outstockNo);
        accBo.setRemark("\u51fa\u5e93\u8bb0\u8d26");
        accBo.setAmounts(Arrays.asList(taxAmt, profits));
        this.accountantEngineService.executeAccountantEngine(accBo);
        return new PfscExtRspBaseBO();
    }
}

