/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.atom.impl;

import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.file.FileProcessing;
import com.tydic.pfsc.dao.AdvanceReceiveExtMapper;
import com.tydic.pfsc.dao.AdvanceReceiveMapper;
import com.tydic.pfsc.dao.FinanceConfigMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.RecAmtConfirmMapper;
import com.tydic.pfsc.dao.RecvAmtDetailMapper;
import com.tydic.pfsc.dao.po.AdvanceReceive;
import com.tydic.pfsc.dao.po.AdvanceReceiveExtPO;
import com.tydic.pfsc.dao.po.FinanceConfig;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.dao.po.InquiryPayOrderExt;
import com.tydic.pfsc.dao.po.RecAmtConfirm;
import com.tydic.pfsc.dao.po.RecvAmtDetail;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.vo.AdvanceReceiveVO;
import com.tydic.pfsc.dao.vo.RecvAmtDetailVO;
import com.tydic.pfsc.dao.vo.WFEventResult;
import com.tydic.pfsc.enums.YuanGuangType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.api.BusiTransferRecAmtConfirmService;
import com.tydic.pfsc.external.api.bo.BusiTransferRecAmtConfirmAttachDetailReqBO;
import com.tydic.pfsc.external.api.bo.BusiTransferRecAmtConfirmDetailReqBO;
import com.tydic.pfsc.external.api.bo.BusiTransferRecAmtConfirmReqBO;
import com.tydic.pfsc.external.api.bo.BusiTransferRecAmtConfirmRspBO;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.atom.QueryDictKeyValueService;
import com.tydic.pfsc.service.atom.UserInfoService;
import com.tydic.pfsc.service.atom.WorkFlowFinishEvent;
import com.tydic.pfsc.utils.FileUtils;
import java.io.File;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="supplierPayRecAmtConfirmWorkFlowFinshEventImpl")
public class SupplierPayRecAmtConfirmWorkFlowFinshEventImpl
implements WorkFlowFinishEvent {
    private static final Logger logger = LoggerFactory.getLogger(SupplierPayRecAmtConfirmWorkFlowFinshEventImpl.class);
    private BusiTransferRecAmtConfirmService busiTransferRecAmtConfirmService;
    private RecAmtConfirmMapper recAmtConfirmMapper;
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    private FinanceConfigMapper financeConfigMapper;
    private AdvanceReceiveMapper advanceReceiveMapper;
    private QueryDictKeyValueService queryDictKeyValueService;
    private OrganizationInfoService organizationInfoService;
    private RecvAmtDetailMapper recvAmtDetailMapper;
    private EnumsService enumsService;
    private AdvanceReceiveExtMapper advanceReceiveExtMapper;
    private UserInfoService userInfoService;

    @Autowired
    public SupplierPayRecAmtConfirmWorkFlowFinshEventImpl(BusiTransferRecAmtConfirmService busiTransferRecAmtConfirmService, RecAmtConfirmMapper recAmtConfirmMapper, InquiryPayOrderMapper inquiryPayOrderMapper, FinanceConfigMapper financeConfigMapper, AdvanceReceiveMapper advanceReceiveMapper, QueryDictKeyValueService queryDictKeyValueService, OrganizationInfoService organizationInfoService, RecvAmtDetailMapper recvAmtDetailMapper, EnumsService enumsService, AdvanceReceiveExtMapper advanceReceiveExtMapper, UserInfoService userInfoService) {
        this.busiTransferRecAmtConfirmService = busiTransferRecAmtConfirmService;
        this.recAmtConfirmMapper = recAmtConfirmMapper;
        this.inquiryPayOrderMapper = inquiryPayOrderMapper;
        this.financeConfigMapper = financeConfigMapper;
        this.advanceReceiveMapper = advanceReceiveMapper;
        this.queryDictKeyValueService = queryDictKeyValueService;
        this.organizationInfoService = organizationInfoService;
        this.recvAmtDetailMapper = recvAmtDetailMapper;
        this.enumsService = enumsService;
        this.advanceReceiveExtMapper = advanceReceiveExtMapper;
        this.userInfoService = userInfoService;
    }

    @Override
    public WFEventResult process(WorkFlowDataInfo workFlowDataInfo, String billType, String billNo) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u6536\u6b3e\u786e\u8ba4\u5355\u5ba1\u6279\u6d41\u5b8c\u6210\u4e8b\u4ef6\u5904\u7406\u5165\u53c2\uff1aworkFlowDataInfo=" + workFlowDataInfo + ";billType=" + billType + ";billNo=" + billNo);
        }
        if (!StringUtils.hasText((String)billNo)) {
            throw new PfscExtBusinessException("0001", "\u6536\u6b3e\u5355\u6d41\u6c34\u53f7[billNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Long docNum = Long.valueOf(billNo);
        RecAmtConfirm recAmtConfirm = this.recAmtConfirmMapper.selectByPrimaryKey(docNum);
        if (recAmtConfirm == null) {
            logger.error("\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u6536\u6b3e\u5355\u4fe1\u606f\u8868d_rec_amt_confirm\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u6536\u6b3e\u5355\u4fe1\u606f\u8868d_rec_amt_confirm\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
        }
        BusiTransferRecAmtConfirmReqBO reqBO = new BusiTransferRecAmtConfirmReqBO();
        FinanceConfig financeConfig = this.financeConfigMapper.selectByPrimaryKey(recAmtConfirm.getSource(), recAmtConfirm.getOrgId(), YuanGuangType.COL_RECEIVABLE_BUSINESS.getCode());
        if (financeConfig == null) {
            logger.error("\u6839\u636e\u6765\u6e90\uff1a" + recAmtConfirm.getSource() + "\uff0c\u4e13\u4e1a\u516c\u53f8\uff1a" + recAmtConfirm.getOrgId() + "\u5355\u636e\u7c7b\u578b\uff1a" + YuanGuangType.COL_RECEIVABLE_BUSINESS.getCode() + "\u67e5\u4e0d\u5230\u914d\u7f6e\u4fe1\u606f\uff01");
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u6765\u6e90\uff1a" + recAmtConfirm.getSource() + "\uff0c\u4e13\u4e1a\u516c\u53f8\uff1a" + recAmtConfirm.getOrgId() + "\u5355\u636e\u7c7b\u578b\uff1a" + YuanGuangType.COL_RECEIVABLE_BUSINESS.getCode() + "\u67e5\u4e0d\u5230\u914d\u7f6e\u4fe1\u606f\uff01");
        }
        Map<String, String> map = this.queryDictKeyValueService.queryDictKeyValue(recAmtConfirm.getSource(), YuanGuangType.COL_RECEIVABLE_BUSINESS.getCode());
        reqBO.setSeqid("PAY" + YuanGuangType.COL_RECEIVABLE_BUSINESS.getCode() + billNo);
        reqBO.setSsdw(financeConfig.getUnitName());
        reqBO.setYhdm(this.userInfoService.queryFinanceUserCodeByUserId(recAmtConfirm.getSource(), financeConfig, recAmtConfirm.getLoginId()));
        reqBO.setFlowid(financeConfig.getProcessId());
        reqBO.setSummary(map.get("\u6458\u8981"));
        LinkedList<BusiTransferRecAmtConfirmDetailReqBO> items = new LinkedList<BusiTransferRecAmtConfirmDetailReqBO>();
        InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
        inquiryPayOrderExt.setDocNum(docNum);
        List<InquiryPayOrder> inquiryPayOrderList = this.inquiryPayOrderMapper.getList(inquiryPayOrderExt);
        if (inquiryPayOrderList == null || inquiryPayOrderList.size() == 0) {
            logger.error("\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u8be2\u6bd4\u4ef7\u7f34\u8d39\u5355\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            throw new PfscExtBusinessException("18001", "\u6839\u636e\u6536\u6b3e\u5355\u6d41\u6c34\u53f7\uff1a" + docNum + "\u5728\u8be2\u6bd4\u4ef7\u7f34\u8d39\u5355\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
        }
        for (InquiryPayOrder inquiryPayOrder : inquiryPayOrderList) {
            BusiTransferRecAmtConfirmDetailReqBO item = new BusiTransferRecAmtConfirmDetailReqBO();
            item.setYwlx(map.get("\u4e1a\u52a1\u7c7b\u578b\uff08\u9884\u6536\uff09"));
            item.setHtbh(this.enumsService.querySupplierPaySaleContactNo());
            item.setCppzfl(map.get("\u4ea7\u54c1\u54c1\u79cd\u5206\u7c7b"));
            item.setFkf(this.organizationInfoService.querySupplierName(inquiryPayOrder.getSupplierId()));
            item.setSkf(financeConfig.getUnitNameNormal());
            item.setYwsx(map.get("\u4e1a\u52a1\u4e8b\u9879"));
            item.setSkfs(map.get("\u6536\u6b3e\u65b9\u5f0f\uff08\u94f6\u884c\u6536\u6b3e\uff09"));
            RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
            recvAmtDetailVO.setPayOrderNo(inquiryPayOrder.getPayOrderNo());
            List<RecvAmtDetail> recvAmtDetailList = this.recvAmtDetailMapper.getList(recvAmtDetailVO);
            if (recvAmtDetailList == null || recvAmtDetailList.size() == 0) {
                throw new PfscExtBusinessException("18001", "\u6839\u636e\u7f34\u8d39\u8ba2\u5355\u53f7\uff1a" + inquiryPayOrder.getPayOrderNo() + "\u5728\u5e94\u6536\u5b9e\u6536\u6b3e\u660e\u7ec6\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
            }
            AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey(((RecvAmtDetail)recvAmtDetailList.get(0)).getAdvRecvSeq());
            if (advanceReceive == null) {
                AdvanceReceiveExtPO advanceExtPO = this.advanceReceiveExtMapper.selectByPrimaryKey(((RecvAmtDetail)recvAmtDetailList.get(0)).getAdvRecvSeq());
                if (advanceExtPO == null) {
                    throw new PfscExtBusinessException("18001", "\u6839\u636e\u6253\u6b3e(\u9884\u6536)\u6d41\u6c34\u53f7\uff1a" + ((RecvAmtDetail)recvAmtDetailList.get(0)).getAdvRecvSeq() + "\u5728\u9884\u6536\u6b3e\u4fe1\u606f\u8868\u4e2d\u67e5\u4e0d\u5230\u6570\u636e\uff01");
                }
                item.setSkyhzh(advanceExtPO.getRecAcct());
            } else {
                item.setSkyhzh(advanceReceive.getRecAcct());
            }
            item.setXjllfl(map.get("\u73b0\u91d1\u6d41\u91cf\u5206\u7c7b"));
            item.setSkje(inquiryPayOrder.getPayMoney());
            item.setSkqyskje(BigDecimal.ZERO);
            item.setBcysje(inquiryPayOrder.getPayMoney());
            String payTime = "";
            payTime = inquiryPayOrder.getPayFinshTime() != null ? sdf.format(inquiryPayOrder.getPayFinshTime()) : (inquiryPayOrder.getPayStartTime() != null ? sdf.format(inquiryPayOrder.getPayStartTime()) : sdf.format(new Date()));
            item.setBz("\u4ed8\u6b3e\u65f6\u95f4\uff1a" + payTime + ";" + inquiryPayOrder.getMark());
            items.add(item);
        }
        reqBO.setItems(items);
        ArrayList<BusiTransferRecAmtConfirmAttachDetailReqBO> attachItems = new ArrayList<BusiTransferRecAmtConfirmAttachDetailReqBO>();
        reqBO.setAttachItems(attachItems);
        AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
        advanceReceiveVO.setDocNum(docNum);
        Page page = new Page(1, 99999999);
        List<AdvanceReceive> advanceReceives = this.advanceReceiveMapper.selectListPageDlzq(advanceReceiveVO, (Page<Map<String, Object>>)page);
        for (AdvanceReceive advanceReceive : advanceReceives) {
            String receipt = advanceReceive.getReceipt();
            if (!StringUtils.hasText((String)receipt)) continue;
            File file = null;
            try {
                file = FileProcessing.downloadFile((String)receipt, (String)"PAY", null);
            }
            catch (Exception e) {
                logger.error("\u4eceOSS\u4e0b\u8f7d\u6587\u4ef6\u51fa\u9519\u3002\u6587\u4ef6\u540d\uff1a" + receipt);
            }
            if (file != null) {
                String content = FileUtils.fileToBase64(file);
                BusiTransferRecAmtConfirmAttachDetailReqBO fjxx = new BusiTransferRecAmtConfirmAttachDetailReqBO();
                fjxx.setName(receipt);
                fjxx.setContent(content);
                attachItems.add(fjxx);
            }
            org.apache.commons.io.FileUtils.deleteQuietly((File)file);
        }
        WFEventResult wfEventResult = new WFEventResult();
        BusiTransferRecAmtConfirmRspBO rspBO = null;
        try {
            rspBO = this.busiTransferRecAmtConfirmService.transfer(reqBO);
            wfEventResult.setSsn(rspBO.getCwdjid());
            if ("1".equals(rspBO.getRspcode())) {
                wfEventResult.setSuccess(true);
            } else {
                wfEventResult.setSuccess(false);
            }
            wfEventResult.setRespDesc(rspBO.getRspmsg());
            wfEventResult.setRespCode(rspBO.getRspcode());
        }
        catch (Exception e) {
            wfEventResult.setSuccess(false);
            wfEventResult.setRespDesc("\u9519\u8bef\u4fe1\u606f\uff1a" + e);
            logger.error("\u6536\u6b3e\u5355\uff08\u6536\u6b3e\u4e1a\u52a1\u5904\u7406\u5355\uff09\u8c03\u7b2c\u4e09\u65b9\u63a5\u53e3\u5931\u8d25\uff01 " + e);
        }
        return wfEventResult;
    }
}

