/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiAddBillApplyInfoForApplyService;
import com.tydic.pfsc.api.busi.bo.BusiAddBillApplyInfoForApplyReqBO;
import com.tydic.pfsc.api.busi.bo.BusiAddBillApplyInfoForApplyRspBO;
import com.tydic.pfsc.api.busi.vo.InvoiceHeaderVO;
import com.tydic.pfsc.api.busi.vo.InvoiceMailAddrInfoVO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiAddBillApplyInfoForApplyService"})
public class BusiAddBillApplyInfoForApplyServiceImpl
implements BusiAddBillApplyInfoForApplyService {
    private static final Logger log = LoggerFactory.getLogger(BusiAddBillApplyInfoForApplyServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    @PostMapping(value={"addBillApplyInfoForApply"})
    public BusiAddBillApplyInfoForApplyRspBO addBillApplyInfoForApply(@RequestBody BusiAddBillApplyInfoForApplyReqBO reqBO) {
        SaleItemInfo saleItemInfo2;
        BusiAddBillApplyInfoForApplyRspBO rspBO = new BusiAddBillApplyInfoForApplyRspBO();
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List inspectionIds = reqBO.getInspectionIds();
        if (inspectionIds == null || inspectionIds.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u9a8c\u6536\u5355\u53f7\u3010inspectionIds\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceHeaderVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoVO mailAddrInfo = reqBO.getMailAddrInfo();
        if (invoiceInfo == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)invoiceInfo.getInvoiceTitle())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e2d\u7684\u53d1\u7968\u62ac\u5934\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mailAddrInfo == null) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)mailAddrInfo.getName())) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setInspectionIdList(inspectionIds);
        saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
        List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getList(saleItemInfoVO);
        if (inspectionIds.size() != saleItemInfoList.size()) {
            throw new PfscExtBusinessException("18000", "\u5546\u54c1\u660e\u7ec6\u7684\u72b6\u6001\u5df2\u6539\u53d8\uff0c\u8bf7\u91cd\u65b0\u67e5\u8be2\u5e76\u52fe\u9009");
        }
        BigDecimal amt = BigDecimal.ZERO;
        for (SaleItemInfo saleItemInfo2 : saleItemInfoList) {
            amt = amt.add(saleItemInfo2.getAmount());
        }
        SaleItemInfoVO saleItemInfoVO2 = new SaleItemInfoVO();
        saleItemInfoVO2.setInspectionIdList(inspectionIds);
        saleItemInfoVO2.setItemStatus(OrderStatus.NO_APPLY.getCode());
        saleItemInfo2 = new SaleItemInfo();
        String applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
        saleItemInfo2.setApplyNo(applyNo);
        saleItemInfo2.setItemStatus(OrderStatus.APPLIED.getCode());
        this.saleItemInfoMapper.updateByCondition(saleItemInfoVO2, saleItemInfo2);
        for (Long inspectionId : inspectionIds) {
            saleItemInfoVO = new SaleItemInfoVO();
            saleItemInfoVO.setInspectionId(inspectionId);
            saleItemInfoVO.setItemStatus(OrderStatus.NO_APPLY.getCode());
            int count = this.saleItemInfoMapper.selectCount(saleItemInfoVO);
            String newOrderStatus = OrderStatus.NO_APPLY.getCode();
            if (count == 0) {
                newOrderStatus = OrderStatus.APPLIED.getCode();
            }
            SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
            saleOrderInfoVO.setInspectionId(inspectionId);
            saleOrderInfoVO.setOrderStatus(OrderStatus.NO_APPLY.getCode());
            SaleOrderInfo newSaleOrderInfo = new SaleOrderInfo();
            newSaleOrderInfo.setOrderStatus(newOrderStatus);
            newSaleOrderInfo.setApplyNo(applyNo);
            this.saleOrderInfoMapper.updateByCondition(saleOrderInfoVO, newSaleOrderInfo);
        }
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setInvoiceType(String.valueOf(invoiceInfo.getInvoiceType()));
        billApplyInfo.setInvoceName(invoiceInfo.getInvoiceTitle());
        billApplyInfo.setTaxNo(invoiceInfo.getTaxpayerId());
        billApplyInfo.setAddr(invoiceInfo.getAddress());
        billApplyInfo.setPhone(invoiceInfo.getPhone());
        billApplyInfo.setBankName(invoiceInfo.getBank());
        billApplyInfo.setBankAcctNo(invoiceInfo.getAccount());
        billApplyInfo.setName(mailAddrInfo.getName());
        billApplyInfo.setProvince(mailAddrInfo.getProvince());
        billApplyInfo.setCity(mailAddrInfo.getCity());
        billApplyInfo.setCounty(mailAddrInfo.getCounty());
        billApplyInfo.setTown("0".equals(mailAddrInfo.getTown()) ? null : mailAddrInfo.getTown());
        billApplyInfo.setProvId(mailAddrInfo.getProvId());
        billApplyInfo.setCityId(mailAddrInfo.getCityId());
        billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
        billApplyInfo.setTownId(mailAddrInfo.getTownId());
        billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
        billApplyInfo.setMobile(mailAddrInfo.getTel());
        billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
        billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
        billApplyInfo.setApplyNo(applyNo);
        billApplyInfo.setApplyDate(new Date());
        billApplyInfo.setAmt(amt);
        billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
        billApplyInfo.setUserId(reqBO.getUserId());
        billApplyInfo.setSubUserName(reqBO.getUsername());
        SaleOrderInfo saleOrderInfo = new SaleOrderInfo();
        saleOrderInfo.setInspectionId(saleItemInfoList.get(0).getInspectionId());
        saleOrderInfo = this.saleOrderInfoMapper.getModelBy(saleOrderInfo);
        if (OrderSource.CONSULT_PRICE.getCode().equals(saleOrderInfo.getSource()) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(saleOrderInfo.getSource())) {
            billApplyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
        } else {
            billApplyInfo.setSource(saleOrderInfo.getSource());
            billApplyInfo.setSupplierNo(saleOrderInfo.getSupplierNo());
            billApplyInfo.setSupplierName(saleOrderInfo.getSupplierName());
        }
        billApplyInfo.setPurchaseNo(saleOrderInfo.getPurchaseNo());
        billApplyInfo.setPurchaseName(saleOrderInfo.getPurchaseName());
        billApplyInfo.setPurchaseProjectId(saleOrderInfo.getPurchaseProjectId());
        billApplyInfo.setOperUnitNo(saleOrderInfo.getOperUnitNo());
        billApplyInfo.setOperUnitName(saleOrderInfo.getOperUnitName());
        billApplyInfo.setBranchCompany(saleOrderInfo.getBranchCompany());
        billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ITEM.getCode());
        billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
        int flag = this.billApplyInfoMapper.insert(billApplyInfo);
        log.error("\u8fd0\u8425\u65b9\u9500\u552e\u8ba2\u5355\u6302\u8d77\u66f4\u65b0\uff1a" + flag);
        if (flag < 1) {
            rspBO.setRespCode("\u5931\u8d25");
            rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u5931\u8d25\uff01");
        } else {
            rspBO.setRespDesc("\u5f00\u7968\u7533\u8bf7\u6210\u529f\uff01");
            rspBO.setRespCode("0000");
        }
        return rspBO;
    }
}

