/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiExportEntryTotalInfoService;
import com.tydic.pfsc.api.busi.FscQryAuditDetailBusiService;
import com.tydic.pfsc.api.busi.bo.AuditLogDetailBO;
import com.tydic.pfsc.api.busi.bo.BusiExportEntryTotalInfoReqBO;
import com.tydic.pfsc.api.busi.bo.BusiExportEntryTotalInfoRspBO;
import com.tydic.pfsc.api.busi.bo.FscQryAuditDetailBusiReqBO;
import com.tydic.pfsc.api.busi.bo.FscQryAuditDetailBusiRspBO;
import com.tydic.pfsc.api.busi.vo.BusiExportApplyPayVO;
import com.tydic.pfsc.api.busi.vo.BusiExportEntryInfoVO;
import com.tydic.pfsc.api.busi.vo.BusiExportHeadEntryTotalVO;
import com.tydic.pfsc.dao.EntryInfoMapper;
import com.tydic.pfsc.dao.EntryTotalInfoMapper;
import com.tydic.pfsc.dao.SupplierInfoMapper;
import com.tydic.pfsc.dao.WorkFlowDataMapper;
import com.tydic.pfsc.dao.po.EntryInfoPO;
import com.tydic.pfsc.dao.po.EntryTotalInfoPO;
import com.tydic.pfsc.dao.po.SupplierInfo;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.vo.EntryTotalInfoVO;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.AmountUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiExportEntryTotalInfoServiceImpl
implements BusiExportEntryTotalInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiExportEntryTotalInfoServiceImpl.class);
    @Autowired
    private EntryTotalInfoMapper entryTotalMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EntryInfoMapper entryInfoMapper;
    @Autowired
    private SupplierInfoMapper supplierInfoMapper;
    @Autowired
    private WorkFlowDataMapper workFlowDataMapper;
    @Autowired
    private FscQryAuditDetailBusiService fscQryAuditDetailBusiService;
    @Autowired
    private EnumsService enumsService;

    public BusiExportEntryTotalInfoRspBO exportEntryTotal(BusiExportEntryTotalInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.info("\u5bfc\u51fa\u7269\u8d44\u6c47\u603b\u5355PDF\u670d\u52a1\u5b9e\u73b0\u7c7b\u7684\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)reqBO.getApplyNo())) {
            throw new PfscExtBusinessException("18000", "\u6c47\u603b\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        reqBO.setCompanyId(reqBO.getCompanyId());
        if (null == reqBO.getCompanyId()) {
            throw new PfscExtBusinessException("18000", "\u8fd0\u8425\u5355\u4f4dID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ArrayList<BusiExportApplyPayVO> applyPayVOList = new ArrayList<BusiExportApplyPayVO>();
        ArrayList<BusiExportEntryInfoVO> entryInfoVOList = new ArrayList<BusiExportEntryInfoVO>();
        EntryTotalInfoVO entryTotalInfoVO = new EntryTotalInfoVO();
        entryTotalInfoVO.setApplyNo(reqBO.getApplyNo());
        entryTotalInfoVO.setCompanyId(reqBO.getCompanyId());
        EntryTotalInfoPO entryTotalPO = this.entryTotalMapper.getModelById(entryTotalInfoVO);
        if (entryTotalPO == null) {
            logger.error("\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a\uff0c\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + reqBO.getApplyNo());
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u6c47\u603b\u5355\u4fe1\u606f\u8fd4\u56de\u4e3a\u7a7a");
        }
        EntryInfoPO entryInfo = new EntryInfoPO();
        entryInfo.setApplyNo(reqBO.getApplyNo());
        List<EntryInfoPO> entryInfoList = this.entryInfoMapper.getList(entryInfo);
        if (entryInfoList == null) {
            logger.error("\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u6c47\u603b\u5355\u8be6\u60c5\u8fd4\u56de\u4e3a\u7a7a\uff0c\u6c47\u603b\u5355\u53f7\u4e3a:" + reqBO.getApplyNo());
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u6c47\u603b\u5355\u8be6\u60c5\u8fd4\u56de\u4e3a\u7a7a");
        }
        for (EntryInfoPO entryInfoPO : entryInfoList) {
            BusiExportEntryInfoVO exportEntryInfo = new BusiExportEntryInfoVO();
            exportEntryInfo.setNotTaxAmt(entryInfoPO.getNotTaxAmt().toString());
            exportEntryInfo.setTax(entryInfoPO.getTax().toString());
            exportEntryInfo.setAmt(entryInfoPO.getAmt().toString());
            exportEntryInfo.setTaxRate(AmountUtils.format(this.enumsService.queryDefaultTaxRate()));
            entryInfoVOList.add(exportEntryInfo);
            Long supplierId = entryInfoPO.getPurchaseId();
            SupplierInfo supplierInfo = this.supplierInfoMapper.selectByPrimaryKey(supplierId);
            BusiExportApplyPayVO exportApplyPay = new BusiExportApplyPayVO();
            if (null == supplierInfo) {
                exportApplyPay.setContactNo("");
            } else {
                exportApplyPay.setContactNo(supplierInfo.getEffectContactNo());
            }
            String orgName = this.organizationInfoService.querySupplierName(entryInfoPO.getPurchaseId());
            exportApplyPay.setSupplierName(orgName);
            exportApplyPay.setPayAmt(entryInfoPO.getAmt().toString());
            applyPayVOList.add(exportApplyPay);
        }
        WorkFlowDataInfo workFlowDataInfo = new WorkFlowDataInfo();
        workFlowDataInfo.setBillNo(reqBO.getApplyNo());
        workFlowDataInfo = this.workFlowDataMapper.getModelBy(workFlowDataInfo);
        if (null == workFlowDataInfo) {
            logger.error("\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u5ba1\u6279\u6d41\u6570\u636e\u8868\u8fd4\u56de\u4e3a\u7a7a,\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + reqBO.getApplyNo());
            throw new PfscExtBusinessException("18000", "\u6839\u636e\u6c47\u603b\u5355\u53f7\u67e5\u8be2\u5ba1\u6279\u6d41\u6570\u636e\u8868\u8fd4\u56de\u4e3a\u7a7a");
        }
        FscQryAuditDetailBusiReqBO qryAuditDetailBusiReqBO = new FscQryAuditDetailBusiReqBO();
        qryAuditDetailBusiReqBO.setProcInstId(workFlowDataInfo.getProcInstId());
        FscQryAuditDetailBusiRspBO qryAuditDetailBusiRspBO = this.fscQryAuditDetailBusiService.qryAuditDetail(qryAuditDetailBusiReqBO);
        if (null == qryAuditDetailBusiRspBO) {
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5ba1\u6279\u8fc7\u7a0b\u5931\u8d25");
        }
        List detailBOS = qryAuditDetailBusiRspBO.getRows();
        BusiExportHeadEntryTotalVO headEntryTotalVO = new BusiExportHeadEntryTotalVO();
        headEntryTotalVO.setCompanyName(this.organizationInfoService.queryOrgName(entryTotalPO.getCompanyId()));
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String date = formatter.format(entryTotalPO.getDocumentationDate());
        headEntryTotalVO.setDocumentationDate(date);
        headEntryTotalVO.setApplyNo(entryTotalPO.getApplyNo());
        headEntryTotalVO.setNotTaxAmt(entryTotalPO.getNotTaxAmt().toString());
        headEntryTotalVO.setTax(entryTotalPO.getTax().toString());
        headEntryTotalVO.setAmt(entryTotalPO.getAmt().toString());
        String amtUpper = AmountUtils.upper(entryTotalPO.getAmt());
        headEntryTotalVO.setAmtUpper(amtUpper);
        String supplierName = this.organizationInfoService.querySupplierName(entryTotalPO.getPurchaseId());
        String economiContent = "\u7ed3\u7b97" + supplierName + "\u6750\u6599\u6b3e";
        headEntryTotalVO.setEconomiContent(economiContent);
        headEntryTotalVO.setRemark(economiContent);
        BusiExportEntryTotalInfoRspBO rspBO = new BusiExportEntryTotalInfoRspBO();
        rspBO.setApplyPayRows(applyPayVOList);
        rspBO.setEntryInfoRows(entryInfoVOList);
        rspBO.setHeadData(headEntryTotalVO);
        rspBO.setReturnMsg("\u8868\u5934\u4fe1\u606f\uff1a" + headEntryTotalVO.toString() + "\u7269\u8d44\u5206\u7c7b\u76f8\u5173\u4fe1\u606f\uff1a" + ((Object)entryInfoVOList).toString() + ",\u91c7\u8d2d\u5408\u540c\u76f8\u5173\u4fe1\u606f\uff1a" + ((Object)applyPayVOList).toString());
        rspBO.setFqr(detailBOS.size() < 1 || detailBOS.get(0) == null ? "" : ((AuditLogDetailBO)detailBOS.get(0)).getOperName());
        rspBO.setSpr1(detailBOS.size() < 2 || detailBOS.get(1) == null ? "" : ((AuditLogDetailBO)detailBOS.get(1)).getOperName());
        rspBO.setSpr2(detailBOS.size() < 3 || detailBOS.get(2) == null ? "" : ((AuditLogDetailBO)detailBOS.get(2)).getOperName());
        return rspBO;
    }
}

