/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiPreReceiptWriteOffExtService;
import com.tydic.pfsc.api.busi.bo.BusiPreReceiptWriteOffExtReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPreReceiptWriteOffReqBO;
import com.tydic.pfsc.api.busi.bo.BusiPreReceiptWriteOffRspBO;
import com.tydic.pfsc.api.busi.vo.PrepayOrderVO;
import com.tydic.pfsc.dao.PayableDetailMapper;
import com.tydic.pfsc.dao.RecvAbleInfoMapper;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayableDetailPO;
import com.tydic.pfsc.dao.po.RecvAbleInfo;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.BusinessType;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.PayablePayType;
import com.tydic.pfsc.enums.PayableStatus;
import com.tydic.pfsc.enums.RecvAbleInfoRecvStatus;
import com.tydic.pfsc.enums.RecvAbleInfoRecvType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.AccountantEngineService;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.OrderCenterApiService;
import com.tydic.pfsc.service.atom.SourceMappingService;
import com.tydic.pfsc.service.atom.SubAccountService;
import com.tydic.pfsc.service.atom.bo.AccountantEngineReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BusiPreReceiptWriteOffExtServiceImpl
implements BusiPreReceiptWriteOffExtService {
    private static final Logger logger = LoggerFactory.getLogger(BusiPreReceiptWriteOffExtServiceImpl.class);
    @Autowired
    private SubAccountService subAccountService;
    @Autowired
    private OrderCenterApiService orderCenterApiService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;
    @Autowired
    private RecvAbleInfoMapper recvAbleInfoMapper;
    @Autowired(required=false)
    private SourceMappingService sourceMappingService;
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private AccountantEngineService accountantEngineService;

    public BusiPreReceiptWriteOffRspBO processWriteOff(BusiPreReceiptWriteOffExtReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u9884\u6536\u6838\u9500\u670d\u52a1\u5165\u53c2:" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getWriteOffDatas())) {
            throw new PfscExtBusinessException("0001", "\u6838\u9500\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.checkSource(reqBO.getWriteOffDatas());
        List<BusiPreReceiptWriteOffReqBO> writeOffDatasList = this.groupByProjectId(reqBO);
        ArrayList<AccountantEngineReqBO> accountantEngineReqBOList = new ArrayList<AccountantEngineReqBO>();
        for (BusiPreReceiptWriteOffReqBO busiPreReceiptWriteOffReqBO : writeOffDatasList) {
            List<AccountantEngineReqBO> engineReqBOS = this.dealWithWriteOff(busiPreReceiptWriteOffReqBO);
            if (CollectionUtils.isEmpty(engineReqBOS)) continue;
            accountantEngineReqBOList.addAll(engineReqBOS);
        }
        for (AccountantEngineReqBO accountantEngineReqBO : accountantEngineReqBOList) {
            this.accountantEngineService.executeAccountantEngine(accountantEngineReqBO);
        }
        return new BusiPreReceiptWriteOffRspBO();
    }

    private List<BusiPreReceiptWriteOffReqBO> groupByProjectId(BusiPreReceiptWriteOffExtReqBO reqBO) {
        LinkedList<BusiPreReceiptWriteOffReqBO> writeOffList = new LinkedList<BusiPreReceiptWriteOffReqBO>();
        HashMap writeOffMap = new HashMap(16);
        for (PrepayOrderVO prepayOrderVO : reqBO.getWriteOffDatas()) {
            Long projectId = prepayOrderVO.getPurchaseProjectId();
            if (writeOffMap.containsKey(projectId)) {
                ((List)writeOffMap.get(projectId)).add(prepayOrderVO);
                continue;
            }
            LinkedList<PrepayOrderVO> newWriteOffList = new LinkedList<PrepayOrderVO>();
            newWriteOffList.add(prepayOrderVO);
            writeOffMap.put(projectId, newWriteOffList);
        }
        for (Map.Entry entry : writeOffMap.entrySet()) {
            BusiPreReceiptWriteOffReqBO preWriteOff = new BusiPreReceiptWriteOffReqBO();
            preWriteOff.setWriteOffDatas(new LinkedList());
            preWriteOff.getWriteOffDatas().addAll((Collection)entry.getValue());
            preWriteOff.setProjectId(((PrepayOrderVO)((List)entry.getValue()).get(0)).getPurchaseProjectId());
            preWriteOff.setPurchaseNo(Long.valueOf(Long.parseLong(((PrepayOrderVO)((List)entry.getValue()).get(0)).getPurchaseNo())));
            preWriteOff.setCompanyId(reqBO.getCompanyId());
            preWriteOff.setUserId(reqBO.getUserId());
            writeOffList.add(preWriteOff);
        }
        return writeOffList;
    }

    private List<AccountantEngineReqBO> dealWithWriteOff(BusiPreReceiptWriteOffReqBO preWriteOffReqBO) {
        return null;
    }

    public PayableDetailPO createPrepayBill(PayItemInfo ord, Long operUnitNo, Long supNo, BigDecimal payableAmt, String source) {
        if (ord == null || ord.getOrderId() == null) {
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u91c7\u8d2d\u8ba2\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (supNo == null) {
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u4f9b\u5e94\u5546\u5fc5\u987b\u8f93\u5165");
        }
        if (operUnitNo == null) {
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u4e13\u4e1a\u516c\u53f8ID\u5fc5\u987b\u8f93\u5165");
        }
        if (source == null) {
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u6240\u5c5e\u6765\u6e90\u5fc5\u987b\u8f93\u5165");
        }
        if (payableAmt == null || payableAmt.compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("RSP_CODE_PARAM_ERROR", "\u9884\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        PayableDetailPO po = new PayableDetailPO();
        Long snNo = this.billSNService.getSn(BillType.PAYABLE_ACCOUNT);
        po.setPayableNo(String.valueOf(snNo));
        po.setNotificationNo(null);
        po.setOperatorId(operUnitNo);
        po.setOrderId(ord.getOrderId());
        po.setPurchaseOrderCode(ord.getSpec());
        po.setPurchaseOrderName(ord.getItemName());
        po.setPlaAgreementCode(ord.getUnitName());
        po.setSupplierId(supNo);
        po.setPayableAmt(payableAmt);
        po.setPaidAmt(BigDecimal.ZERO);
        po.setPendingAmt(BigDecimal.ZERO);
        po.setPayType(PayablePayType.PREPAY.getCode());
        po.setNeedAgainstAmt(payableAmt);
        po.setSource(source);
        po.setPayableStatus(PayableStatus.PENDING.getCode());
        po.setPaidDate(null);
        this.payableDetailMapper.insert(po);
        logger.info("\u4ea7\u751f\u9884(\u5e94)\u4ed8\u5355\u6210\u529f,\u5e94\u4ed8\u5355\u53f7=" + snNo + ",\u91d1\u989d=" + payableAmt + ",\u901a\u77e5\u5355=null,\u8ba2\u5355\u53f7=" + ord.getOrderId());
        return po;
    }

    public AccountantEngineReqBO createPreReceivableBill(Long saleOrderId, String saleOrderCode, Long operUnitNo, Long purchaseNo, Long projectId, Long supNo, BigDecimal recvAmt, String payAcctNo, String recvAcctNo, Long recConfirDocNum, Long oprLoginId, String source) {
        RecvAbleInfo recv = new RecvAbleInfo();
        recv.setRecvType(RecvAbleInfoRecvType.ADVANCE_RECV.getCode());
        recv.setRecvStatus(RecvAbleInfoRecvStatus.RECEIVED.getCode());
        recv.setSource(source);
        recv.setSupplierNo(supNo);
        recv.setOperUnitNo(operUnitNo);
        recv.setPurchaseNo(purchaseNo);
        recv.setOrderId(saleOrderId);
        recv.setSaleOrderCode(saleOrderCode);
        recv.setPurchaseProjectId(projectId);
        recv.setRecvableAmt(recvAmt);
        recv.setNeedAgainstAmt(recvAmt);
        recv.setWriteoffAmt(BigDecimal.ZERO);
        recv.setCreateDate(new Date());
        String sn = this.billSNService.getSnAsString(BillType.RECVABLE_ACCOUNT);
        recv.setRecvableNo(sn);
        this.recvAbleInfoMapper.insert(recv);
        logger.info("\u4ea7\u751f\u5e94\u6536\u5355\u6210\u529f,\u5e94\u6536\u5355\u53f7=" + recv.getRecvableNo() + ",\u91d1\u989d=" + recv.getRecvableAmt());
        String targetSource = this.sourceMappingService.queryAccountingTargetSource(source);
        AccountantEngineReqBO accBo = new AccountantEngineReqBO();
        accBo.setBusinessType(BusinessType.ORDER_PAY.getCode());
        accBo.setSource(targetSource);
        accBo.setClientAcctNo(payAcctNo);
        accBo.setOperUnit(operUnitNo);
        accBo.setServiceNo(saleOrderCode);
        accBo.setRemark("\u9500\u552e\u8ba2\u5355\u9884\u6536\u6838\u9500");
        accBo.setAmounts(Collections.singletonList(recvAmt));
        return accBo;
    }

    private Map<String, String> checkReqData(List<PrepayOrderVO> datas) {
        String purchaseNo = null;
        HashMap<String, String> data = new HashMap<String, String>(16);
        HashMap repeatCheck = new HashMap(16);
        BigDecimal tot = BigDecimal.ZERO;
        String source = null;
        for (PrepayOrderVO vo : datas) {
            if (!StringUtils.hasText(source)) {
                source = OrderSource.CONSULT_PRICE_FRAME.getCode().equals(vo.getSource()) ? OrderSource.CONSULT_PRICE.getCode() : vo.getSource();
            } else if (!(vo.getSource().equals(source) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(vo.getSource()) && OrderSource.CONSULT_PRICE.getCode().equals(source))) {
                throw new PfscExtBusinessException("18000", "\u4e0d\u540c\u6765\u6e90\u7684\u8ba2\u5355\u4e0d\u80fd\u4e00\u8d77\u6838\u9500\uff08\u8be2\u6bd4\u4ef7\u548c\u8be2\u6bd4\u4ef7\u6846\u67b6\u534f\u8bae\u4f8b\u5916\uff09");
            }
            if (!StringUtils.hasText((String)vo.getPurchaseOrderId())) {
                throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u8ba2\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
            }
            if (!StringUtils.hasText((String)vo.getSaleOrderId())) {
                throw new PfscExtBusinessException("0001", "\u9500\u552e\u8ba2\u5355\u53f7\u5fc5\u987b\u8f93\u5165");
            }
            if (!StringUtils.hasText((String)vo.getSupplierNo())) {
                throw new PfscExtBusinessException("0001", "\u4f9b\u5e94\u5546ID\u5fc5\u987b\u8f93\u5165");
            }
            if (!StringUtils.hasText((String)vo.getPurchaseNo())) {
                throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u5355\u4f4dID\u5fc5\u987b\u8f93\u5165");
            }
            if (vo.getWriteOffAmt() == null || vo.getWriteOffAmt().compareTo(BigDecimal.ZERO) <= 0) {
                throw new PfscExtBusinessException("0001", "\u672c\u6b21\u9884\u6536\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
            }
            if (vo.getThePrePayAmt() == null || vo.getThePrePayAmt().compareTo(BigDecimal.ZERO) < 0) {
                throw new PfscExtBusinessException("0001", "\u672c\u6b21\u9884\u4ed8\u91d1\u989d\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e0");
            }
            if (purchaseNo == null) {
                purchaseNo = vo.getPurchaseNo();
            }
            if (!vo.getPurchaseNo().equals(purchaseNo)) {
                throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u5355\u4f4dID\u4e0d\u4e00\u81f4");
            }
            if (repeatCheck.containsKey("P" + vo.getPurchaseOrderId())) {
                throw new PfscExtBusinessException("0001", "\u91c7\u8d2d\u8ba2\u5355\u4e0d\u80fd\u91cd\u590d\u751f\u6210\u9884\u4ed8");
            }
            repeatCheck.put("P" + vo.getPurchaseOrderId(), null);
            if (repeatCheck.containsKey("S" + vo.getSaleOrderId())) {
                throw new PfscExtBusinessException("0001", "\u9500\u552e\u8ba2\u5355\u4e0d\u80fd\u91cd\u590d\u6838\u9500");
            }
            repeatCheck.put("S" + vo.getSaleOrderId(), null);
            tot = tot.add(vo.getWriteOffAmt());
        }
        repeatCheck.clear();
        data.put("source", source);
        data.put("totWriteOffAmt", String.valueOf(tot));
        return data;
    }

    private void checkSource(List<PrepayOrderVO> writeOffDatas) {
        for (PrepayOrderVO prepayOrder : writeOffDatas) {
            if (!OrderSource.CONSULT_PRICE.getCode().equals(prepayOrder.getSource()) && !OrderSource.CONSULT_PRICE_FRAME.getCode().equals(prepayOrder.getSource())) continue;
            throw new PfscExtBusinessException("18000", "\u8be2\u6bd4\u4ef7\u914d\u9001\u7c7b\u8ba2\u5355\u4e0d\u80fd\u529e\u7406\u9884\u6536\u6838\u9500\u4e1a\u52a1");
        }
    }
}

