/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQryStocksDetailListService;
import com.tydic.pfsc.api.busi.bo.BusiQryStocksDetailListReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQryStocksDetailListRspBO;
import com.tydic.pfsc.api.busi.bo.StockDetailListBO;
import com.tydic.pfsc.dao.StocksDetailMapper;
import com.tydic.pfsc.dao.po.StocksDetail;
import com.tydic.pfsc.dao.vo.StocksDetailVO;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiQryStocksDetailListService"})
public class BusiQryStocksDetailListServiceImpl
implements BusiQryStocksDetailListService {
    private static final Logger log = LoggerFactory.getLogger(BusiQryStocksDetailListServiceImpl.class);
    @Autowired
    private StocksDetailMapper stocksDetailMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    @PostMapping(value={"qryStocksDetailList"})
    public BusiQryStocksDetailListRspBO qryStocksDetailList(@RequestBody BusiQryStocksDetailListReqBO reqBO) {
        log.error("\u5e93\u5b58\u5217\u8868\u67e5\u770b\u5165\u53c2\uff1a" + reqBO);
        BusiQryStocksDetailListRspBO rspBO = new BusiQryStocksDetailListRspBO();
        List<Object> detailListBOList = new ArrayList();
        StocksDetailVO vo = new StocksDetailVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)vo);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<StocksDetail> stocksDetails = this.stocksDetailMapper.getListPage(vo, (Page<Map<String, Object>>)page);
        log.error("stocksDetails=" + stocksDetails);
        if (!CollectionUtils.isEmpty(stocksDetails)) {
            detailListBOList = stocksDetails.stream().map(stocksDetail -> {
                StockDetailListBO stockDetailListBO = new StockDetailListBO();
                BeanUtils.copyProperties((Object)stocksDetail, (Object)stockDetailListBO);
                String supplierName = this.organizationInfoService.querySupplierName(stocksDetail.getSupplierNo());
                if (supplierName != null) {
                    stockDetailListBO.setSupplierName(supplierName);
                }
                stockDetailListBO.setStockQuality(stocksDetail.getQuantity().subtract(stocksDetail.getRemainQuality()));
                stockDetailListBO.setStockAmount(stockDetailListBO.getRemainQuality().multiply(stockDetailListBO.getSaleUnitPrice()).setScale(2, 4));
                return stockDetailListBO;
            }).collect(Collectors.toList());
            rspBO.setRows(detailListBOList);
            rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
            rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
            rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        }
        return rspBO;
    }
}

