/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQueryDetailBillApplyInfoService;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoApplyRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoInvoiceDetailRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoInvoiceInfoRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoInvoiceRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoItemRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoOrderRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoReqBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.UserInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiQueryDetailBillApplyInfoService"})
public class BusiQueryDetailBillApplyInfoServiceImpl
implements BusiQueryDetailBillApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryDetailBillApplyInfoServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private UserInfoService userInfoService;

    @PostMapping(value={"queryApply"})
    public BusiQueryDetailBillApplyInfoApplyRspBO queryApply(@RequestBody BusiQueryDetailBillApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u8be6\u60c5\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)-\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u4fe1\u606f\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(applyNo);
        saleOrderInfoVO.setOperUnitNo(billApplyInfo.getOperUnitNo());
        saleOrderInfoVO.setSource(billApplyInfo.getSource());
        saleOrderInfoVO.setOrderBy(" tt.inspectionId DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageByApplyNo(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO> orderList = new ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO>();
        if (saleOrderInfoList != null) {
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                SaleItemInfoVO condition = new SaleItemInfoVO();
                condition.setInspectionId(saleOrderInfo.getInspectionId());
                condition.setApplyNo(billApplyInfo.getApplyNo());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getListContainsItemApplyInfo(condition);
                ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
                    BeanUtils.copyProperties((Object)saleItemInfo, (Object)item);
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                        item.setAmountApply(saleItemInfo.getAmountApplied());
                        item.setQuantityApply(saleItemInfo.getQuantityApplied());
                    } else {
                        item.setAmountApply(saleItemInfo.getAmount());
                        item.setQuantityApply(saleItemInfo.getQuantity());
                    }
                    itemList.add(item);
                }
                BusiQueryDetailBillApplyInfoOrderRspBO order = new BusiQueryDetailBillApplyInfoOrderRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)order);
                order.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
                order.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
                order.setItemList(itemList);
                orderList.add(order);
            }
        }
        BusiQueryDetailBillApplyInfoApplyRspBO rspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
        try {
            rspBO.setSubUserName(this.userInfoService.queryUserNameByUserId(billApplyInfo.getUserId()));
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("18000", "\u8c03\u7528\u4f1a\u5458\u4e2d\u5fc3\u63a5\u53e3\uff1aUmcMemDetailQueryAbilityService \u5931\u8d25");
        }
        rspBO.setOrderCount(Integer.valueOf(page.getTotalCount()));
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    @PostMapping(value={"queryInvoice"})
    public BusiQueryDetailBillApplyInfoInvoiceRspBO queryInvoice(@RequestBody BusiQueryDetailBillApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u7533\u8bf7\u8be6\u60c5\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)-\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        BusiQueryDetailBillApplyInfoInvoiceRspBO rspBO = new BusiQueryDetailBillApplyInfoInvoiceRspBO();
        ArrayList<BusiQueryDetailBillApplyInfoInvoiceInfoRspBO> rows = new ArrayList<BusiQueryDetailBillApplyInfoInvoiceInfoRspBO>();
        rspBO.setRows(rows);
        SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
        saleInvoiceInfoVO.setApplyNo(applyNo);
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleInvoiceInfo> saleInvoiceInfoList = this.saleInvoiceInfoMapper.selectListPage(saleInvoiceInfoVO, (Page<Map<String, Object>>)page);
        rspBO.setIsExistsInvoice("1");
        if (saleInvoiceInfoList.isEmpty()) {
            rspBO.setIsExistsInvoice("0");
        }
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfoList) {
            BusiQueryDetailBillApplyInfoInvoiceInfoRspBO row = new BusiQueryDetailBillApplyInfoInvoiceInfoRspBO();
            ArrayList<BusiQueryDetailBillApplyInfoInvoiceDetailRspBO> invoiceDetails = new ArrayList<BusiQueryDetailBillApplyInfoInvoiceDetailRspBO>();
            row.setInvoiceDetails(invoiceDetails);
            rows.add(row);
            BeanUtils.copyProperties((Object)billApplyInfo, (Object)row);
            row.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
            row.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
            row.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
            row.setTaxAmt(saleInvoiceInfo.getTaxAmt());
            row.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
            row.setAmt(saleInvoiceInfo.getAmt());
            row.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
            List<SaleInvoiceDetail> saleInvoiceDetailList = this.saleInvoiceDetailMapper.selectByInvoiceNo(saleInvoiceInfo.getInvoiceNo());
            for (SaleInvoiceDetail saleInvoiceDetail : saleInvoiceDetailList) {
                BusiQueryDetailBillApplyInfoInvoiceDetailRspBO invoiceDetail = new BusiQueryDetailBillApplyInfoInvoiceDetailRspBO();
                BeanUtils.copyProperties((Object)saleInvoiceDetail, (Object)invoiceDetail);
                invoiceDetail.setInspectionId(String.valueOf(saleInvoiceDetail.getInspectionId()));
                invoiceDetail.setItemNo(String.valueOf(saleInvoiceDetail.getItemNo()));
                invoiceDetails.add(invoiceDetail);
            }
        }
        return rspBO;
    }
}

