/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQueryOutInvoiceService;
import com.tydic.pfsc.api.busi.bo.OutInvoiceInfoRepBO;
import com.tydic.pfsc.api.busi.bo.OutInvoiceInfoRspBO;
import com.tydic.pfsc.base.PfscExtRspPageBaseBO;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.OutInvoicePO;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.service.busi.impl.QueryEntryInfoServiceImpl;
import com.tydic.pfsc.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiQueryOutInvoiceService"})
public class BusiQueryOutInvoiceServiceImpl
implements BusiQueryOutInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(QueryEntryInfoServiceImpl.class);
    private final SaleInvoiceInfoMapper saleInvoiceInfoMapper;
    private final OrganizationInfoService organizationInfoService;
    private final EnumsService enumsService;

    public BusiQueryOutInvoiceServiceImpl(SaleInvoiceInfoMapper saleInvoiceInfoMapper, OrganizationInfoService organizationInfoService, EnumsService enumsService) {
        this.saleInvoiceInfoMapper = saleInvoiceInfoMapper;
        this.organizationInfoService = organizationInfoService;
        this.enumsService = enumsService;
    }

    @PostMapping(value={"queryPageOutInvoice"})
    public PfscExtRspPageBaseBO<OutInvoiceInfoRspBO> queryPageOutInvoice(@RequestBody OutInvoiceInfoRepBO reqBO) {
        List<OutInvoicePO> outInvoiceList;
        if (!StringUtils.hasText((String)reqBO.getTotalNo())) {
            throw new PfscExtBusinessException("0001", "\u6c47\u603b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((Object)reqBO.getSortName()) && !StringUtils.isEmpty((Object)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        if (!StringUtils.hasText(orderBy)) {
            orderBy = " t2.APPLY_NO asc,t2.INVOICE_NO asc";
        }
        PfscExtRspPageBaseBO rspPageBO = new PfscExtRspPageBaseBO();
        rspPageBO.setRespCode("0000");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        if (!StringUtils.hasText((String)reqBO.getApplyNo())) {
            List<OutInvoicePO> outInvoiceList2;
            try {
                outInvoiceList2 = this.saleInvoiceInfoMapper.selectListByTotalNo(reqBO.getTotalNo(), (Page<Map<String, Object>>)page, orderBy);
            }
            catch (Exception e) {
                logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u5931\u8d25\uff0c\u6c47\u603b\u7f16\u53f7\u4e3a\uff1a" + reqBO.getTotalNo(), (Throwable)e);
                throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u5931\u8d25");
            }
            if (CollectionUtils.isEmpty(outInvoiceList2)) {
                logger.error("\u627e\u4e0d\u5230\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55\uff0c\u6c47\u603b\u5355\u53f7\u4e3a\uff1a" + reqBO.getTotalNo());
                rspPageBO.setRespDesc("\u627e\u4e0d\u5230\u6c47\u603b\u5355\u53f7\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55");
                return rspPageBO;
            }
            this.assembleRspBO(outInvoiceList2, (Page<Map<String, Object>>)page, (PfscExtRspPageBaseBO<OutInvoiceInfoRspBO>)rspPageBO);
            return rspPageBO;
        }
        try {
            outInvoiceList = this.saleInvoiceInfoMapper.getListByApplyNo(reqBO.getApplyNo(), (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u5931\u8d25\uff0c\u53d1\u7968\u901a\u77e5\u5355\u7f16\u53f7\u4e3a\uff1a" + reqBO.getApplyNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(outInvoiceList)) {
            logger.error("\u627e\u4e0d\u5230\u53d1\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55\uff0c\u53d1\u7968\u901a\u77e5\u5355\u4e3a\uff1a" + reqBO.getApplyNo());
            rspPageBO.setRespDesc("\u627e\u4e0d\u5230\u53d1\u7968\u901a\u77e5\u5355\u5bf9\u5e94\u7684\u53d1\u7968\u8bb0\u5f55");
            return rspPageBO;
        }
        this.assembleRspBO(outInvoiceList, (Page<Map<String, Object>>)page, (PfscExtRspPageBaseBO<OutInvoiceInfoRspBO>)rspPageBO);
        return rspPageBO;
    }

    private void assembleRspBO(List<OutInvoicePO> outInvoiceList, Page<Map<String, Object>> page, PfscExtRspPageBaseBO<OutInvoiceInfoRspBO> rspPageBO) {
        ArrayList<OutInvoiceInfoRspBO> outInvoiceInfoRspBO = new ArrayList<OutInvoiceInfoRspBO>();
        for (OutInvoicePO outInvoice : outInvoiceList) {
            OutInvoiceInfoRspBO outInvoiceInfoBO = new OutInvoiceInfoRspBO();
            outInvoice.setSupplierName(this.organizationInfoService.querySupplierName(outInvoice.getSupplierNo()));
            outInvoice.setInvoiceTypeName(this.enumsService.getDescr(InvoiceType.getInstance(outInvoice.getInvoiceType())));
            BeanUtils.copyProperties((Object)outInvoice, (Object)outInvoiceInfoBO);
            outInvoiceInfoRspBO.add(outInvoiceInfoBO);
        }
        rspPageBO.setRespDesc("\u67e5\u8be2\u51fa\u5e93\u5355\u53d1\u7968\u6210\u529f");
        rspPageBO.setRows(outInvoiceInfoRspBO);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
    }
}

