/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQueryOutstockDetailService;
import com.tydic.pfsc.api.busi.bo.BusiQueryOutstockDetaiReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryOutstockDetaiRspBO;
import com.tydic.pfsc.api.busi.vo.OutstockDetailVO;
import com.tydic.pfsc.dao.OutstockDetailMapper;
import com.tydic.pfsc.dao.OutstockInfoMapper;
import com.tydic.pfsc.dao.po.OutstockDetail;
import com.tydic.pfsc.dao.po.OutstockInfo;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiQueryOutstockDetailService"})
public class BusiQueryOutstockDetailServiceImpl
implements BusiQueryOutstockDetailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQueryOutstockDetailServiceImpl.class);
    private final OutstockDetailMapper outstockDetailMapper;
    private final OutstockInfoMapper outstockInfoMapper;
    private final OrganizationInfoService organizationInfoService;

    public BusiQueryOutstockDetailServiceImpl(OutstockDetailMapper outstockDetailMapper, OutstockInfoMapper outstockInfoMapper, OrganizationInfoService organizationInfoService) {
        this.outstockDetailMapper = outstockDetailMapper;
        this.outstockInfoMapper = outstockInfoMapper;
        this.organizationInfoService = organizationInfoService;
    }

    @PostMapping(value={"queryOutstockDetail"})
    public BusiQueryOutstockDetaiRspBO<OutstockDetailVO> queryOutstockDetail(@RequestBody BusiQueryOutstockDetaiReqBO reqBO) {
        List<OutstockDetail> outstockDetailList;
        OutstockInfo outstockInfo;
        if (!StringUtils.hasText((String)reqBO.getOutstockNo())) {
            throw new PfscExtBusinessException("0001", "\u51fa\u5e93\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiQueryOutstockDetaiRspBO rspPageBO = new BusiQueryOutstockDetaiRspBO();
        rspPageBO.setRespCode("0000");
        String orderBy = "t.SEQ ASC";
        try {
            outstockInfo = this.outstockInfoMapper.selectByPrimaryKey(reqBO.getOutstockNo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u51fa\u5e93\u5355\u53f7\u4e3a" + reqBO.getOutstockNo() + "\u8bb0\u5f55\u5931\u8d25", (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u51fa\u5e93\u5355\u53f7\u4e3a" + reqBO.getOutstockNo() + "\u8bb0\u5f55\u5931\u8d25");
        }
        if (outstockInfo == null) {
            rspPageBO.setRespCode("18000");
            rspPageBO.setRespDesc("\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u5355\u4e0d\u5b58\u5728");
            return rspPageBO;
        }
        BeanUtils.copyProperties((Object)outstockInfo, (Object)rspPageBO);
        String purchaseName = this.organizationInfoService.queryOrgName(outstockInfo.getPurchaseNo());
        rspPageBO.setPurchaseName(purchaseName);
        OutstockDetail outstockDetail = new OutstockDetail();
        outstockDetail.setOutstockNo(reqBO.getOutstockNo());
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        try {
            outstockDetailList = this.outstockDetailMapper.getListPage(outstockDetail, (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25\uff0c\u51fa\u5e93\u5355\u53f7\u4e3a\uff1a" + reqBO.getOutstockNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u6570\u636e\u5e93\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u8be6\u60c5\u8bb0\u5f55\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty(outstockDetailList)) {
            rspPageBO.setRespDesc("\u51fa\u5e93\u5355\u53f7\u5bf9\u5e94\u7684\u51fa\u5e93\u8be6\u60c5\u4e0d\u5b58\u5728");
            return rspPageBO;
        }
        ArrayList<OutstockDetailVO> outstockDetailVOList = new ArrayList<OutstockDetailVO>();
        for (OutstockDetail returnOutstock : outstockDetailList) {
            OutstockDetailVO outstockDetailVO = new OutstockDetailVO();
            BeanUtils.copyProperties((Object)returnOutstock, (Object)outstockDetailVO);
            outstockDetailVOList.add(outstockDetailVO);
        }
        rspPageBO.setRespDesc("\u51fa\u5e93\u5355\u8be6\u60c5\u67e5\u8be2\u6210\u529f");
        rspPageBO.setRows(outstockDetailVOList);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

