/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiGetInvoiceService;
import com.tydic.pfsc.api.busi.BusiReGetInvoiceService;
import com.tydic.pfsc.api.busi.bo.BusiGetInvoiceServiceReqBO;
import com.tydic.pfsc.api.busi.bo.BusiGetInvoiceServiceRspBO;
import com.tydic.pfsc.api.busi.bo.BusiRegetInvoiceReqBO;
import com.tydic.pfsc.api.busi.bo.BusiRegetInvoiceRspBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.dao.vo.BillNotificationInfoVO;
import com.tydic.pfsc.dao.vo.PayItemInfoVO;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiReGetInvoiceService"})
public class BusiReGetInvoiceServiceImpl
implements BusiReGetInvoiceService {
    private BillNotificationInfoMapper billNotificationInfoMapper;
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    private PayItemInfoMapper payItemInfoMapper;
    private BusiGetInvoiceService busiGetInvoiceService;

    @Autowired
    public BusiReGetInvoiceServiceImpl(BillNotificationInfoMapper billNotificationInfoMapper, PayInvoiceInfoMapper payInvoiceInfoMapper, PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper, PayItemInfoMapper payItemInfoMapper, BusiGetInvoiceService busiGetInvoiceService) {
        this.billNotificationInfoMapper = billNotificationInfoMapper;
        this.payInvoiceInfoMapper = payInvoiceInfoMapper;
        this.payPurchaseOrderInfoMapper = payPurchaseOrderInfoMapper;
        this.payItemInfoMapper = payItemInfoMapper;
        this.busiGetInvoiceService = busiGetInvoiceService;
    }

    @PostMapping(value={"updateGetInvoice"})
    public BusiRegetInvoiceRspBO updateGetInvoice(@RequestBody BusiRegetInvoiceReqBO reqBo) {
        if (CollectionUtils.isEmpty((Collection)reqBo.getNotificationNos())) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        List notificationNos = reqBo.getNotificationNos();
        BusiRegetInvoiceRspBO rspBO = new BusiRegetInvoiceRspBO();
        int count = this.billNotificationInfoMapper.selectStatusCountByNos(notificationNos, NotificationInvoiceStatus.SUBMITED.getCode(), NotificationInvoiceStatus.HAS_MAKE.getCode());
        if (count > 0) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u901a\u77e5\u5355\u7684\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u63d0\u4ea4 \u3001\u5df2\u5f00\u7968");
        }
        int invoiceCount = this.payInvoiceInfoMapper.selectCountByNotifyNos(notificationNos);
        int delete = this.payInvoiceInfoMapper.deleteByNotificationNos(notificationNos);
        if (delete < invoiceCount) {
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u5f02\u5e38");
        }
        BillNotificationInfoVO notification = new BillNotificationInfoVO();
        notification.setNotificationNos(notificationNos);
        notification.setInvoiceStatus(NotificationInvoiceStatus.SUBMITED.getCode());
        notification.setInvoiceResultNull("1");
        int update = this.billNotificationInfoMapper.update(notification);
        if (update < 1) {
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u5f02\u5e38");
        }
        for (String notificationNo : notificationNos) {
            PayPurchaseOrderInfo order = new PayPurchaseOrderInfo();
            order.setNotificationNo(notificationNo);
            order.setOrderStatus(OrderStatus.APPLIED.getCode());
            int updateStatus = this.payPurchaseOrderInfoMapper.updateStatus(order);
            if (updateStatus < 1) {
                throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u5f02\u5e38");
            }
            PayItemInfoVO item = new PayItemInfoVO();
            item.setNotificationNo(notificationNo);
            item.setItemStatus(OrderStatus.APPLIED.getCode());
            item.setInvoiceCodeNull("1");
            item.setInvoiceNoNull("1");
            int update1 = this.payItemInfoMapper.update(item);
            if (update1 >= 1) continue;
            throw new PfscExtBusinessException("18000", "\u6570\u636e\u5e93\u66f4\u65b0\u5f02\u5e38");
        }
        BusiGetInvoiceServiceReqBO reqBO = new BusiGetInvoiceServiceReqBO();
        reqBO.setNotificationNos(notificationNos);
        BusiGetInvoiceServiceRspBO getInvoiceServiceRspBO = this.busiGetInvoiceService.dealInvoice(reqBO);
        if (!"0000".equals(getInvoiceServiceRspBO.getRespCode())) {
            throw new PfscExtBusinessException("18000", "\u91cd\u65b0\u83b7\u53d6\u5f00\u7968\u6570\u636e\u5f02\u5e38");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u91cd\u65b0\u83b7\u53d6\u5f00\u7968\u6570\u636e\u6210\u529f");
        return rspBO;
    }
}

