/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.PlatfUseFeeHasMailInvoiceListService;
import com.tydic.pfsc.api.busi.bo.PlatfUseFeeHasMailInvoiceListReqBO;
import com.tydic.pfsc.api.busi.bo.PlatfUseFeeHasMailInvoiceListRspBO;
import com.tydic.pfsc.api.busi.vo.InvoiceForMailVO;
import com.tydic.pfsc.dao.SaleInvoiceMailInfoMapper;
import com.tydic.pfsc.enums.InvoiceMailSentStatus;
import com.tydic.pfsc.enums.InvoiceMailSentStatusCustom;
import com.tydic.pfsc.enums.JDAssignStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PlatfUseFeeHasMailInvoiceListServiceImpl
implements PlatfUseFeeHasMailInvoiceListService {
    private static final Logger logger = LoggerFactory.getLogger(PlatfUseFeeHasMailInvoiceListServiceImpl.class);
    @Autowired
    private SaleInvoiceMailInfoMapper invoiceMailInfoMapper;
    @Autowired
    private EnumsService enumsService;

    public PlatfUseFeeHasMailInvoiceListRspBO queryHasMailInvoice(PlatfUseFeeHasMailInvoiceListReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5e73\u53f0\u4f7f\u7528\u8d39\u5df2\u90ae\u5bc4\u53d1\u7968\u5217\u8868\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getCompanyId() == null) {
            throw new PfscExtBusinessException("0001", "\u4e13\u4e1a\u516c\u53f8Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        PlatfUseFeeHasMailInvoiceListRspBO rspPageBO = new PlatfUseFeeHasMailInvoiceListRspBO();
        String orderBy = " a.INVOICE_NO asc";
        if (reqBO.getPageSize() <= 0) {
            reqBO.setPageSize(Integer.valueOf(99999));
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<InvoiceForMailVO> platfUseFeeInvoiceList = this.invoiceMailInfoMapper.getPlatfUseFeeHasMailInvoice(reqBO, InvoiceMailSentStatusCustom.DONE.getCode(), (Page<Map<String, Object>>)page, orderBy);
        for (InvoiceForMailVO invoiceForMailVO : platfUseFeeInvoiceList) {
            invoiceForMailVO.setJdAssignStatusDescr(this.enumsService.getDescr(JDAssignStatus.getInstance(invoiceForMailVO.getJdAssignStatus())));
            invoiceForMailVO.setMailStatusDescr(this.enumsService.getDescr(InvoiceMailSentStatus.getInstance(invoiceForMailVO.getMailStatus())));
            invoiceForMailVO.setDetailAddress(invoiceForMailVO.getAddress());
        }
        rspPageBO.setRows(platfUseFeeInvoiceList);
        rspPageBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspPageBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspPageBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspPageBO;
    }
}

