/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.RegisterReturnQryDetailBusiService;
import com.tydic.pfsc.api.busi.bo.PayInvoiceInfoBO;
import com.tydic.pfsc.api.busi.bo.RegisterReturnQryDetailBusiReqBO;
import com.tydic.pfsc.api.busi.bo.RegisterReturnQryDetailBusiRspBO;
import com.tydic.pfsc.api.busi.vo.BillNotificationInfoVO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.RegisterReturnDetailMapper;
import com.tydic.pfsc.dao.RegisterReturnMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.po.RegisterReturnDetailPO;
import com.tydic.pfsc.dao.po.RegisterReturnPO;
import com.tydic.pfsc.enums.ReturnType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.RegisterReturnQryDetailBusiService"})
public class RegisterReturnQryDetailBusiServiceImpl
implements RegisterReturnQryDetailBusiService {
    private static final Logger log = LoggerFactory.getLogger(RegisterReturnQryDetailBusiServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private RegisterReturnMapper registerReturnMapper;
    @Autowired
    private RegisterReturnDetailMapper registerReturnDetailMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    @PostMapping(value={"qryInvoiceReturnDetail"})
    public RegisterReturnQryDetailBusiRspBO qryInvoiceReturnDetail(@RequestBody RegisterReturnQryDetailBusiReqBO reqBO) {
        RegisterReturnQryDetailBusiRspBO rspBO = new RegisterReturnQryDetailBusiRspBO();
        if (null == reqBO) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u9000\u7968\u767b\u8bb0\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getBillNo()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u9000\u7968\u767b\u8bb0\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u9000\u7968\u767b\u8bb0\u5355\u53f7[billNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String billNo = reqBO.getBillNo();
        RegisterReturnPO registerReturnPO = this.registerReturnMapper.selectByPrimaryKey(billNo);
        if (registerReturnPO == null) {
            throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u767b\u8bb0\u5355\u3010\u9000\u7968\u767b\u8bb0\u5355\u53f7=" + billNo + "\u3011");
        }
        BeanUtils.copyProperties((Object)registerReturnPO, (Object)rspBO);
        rspBO.setReturnTypeStr(this.enumsService.getDescr(ReturnType.getInstance(registerReturnPO.getReturnType())));
        String supplierName = this.organizationInfoService.querySupplierName(registerReturnPO.getSupplierNo());
        rspBO.setSupplierName(supplierName);
        List<RegisterReturnDetailPO> registerReturnDetailList = this.registerReturnDetailMapper.selectByPrimaryKey(billNo);
        if (registerReturnDetailList == null) {
            throw new PfscExtBusinessException("18001", "\u672a\u67e5\u8be2\u5230\u9000\u7968\u767b\u8bb0\u5355\u660e\u7ec6\u3010\u9000\u7968\u767b\u8bb0\u5355\u53f7=" + billNo + "\u3011");
        }
        BillNotificationInfoVO oldBillNotificationInfo = new BillNotificationInfoVO();
        ArrayList<BillNotificationInfoVO> redBillNotificationInfos = new ArrayList<BillNotificationInfoVO>();
        BigDecimal amt = BigDecimal.ZERO;
        if (registerReturnDetailList.size() > 0) {
            BillNotificationInfo billNotificationInfo;
            List<BillNotificationInfo> list;
            LinkedList<String> invoiceNos = new LinkedList<String>();
            LinkedList<String> redNotifyNos = new LinkedList<String>();
            for (RegisterReturnDetailPO registerReturnDetailPO : registerReturnDetailList) {
                invoiceNos.add(registerReturnDetailPO.getInvoiceNo1());
                if (registerReturnDetailPO.getNotifyNo2() == null) continue;
                redNotifyNos.add(registerReturnDetailPO.getNotifyNo2());
            }
            List<PayInvoiceInfo> payInvoiceInfoList = this.payInvoiceInfoMapper.selectByBatchInvoiceNo(invoiceNos);
            if (payInvoiceInfoList != null && payInvoiceInfoList.size() > 0) {
                for (PayInvoiceInfo payInvoiceInfo : payInvoiceInfoList) {
                    amt = amt.add(payInvoiceInfo.getAmt());
                }
            }
            if ((list = this.billNotificationInfoMapper.selectBatchNotifyNo(redNotifyNos)) != null && list.size() > 0) {
                for (BillNotificationInfo billNotificationInfo2 : list) {
                    BillNotificationInfoVO billNotificationInfoVO = new BillNotificationInfoVO();
                    billNotificationInfoVO.setNotificationNo(billNotificationInfo2.getNotificationNo());
                    billNotificationInfoVO.setAmt(billNotificationInfo2.getAmt());
                    billNotificationInfoVO.setApplyDate(billNotificationInfo2.getApplyDate());
                    redBillNotificationInfos.add(billNotificationInfoVO);
                }
                rspBO.setRedNotificationInfo(redBillNotificationInfos);
            }
            if ((billNotificationInfo = this.billNotificationInfoMapper.selectByPrimaryKey(registerReturnPO.getNotificationNo())) != null) {
                oldBillNotificationInfo.setApplyDate(billNotificationInfo.getApplyDate());
                oldBillNotificationInfo.setAmt(billNotificationInfo.getAmt());
                oldBillNotificationInfo.setNotificationNo(billNotificationInfo.getNotificationNo());
                rspBO.setOldNotificationInfo(oldBillNotificationInfo);
            }
        }
        rspBO.setAmt(amt);
        if (reqBO.getInvoiceNo() != null) {
            PayInvoiceInfoBO payInvoiceInfoBO = new PayInvoiceInfoBO();
            List<PayInvoiceInfo> invoiceInfos = this.payInvoiceInfoMapper.selectByInvoiceNo(reqBO.getInvoiceNo());
            if (invoiceInfos != null && invoiceInfos.size() > 0) {
                BeanUtils.copyProperties((Object)invoiceInfos.get(0), (Object)payInvoiceInfoBO);
                rspBO.setOldInvoiceInfo(payInvoiceInfoBO);
            }
        }
        return rspBO;
    }
}

