/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.mock.impl;

import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.enums.SaleItemApplyInfoStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.mock.FscMockBackInvoiceService;
import com.tydic.pfsc.mock.bo.FscMockBackInvoiceBO;
import com.tydic.pfsc.mock.bo.FscMockBackInvoiceDetailBO;
import com.tydic.pfsc.utils.FscStringUtils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.mock.FscMockBackInvoiceService"})
public class FscMockBackInvoiceServiceImpl
implements FscMockBackInvoiceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscMockBackInvoiceServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;

    @PostMapping(value={"mockBackData"})
    public FscMockBackInvoiceBO mockBackData(@RequestBody String billNo) {
        FscMockBackInvoiceBO reqBO = new FscMockBackInvoiceBO();
        ArrayList<FscMockBackInvoiceDetailBO> detail = new ArrayList<FscMockBackInvoiceDetailBO>();
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(billNo);
        if (billApplyInfo == null) {
            LOGGER.error("\u67e5\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + billNo + "]");
            throw new PfscExtBusinessException("18001", "\u67e5\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + billNo + "]");
        }
        if (!BillStatus.APPLIED.getCode().equals(billApplyInfo.getBillStatus())) {
            LOGGER.error("\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + billNo + "]\u7684\u72b6\u6001\u4e0d\u6b63\u786e");
            throw new PfscExtBusinessException("18003", "\u5f00\u7968\u7533\u8bf7\u8bb0\u5f55[\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + billNo + "]\u7684\u72b6\u6001\u4e0d\u6b63\u786e");
        }
        SaleItemInfoVO saleItemInfoVO = new SaleItemInfoVO();
        saleItemInfoVO.setApplyNo(billNo);
        saleItemInfoVO.setSaleItemApplyInfoStatus(SaleItemApplyInfoStatus.VALID.getCode());
        saleItemInfoVO.setItemStatus(OrderStatus.APPLIED.getCode());
        List<SaleItemInfo> saleItemInfoList = null;
        if (OrderSource.ELECTRIC_MARKET.getCode().equals(billApplyInfo.getSource())) {
            saleItemInfoList = this.saleItemInfoMapper.getListJoinSaleItemApplyInfo(saleItemInfoVO);
        } else if (OrderSource.ELECTRIC_AREA.getCode().equals(billApplyInfo.getSource())) {
            saleItemInfoList = this.saleItemInfoMapper.getList(saleItemInfoVO);
        }
        BigDecimal invoiceAmount = BigDecimal.ZERO;
        BigDecimal invoiceTax = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty(saleItemInfoList)) {
            for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                FscMockBackInvoiceDetailBO mockBackInvoiceDetailBO = new FscMockBackInvoiceDetailBO();
                mockBackInvoiceDetailBO.setOrder_no(saleItemInfo.getInspectionId() == null ? "" : String.valueOf(saleItemInfo.getInspectionId()));
                mockBackInvoiceDetailBO.setLines_number(saleItemInfo.getItemNo());
                mockBackInvoiceDetailBO.setMateriel_unit(saleItemInfo.getUnitName());
                mockBackInvoiceDetailBO.setQuantity(saleItemInfo.getQuantity());
                if (saleItemInfo.getTaxCatCode() != null && saleItemInfo.getTaxCatCode() > 0L) {
                    mockBackInvoiceDetailBO.setTax_class_code(saleItemInfo.getTaxCatCode().toString());
                } else {
                    mockBackInvoiceDetailBO.setTax_class_code("123456");
                }
                BigDecimal taxRate = saleItemInfo.getTaxRate() == null ? new BigDecimal("0.13") : saleItemInfo.getTaxRate();
                BigDecimal tax = saleItemInfo.getAmount().divide(BigDecimal.ONE.add(taxRate), 4, 4).multiply(taxRate).setScale(2, 4);
                invoiceTax = invoiceTax.add(tax);
                BigDecimal amount = saleItemInfo.getAmount().subtract(tax).setScale(2, 4);
                invoiceAmount = invoiceAmount.add(amount);
                mockBackInvoiceDetailBO.setAmount(amount);
                mockBackInvoiceDetailBO.setTax(tax);
                mockBackInvoiceDetailBO.setTax_rate(saleItemInfo.getTaxRate());
                String materiel_name = saleItemInfo.getSkuName() == null ? "" : saleItemInfo.getSkuName().replaceAll("\n", " ");
                materiel_name = FscStringUtils.cutStringByByte(materiel_name, "GBK", 35);
                mockBackInvoiceDetailBO.setMateriel_name(materiel_name);
                String materiel_standard = saleItemInfo.getSpec() == null ? "" : (saleItemInfo.getSpec() + saleItemInfo.getModel() == null ? "" : (saleItemInfo.getModel() + saleItemInfo.getFigureNo() == null ? "" : saleItemInfo.getFigureNo()));
                materiel_standard = FscStringUtils.cutStringByByte(materiel_standard, "GBK", 30);
                mockBackInvoiceDetailBO.setMateriel_standard(StringUtils.hasText((String)materiel_standard) ? materiel_standard : "\u65e0");
                detail.add(mockBackInvoiceDetailBO);
            }
        }
        reqBO.setBill_no(billNo);
        reqBO.setDetail(detail);
        reqBO.setInvoice_amount(invoiceAmount.toPlainString());
        reqBO.setInvoice_tax(invoiceTax.toPlainString());
        reqBO.setInvoice_state(Integer.valueOf(SaleInvoiceInfoInvoiceStatus.SEND_BILL.getCode()));
        reqBO.setInvoice_date(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        reqBO.setInvoice_code(String.valueOf(System.currentTimeMillis()));
        reqBO.setInvoice_num(String.valueOf(System.currentTimeMillis()));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u6a21\u62df\u540e\u7684\u7a0e\u63a7\u56de\u4f20\u5f00\u7968\u4fe1\u606f\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        return reqBO;
    }
}

