/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.mock.impl;

import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.vo.Statis;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.mock.FscMockGetInvoiceService;
import com.tydic.pfsc.mock.bo.FscMockGetInvoiceBO;
import java.util.Date;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.mock.FscMockGetInvoiceService"})
public class FscMockGetInvoiceServiceImpl
implements FscMockGetInvoiceService {
    @Autowired
    BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    PayItemInfoMapper payItemInfoMapper;

    @PostMapping(value={"getInvoiceData"})
    public FscMockGetInvoiceBO getInvoiceData(@RequestBody String markId) {
        FscMockGetInvoiceBO getInvoiceBO = new FscMockGetInvoiceBO();
        if (!StringUtils.hasText((String)markId)) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355\u53f7markId\u5fc5\u987b\u8f93\u5165");
        }
        BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryKey(markId);
        if (bill == null) {
            throw new PfscExtBusinessException("0001", "\u901a\u77e5\u5355\u53f7\u4e0d\u5b58\u5728");
        }
        Statis ordStatis = this.payItemInfoMapper.orderStatis(markId);
        getInvoiceBO.setInvoiceNo(String.valueOf(new Random().nextDouble()).substring(2, 10));
        getInvoiceBO.setInvoiceId(String.valueOf(new Random().nextDouble()).substring(2, 10));
        getInvoiceBO.setInvoiceCode(String.valueOf(new Random().nextDouble()).substring(2, 12));
        getInvoiceBO.setInvoiceDate(DateUtils.dateToStrLong((Date)new Date()));
        getInvoiceBO.setInvoiceAmount(String.valueOf(ordStatis.getTotAmt()));
        getInvoiceBO.setInvoiceNakedAmount(String.valueOf(ordStatis.getTotUntaxAmt()));
        getInvoiceBO.setInvoiceTaxAmount(String.valueOf(ordStatis.getTotTaxAmt()));
        getInvoiceBO.setTitle(bill.getInvoceName());
        getInvoiceBO.setEnterpriseTaxpayer(bill.getTaxNo());
        getInvoiceBO.setAddress(bill.getAddr());
        getInvoiceBO.setTel(bill.getPhone());
        getInvoiceBO.setBank(bill.getBankName());
        getInvoiceBO.setAccount(bill.getBankAccNo());
        getInvoiceBO.setInvoiceType(String.valueOf(bill.getInvoceType()));
        return getInvoiceBO;
    }
}

