/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.OrderSequence;
import com.tydic.pfsc.api.busi.BusiAddRecAmtConfirmService;
import com.tydic.pfsc.api.busi.bo.BusiAddRecAmtConfirmReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.AdvanceReceiveMapper;
import com.tydic.pfsc.dao.RecAmtConfirmMapper;
import com.tydic.pfsc.dao.RecvAmtDetailMapper;
import com.tydic.pfsc.dao.SubAcctInfoMapper;
import com.tydic.pfsc.dao.po.AdvanceReceive;
import com.tydic.pfsc.dao.po.RecAmtConfirm;
import com.tydic.pfsc.dao.po.RecvAmtDetail;
import com.tydic.pfsc.dao.po.SubAcctInfo;
import com.tydic.pfsc.dao.vo.AdvanceReceiveVO;
import com.tydic.pfsc.dao.vo.RecvAmtDetailVO;
import com.tydic.pfsc.enums.AdvanceReceiveStatus;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.RecAmtConfirmStatus;
import com.tydic.pfsc.enums.ReceiptStatus;
import com.tydic.pfsc.enums.SubAccountServiceType;
import com.tydic.pfsc.enums.WFBillType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.FscWfStartAtomService;
import com.tydic.pfsc.service.atom.bo.FscWfStartAtomReqBO;
import com.tydic.pfsc.service.atom.bo.FscWfStartAtomRspBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiAddRecAmtConfirmService"})
public class BusiAddRecAmtConfirmServiceImpl
implements BusiAddRecAmtConfirmService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddRecAmtConfirmServiceImpl.class);
    @Autowired
    @Qualifier(value="recAmtConfirmReq")
    private OrderSequence recAmtConfirmReq;
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;
    @Autowired
    private RecAmtConfirmMapper recAmtConfirmMapper;
    @Autowired
    private FscWfStartAtomService fscWfStartAtomService;
    @Autowired
    private RecvAmtDetailMapper recvAmtDetailMapper;
    @Autowired
    private SubAcctInfoMapper subAcctInfoMapper;

    @PostMapping(value={"addRecAmtConfirm"})
    public PfscExtRspBaseBO addRecAmtConfirm(@RequestBody BusiAddRecAmtConfirmReqBO reqBO) {
        List seqList;
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u6536\u6b3e\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(seqList = reqBO.getSeqList()))) {
            throw new PfscExtBusinessException("0001", "\u60a8\u6ca1\u6709\u52fe\u9009\u6536\u6b3e\u4fe1\u606f");
        }
        AdvanceReceiveVO adReVo = new AdvanceReceiveVO();
        adReVo.setSeqList(seqList);
        adReVo.setServiceTypeNotIn(Collections.singletonList(SubAccountServiceType.DEFAULT.getCode()));
        int valCount = this.advanceReceiveMapper.selectCountBySeqList(adReVo);
        if (valCount > 0) {
            throw new PfscExtBusinessException("18000", "\u91c7\u8d2d\u5355\u4f4d\u8d26\u6237\u7684\u94f6\u884c\u6d41\u6c34\u53ef\u4ee5\u529e\u7406\u6b64\u4e1a\u52a1\uff0c\u8fd0\u8425\u5355\u4f4d\u8d26\u6237\u4e0d\u53ef\u4ee5");
        }
        RecAmtConfirm recAmtConfirm = new RecAmtConfirm();
        long seqId = 0L;
        try {
            seqId = this.recAmtConfirmReq.nextId();
        }
        catch (SQLException e) {
            throw new PfscExtBusinessException("18000", "\u4ea7\u751f\u5e8f\u5217\u53f7\u5931\u8d25");
        }
        Long docNum = this.generateSeqNoFormated(18, new SimpleDateFormat("yyyyMMdd").format(new Date()), seqId);
        recAmtConfirm.setDocNum(docNum);
        recAmtConfirm.setCreateDate(new Date());
        AdvanceReceive advanceReceive = this.advanceReceiveMapper.selectByPrimaryKey((Long)seqList.get(0));
        if (null == advanceReceive) {
            throw new PfscExtBusinessException("18000", "\u672a\u67e5\u8be2\u5230\u6536\u6b3e\u5355\u4fe1\u606f\uff0c\u5e8f\u53f7seq=[" + seqList.get(0) + "]");
        }
        recAmtConfirm.setOrgId(advanceReceive.getRecOrgId());
        recAmtConfirm.setSource(advanceReceive.getSource());
        recAmtConfirm.setLoginId(reqBO.getUserId());
        recAmtConfirm.setRemark(reqBO.getRemark());
        recAmtConfirm.setStatus(RecAmtConfirmStatus.VALID.getCode());
        recAmtConfirm.setReceiptStatus(ReceiptStatus.NO_RECEIPT.getCode());
        BigDecimal sumAmt = null;
        Integer sumCount = null;
        String source = advanceReceive.getSource();
        if (OrderSource.ELECTRIC_AREA.getCode().equals(source) || OrderSource.COAL_AREA.getCode().equals(source)) {
            AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
            advanceReceiveVO.setSeqList(seqList);
            advanceReceiveVO.setStatus(AdvanceReceiveStatus.NO_CONFIRM.getCode());
            List<AdvanceReceive> advanceReceiveList = this.advanceReceiveMapper.selectByCondition(advanceReceiveVO);
            ArrayList<RecvAmtDetail> recvDetailList = new ArrayList<RecvAmtDetail>();
            for (AdvanceReceive advanceReceiveInfo : advanceReceiveList) {
                SubAcctInfo subAcctInfo = this.subAcctInfoMapper.selectByPrimaryKey(advanceReceiveInfo.getRecSubAcct());
                AdvanceReceive record = new AdvanceReceive();
                record.setSeq(advanceReceiveInfo.getSeq());
                record.setStatus(AdvanceReceiveStatus.CONFIRM.getCode());
                record.setWriteoffAmt(advanceReceiveInfo.getTranAmt());
                int update = this.advanceReceiveMapper.updateByPrimaryKeySelective(record);
                if (update < 1) {
                    throw new PfscExtBusinessException("18994", "\u751f\u6210\u6536\u6b3e\u5355\u670d\u52a1\u5931\u8d25\uff0c\u6570\u636e\u5e93\u5f02\u5e38");
                }
                RecvAmtDetail recvDetail = new RecvAmtDetail();
                recvDetail.setAdvRecvSeq(advanceReceiveInfo.getSeq());
                recvDetail.setAmount(advanceReceiveInfo.getTranAmt().subtract(advanceReceiveInfo.getWriteoffAmt()));
                recvDetail.setOperUnitNo(advanceReceive.getRecOrgId());
                recvDetail.setPurchaseNo(subAcctInfo.getOrgId());
                recvDetail.setPurchaseProjectId(subAcctInfo.getProjectId());
                recvDetail.setDocNum(docNum);
                recvDetail.setLoginId(reqBO.getUserId());
                recvDetail.setCreateDate(new Date());
                recvDetailList.add(recvDetail);
            }
            this.recvAmtDetailMapper.insertByBatch(recvDetailList);
            RecvAmtDetailVO recvAmtDetailVO = new RecvAmtDetailVO();
            recvAmtDetailVO.setDocNum(docNum);
            recvAmtDetailVO = this.recvAmtDetailMapper.selectSum2(recvAmtDetailVO);
            sumAmt = recvAmtDetailVO.getAmount();
            sumCount = recvAmtDetailVO.getCount();
        } else if (OrderSource.ELECTRIC_MARKET.getCode().equals(source)) {
            AdvanceReceiveVO vo = new AdvanceReceiveVO();
            vo.setSeqList(seqList);
            vo.setStatusEqual(AdvanceReceiveStatus.NO_CONFIRM.getCode());
            vo.setDocNum(docNum);
            vo.setStatus(AdvanceReceiveStatus.CONFIRM.getCode());
            int confirm = this.advanceReceiveMapper.confirm(vo);
            if (confirm < 1) {
                throw new PfscExtBusinessException("18994", "\u751f\u6210\u6536\u6b3e\u5355\u670d\u52a1\u5931\u8d25\uff0c\u6570\u636e\u5e93\u5f02\u5e38");
            }
            AdvanceReceiveVO advanceReceiveVO = new AdvanceReceiveVO();
            advanceReceiveVO.setDocNum(docNum);
            advanceReceiveVO = this.advanceReceiveMapper.selectSum(advanceReceiveVO);
            sumAmt = advanceReceiveVO.getTranAmt();
            sumCount = advanceReceiveVO.getCount();
        }
        recAmtConfirm.setSumAmt(sumAmt);
        recAmtConfirm.setSumCount(sumCount);
        int insert = this.recAmtConfirmMapper.insert(recAmtConfirm);
        if (insert < 1) {
            throw new PfscExtBusinessException("18994", "\u751f\u6210\u6536\u6b3e\u5355\u670d\u52a1\u5931\u8d25\uff0c\u6570\u636e\u5e93\u5f02\u5e38");
        }
        FscWfStartAtomReqBO req = new FscWfStartAtomReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)((Object)req));
        req.setBillNo(String.valueOf(docNum));
        req.setBillType(WFBillType.COLLECTION_CONFIRMATION);
        req.setFinishEvtServiceId("recAmtConfirmWorkFlowFinshEventImpl");
        FscWfStartAtomRspBO wfStartAtomRspBO = this.fscWfStartAtomService.dealStartApproval(req);
        if (!"0000".equals(wfStartAtomRspBO.getRespCode())) {
            throw new PfscExtBusinessException("18994", "\u751f\u6210\u6536\u6b3e\u5355\u670d\u52a1\u5931\u8d25\uff0c\u53d1\u8d77\u5ba1\u6279\u5f02\u5e38");
        }
        return new PfscExtRspBaseBO();
    }

    private Long generateSeqNoFormated(int length, String prefix, long seqId) {
        prefix = StringUtils.hasText((String)prefix) ? prefix : "";
        int lengthWithoutPrefix = length - prefix.length();
        String withoutPrefix = String.format("%0" + lengthWithoutPrefix + "d", seqId);
        return Long.parseLong(prefix + withoutPrefix);
    }
}

