/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiApplyBillApplyInfoService;
import com.tydic.pfsc.api.busi.bo.BusiApplyBillApplyInfoReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.vo.BillApplyInfoVO;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiApplyBillApplyInfoService"})
public class BusiApplyBillApplyInfoServiceImpl
implements BusiApplyBillApplyInfoService {
    private static final Logger logger = LoggerFactory.getLogger(BusiApplyBillApplyInfoServiceImpl.class);
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;

    @PostMapping(value={"update"})
    public PfscExtRspBaseBO update(@RequestBody BusiApplyBillApplyInfoReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u53d1\u8d77\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u5b50\u8d85\u5e02)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List applyNoList = reqBO.getApplyNoList();
        if (applyNoList == null || applyNoList.isEmpty()) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNoList\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfoVO billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        ArrayList<String> billStatusNotIn = new ArrayList<String>();
        billStatusNotIn.add(BillStatus.NO_APPLY.getCode());
        billApplyInfoVO.setBillStatusNotIn(billStatusNotIn);
        int count = this.billApplyInfoMapper.selectCount(billApplyInfoVO);
        if (count > 0) {
            throw new PfscExtBusinessException("18000", "\u5f00\u7968\u7533\u8bf7\u5355\u7684\u5f00\u7968\u72b6\u6001\u5fc5\u987b\u662f\u5df2\u7533\u8bf7\uff01");
        }
        List<BillApplyInfo> applys = this.billApplyInfoMapper.getList(billApplyInfoVO);
        for (BillApplyInfo apply : applys) {
            if (reqBO.getCompanyId().equals(apply.getOperUnitNo())) continue;
            throw new PfscExtBusinessException("18000", "\u4e0d\u80fd\u529e\u7406\u5176\u4ed6\u516c\u53f8\u7684\u4e1a\u52a1");
        }
        billApplyInfoVO = new BillApplyInfoVO();
        billApplyInfoVO.setApplyNoList(applyNoList);
        billApplyInfoVO.setBillStatus(BillStatus.NO_APPLY.getCode());
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setBillStatus(BillStatus.APPLIED.getCode());
        try {
            this.billApplyInfoMapper.updateByCondition(billApplyInfoVO, billApplyInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            throw new PfscExtBusinessException("18000", "\u5931\u8d25");
        }
        return new PfscExtRspBaseBO();
    }
}

