/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiCheckSignService;
import com.tydic.pfsc.api.busi.bo.BusiCheckSignServiceReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.enums.NotificationInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiCheckSignService"})
public class BusiCheckSignServiceImpl
implements BusiCheckSignService {
    private static final Logger logger = LoggerFactory.getLogger(BusiCheckSignServiceImpl.class);
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;

    @PostMapping(value={"query"})
    public PfscExtRspBaseBO query(@RequestBody BusiCheckSignServiceReqBO reqBO) {
        List notificationNos;
        if (logger.isDebugEnabled()) {
            logger.debug("\u5f00\u7968\u901a\u77e5\u5355\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u6821\u9a8c\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (CollectionUtils.isEmpty((Collection)(notificationNos = reqBO.getNotificationNos()))) {
            throw new PfscExtBusinessException("0001", "\u8bf7\u52fe\u9009");
        }
        for (String notificationNo : notificationNos) {
            BillNotificationInfo bill = this.billNotificationInfoMapper.selectByPrimaryKey(notificationNo);
            if (null == bill) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u4e0d\u5b58\u5728");
            }
            NotificationInvoiceStatus nowSta = NotificationInvoiceStatus.getInstance(bill.getInvoiceStatus());
            if (null == nowSta) {
                throw new PfscExtBusinessException("0001", "\u5f00\u7968\u901a\u77e5\u5355" + notificationNo + "\u65e0\u6548\u7684\u53d1\u7968\u72b6\u6001\u503c");
            }
            if (NotificationInvoiceStatus.HAS_MAKE == nowSta) continue;
            throw new PfscExtBusinessException("0001", "\u53ea\u6709\u5df2\u5f00\u7968\u72b6\u6001\u7684\u5f00\u7968\u901a\u77e5\u5355\u624d\u53ef\u8fdb\u884c\u6838\u5bf9\u7b7e\u6536\u64cd\u4f5c");
        }
        PfscExtRspBaseBO rspBo = new PfscExtRspBaseBO();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6279\u91cf\u6838\u5bf9\u7b7e\u6536\u6821\u9a8c\u6210\u529f");
        return rspBo;
    }
}

