/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiInvoiceIssueAtourService;
import com.tydic.pfsc.api.busi.bo.BusiInvoiceIssueAtourReqBO;
import com.tydic.pfsc.api.busi.bo.BusiInvoiceIssueAtourRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoApplyRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoItemRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoOrderRspBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryDetailBillApplyInfoReqBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.SaleItemInfo;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.dao.vo.SaleItemInfoVO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.external.atour.api.BillInfoUploadExternalService;
import com.tydic.pfsc.external.atour.api.bo.BillInfoUploadExtReqBO;
import com.tydic.pfsc.external.atour.api.bo.BillInfoUploadExtRspBO;
import com.tydic.pfsc.external.atour.api.bo.MessageBO;
import com.tydic.pfsc.external.atour.api.bo.SalesBillDetailsBO;
import com.tydic.pfsc.external.atour.api.bo.SalesBillMainBO;
import com.tydic.pfsc.service.atom.EnumsService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiInvoiceIssueAtourService"})
public class BusiInvoiceIssueAtourServiceImpl
implements BusiInvoiceIssueAtourService {
    private static final Logger log = LoggerFactory.getLogger(BusiInvoiceIssueAtourServiceImpl.class);
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillInfoUploadExternalService billInfoUploadExternalService;

    @PostMapping(value={"invoiceIssue"})
    public BusiInvoiceIssueAtourRspBO invoiceIssue(@RequestBody BusiInvoiceIssueAtourReqBO busiInvoiceIssueAtourReqBO) {
        BusiInvoiceIssueAtourRspBO rspBO = new BusiInvoiceIssueAtourRspBO();
        if (busiInvoiceIssueAtourReqBO.getRejectionContent() != null && busiInvoiceIssueAtourReqBO.getRejectionContent() != "") {
            return rspBO;
        }
        String applyNo = busiInvoiceIssueAtourReqBO.getApplyNo();
        Integer applyStatus = busiInvoiceIssueAtourReqBO.getApplyStatus();
        BusiQueryDetailBillApplyInfoReqBO reqBO = new BusiQueryDetailBillApplyInfoReqBO();
        reqBO.setApplyNo(applyNo);
        BusiQueryDetailBillApplyInfoApplyRspBO applyRspBO = this.queryApply(reqBO);
        BillInfoUploadExtReqBO uploadExtReqBO = new BillInfoUploadExtReqBO();
        uploadExtReqBO.setBusinessBillType("AR");
        uploadExtReqBO.setSystemOrig("spaceup");
        uploadExtReqBO.setStatus(applyStatus);
        MessageBO message = new MessageBO();
        ArrayList<SalesBillMainBO> salesBillMain = new ArrayList<SalesBillMainBO>();
        SalesBillMainBO billMainBO = new SalesBillMainBO();
        billMainBO.setSalesbillNo(applyNo);
        billMainBO.setSalesbillType("AR\u5355");
        billMainBO.setSellerNo(applyRspBO.getTaxNo());
        billMainBO.setPurchaserName(applyRspBO.getInvoceName());
        billMainBO.setPurchaserTaxNo(applyRspBO.getTaxNo());
        billMainBO.setPriceMethod(Integer.valueOf(1));
        if ("1".equals(applyRspBO.getInvoiceType())) {
            billMainBO.setInvoiceType("c");
        } else {
            billMainBO.setInvoiceType("s");
        }
        billMainBO.setAmountWithTax(applyRspBO.getAmt());
        BigDecimal taxAmt = applyRspBO.getAmt().divide(BigDecimal.ONE.add(new BigDecimal("0.06")), 5, 4).multiply(new BigDecimal("0.06")).setScale(2, 4);
        billMainBO.setTaxAmount(taxAmt);
        billMainBO.setAmountWithoutTax(applyRspBO.getAmt().subtract(taxAmt));
        if (busiInvoiceIssueAtourReqBO.getApplyStatus() == 2) {
            uploadExtReqBO.setStatus(Integer.valueOf(1));
            billMainBO.setOriginInvoiceNo("");
            billMainBO.setOriginInvoiceCode("");
            billMainBO.setRedNotification("");
        }
        salesBillMain.add(billMainBO);
        ArrayList<SalesBillDetailsBO> salesBillDetails = new ArrayList<SalesBillDetailsBO>();
        if (applyRspBO.getRows() != null && applyRspBO.getRows().size() > 0) {
            for (BusiQueryDetailBillApplyInfoOrderRspBO infoOrderRspBO : applyRspBO.getRows()) {
                if (infoOrderRspBO.getItemList() == null || infoOrderRspBO.getItemList().size() <= 0) continue;
                for (BusiQueryDetailBillApplyInfoItemRspBO infoItemRspBO : infoOrderRspBO.getItemList()) {
                    SalesBillDetailsBO billDetailsBO = new SalesBillDetailsBO();
                    billDetailsBO.setSalesbillItemNo(infoItemRspBO.getItemNo().toString());
                    billDetailsBO.setItemName(infoItemRspBO.getSkuName());
                    billDetailsBO.setItemSpec(infoItemRspBO.getSpec() + infoItemRspBO.getModel());
                    billDetailsBO.setQuantityUnit(infoItemRspBO.getUnitName());
                    billDetailsBO.setQuantity(infoItemRspBO.getQuantity());
                    if (infoItemRspBO.getTaxCatCode() != null) {
                        billDetailsBO.setGoodsTaxNo(infoItemRspBO.getTaxCatCode().toString());
                    } else {
                        billDetailsBO.setGoodsTaxNo("1010101030000000000");
                    }
                    billDetailsBO.setAmountWithoutTax(infoItemRspBO.getUntaxAmt());
                    billDetailsBO.setAmountWithTax(infoItemRspBO.getAmount());
                    billDetailsBO.setTaxAmount(infoItemRspBO.getTaxAmt());
                    billDetailsBO.setTaxRate(infoItemRspBO.getTaxRate());
                    billDetailsBO.setUnitPriceWithTax(infoItemRspBO.getSaleUnitPrice());
                    billDetailsBO.setUnitPrice(infoItemRspBO.getSaleUnitPrice());
                    salesBillDetails.add(billDetailsBO);
                }
            }
        }
        uploadExtReqBO.setMessage(message);
        BillInfoUploadExtRspBO billInfoUploadExtRspBO = this.billInfoUploadExternalService.billInfoUpload(uploadExtReqBO);
        BillApplyInfo billApply = new BillApplyInfo();
        billApply.setApplyNo(busiInvoiceIssueAtourReqBO.getApplyNo());
        billApply.setBillStatus("02");
        this.billApplyInfoMapper.updateByPrimaryKeySelective(billApply);
        this.saleOrderInfoMapper.updateStatusByApplyNo(applyNo, "01");
        return rspBO;
    }

    public BusiQueryDetailBillApplyInfoApplyRspBO queryApply(BusiQueryDetailBillApplyInfoReqBO reqBO) {
        if (reqBO == null) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String applyNo = reqBO.getApplyNo();
        if (!StringUtils.hasText((String)applyNo)) {
            throw new PfscExtBusinessException("18000", "\u5165\u53c2\u5f00\u7968\u7533\u8bf7\u5355\u53f7\u3010applyNo\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo);
        if (billApplyInfo == null) {
            throw new PfscExtBusinessException("18000", "\u627e\u4e0d\u5230\u5f00\u7968\u7533\u8bf7\u5355\u3010\u5f00\u7968\u7533\u8bf7\u5355\u53f7=" + applyNo + "\u3011");
        }
        SaleOrderInfoVO saleOrderInfoVO = new SaleOrderInfoVO();
        saleOrderInfoVO.setApplyNo(applyNo);
        saleOrderInfoVO.setSource(billApplyInfo.getSource());
        saleOrderInfoVO.setOrderBy(" tt.inspectionId DESC");
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<SaleOrderInfo> saleOrderInfoList = this.saleOrderInfoMapper.getListPageByApplyNo(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO> orderList = new ArrayList<BusiQueryDetailBillApplyInfoOrderRspBO>();
        if (saleOrderInfoList != null) {
            for (SaleOrderInfo saleOrderInfo : saleOrderInfoList) {
                SaleItemInfoVO condition = new SaleItemInfoVO();
                condition.setInspectionId(saleOrderInfo.getInspectionId());
                condition.setApplyNo(billApplyInfo.getApplyNo());
                List<SaleItemInfo> saleItemInfoList = this.saleItemInfoMapper.getListContainsItemApplyInfo(condition);
                ArrayList<Long> skuIds = new ArrayList<Long>();
                for (SaleItemInfo saleItemInfo : saleItemInfoList) {
                    skuIds.add(saleItemInfo.getSkuId());
                }
                ArrayList<BusiQueryDetailBillApplyInfoItemRspBO> itemList = new ArrayList<BusiQueryDetailBillApplyInfoItemRspBO>();
                for (SaleItemInfo saleItemInfo3 : saleItemInfoList) {
                    BusiQueryDetailBillApplyInfoItemRspBO item = new BusiQueryDetailBillApplyInfoItemRspBO();
                    BeanUtils.copyProperties((Object)saleItemInfo3, (Object)item);
                    if (ApplyType.APPLY_TYPE_ITEM.getCode().equals(billApplyInfo.getApplyType())) {
                        item.setAmountApply(saleItemInfo3.getAmountApplied());
                        item.setQuantityApply(saleItemInfo3.getQuantityApplied());
                    } else {
                        item.setAmountApply(saleItemInfo3.getAmount());
                        item.setQuantityApply(saleItemInfo3.getQuantity());
                    }
                    itemList.add(item);
                }
                BusiQueryDetailBillApplyInfoOrderRspBO busiQueryDetailBillApplyInfoOrderRspBO = new BusiQueryDetailBillApplyInfoOrderRspBO();
                BeanUtils.copyProperties((Object)saleOrderInfo, (Object)busiQueryDetailBillApplyInfoOrderRspBO);
                busiQueryDetailBillApplyInfoOrderRspBO.setOrderId(String.valueOf(saleOrderInfo.getOrderId()));
                busiQueryDetailBillApplyInfoOrderRspBO.setOrderStatusDescr(this.enumsService.getDescr(OrderStatus.getInstance(saleOrderInfo.getOrderStatus())));
                busiQueryDetailBillApplyInfoOrderRspBO.setItemList(itemList);
                orderList.add(busiQueryDetailBillApplyInfoOrderRspBO);
            }
        }
        BusiQueryDetailBillApplyInfoApplyRspBO rspBO = new BusiQueryDetailBillApplyInfoApplyRspBO();
        BeanUtils.copyProperties((Object)billApplyInfo, (Object)rspBO);
        rspBO.setOrderCount(Integer.valueOf(page.getTotalCount()));
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

