/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQryNotificationDetailService;
import com.tydic.pfsc.api.busi.bo.BusiQryNotificationDetailReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQryNtfDetailPart1RspBO;
import com.tydic.pfsc.api.busi.bo.BusiQryNtfDetailPart2RspBO;
import com.tydic.pfsc.api.busi.bo.BusiQryNtfDetailRspBO;
import com.tydic.pfsc.api.busi.vo.InvoiceDetailVO;
import com.tydic.pfsc.api.busi.vo.InvoiceDetailWithItemListVO;
import com.tydic.pfsc.api.busi.vo.OrderInfoVO;
import com.tydic.pfsc.api.busi.vo.OrderItemVO;
import com.tydic.pfsc.dao.BillNotificationInfoMapper;
import com.tydic.pfsc.dao.PayInvoiceDetailMapper;
import com.tydic.pfsc.dao.PayInvoiceInfoMapper;
import com.tydic.pfsc.dao.PayItemInfoMapper;
import com.tydic.pfsc.dao.PayPurchaseOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillNotificationInfo;
import com.tydic.pfsc.dao.po.PayInvoiceDetail;
import com.tydic.pfsc.dao.po.PayInvoiceInfo;
import com.tydic.pfsc.dao.po.PayItemInfo;
import com.tydic.pfsc.dao.po.PayPurchaseOrderInfo;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.AntiSqlInjectionManage;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiQryNotificationDetailService"})
public class BusiQryNotificationDetailServiceImpl
implements BusiQryNotificationDetailService {
    private static final Logger logger = LoggerFactory.getLogger(BusiQryNotificationDetailServiceImpl.class);
    @Autowired
    private PayItemInfoMapper payItemInfoMapper;
    @Autowired
    private BillNotificationInfoMapper billNotificationInfoMapper;
    @Autowired
    private PayPurchaseOrderInfoMapper payPurchaseOrderInfoMapper;
    @Autowired
    private PayInvoiceInfoMapper payInvoiceInfoMapper;
    @Autowired
    private PayInvoiceDetailMapper payInvoiceDetailMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"qryNotifyDetailPart1"})
    public BusiQryNtfDetailPart1RspBO qryNotifyDetailPart1(@RequestBody BusiQryNotificationDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u7b2c\u4e00\u90e8\u5206\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillNotificationInfo notification = new BillNotificationInfo();
        try {
            notification = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5355\u5217\u8868-\u901a\u77e5\u5355\u53f7\u5165\u53c2\uff1a" + reqBO.getNotificationNo(), (Throwable)e);
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868-\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
        }
        if (null == notification) {
            logger.info("billNotificationInfoMapper.selectByPrimaryKey\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + reqBO.getNotificationNo() + "\u6ca1\u6709\u901a\u77e5\u5355\u8bb0\u5f55");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<Object> orderInfos = new LinkedList();
        try {
            orderInfos = this.payPurchaseOrderInfoMapper.getListPageByReq(reqBO, (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.info("payPurchaseOrderInfoMapper.getListPageByNotifNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo() + "," + reqBO.getExtOrderId() + "," + reqBO.getPurchaseOrderCode());
            throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff0c\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
        }
        if (orderInfos.isEmpty()) {
            logger.info("payPurchaseOrderInfoMapper.selectByNotifNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo() + "," + reqBO.getExtOrderId() + "," + reqBO.getPurchaseOrderCode());
        }
        BusiQryNtfDetailPart1RspBO rspBO = new BusiQryNtfDetailPart1RspBO();
        rspBO.setNotificationNo(notification.getNotificationNo());
        rspBO.setApplyDate(notification.getApplyDate());
        rspBO.setApplyAmt(notification.getAmt());
        rspBO.setOrderNum(Integer.valueOf(page.getTotalCount()));
        rspBO.setApplyBranch(notification.getOperNo());
        String orgNameStr = this.organizationInfoService.queryOrgName(rspBO.getApplyBranch());
        rspBO.setApplyBranchName(orgNameStr);
        rspBO.setInvoiceTitle(notification.getInvoceName());
        rspBO.setInvoiceType(notification.getInvoceType());
        InvoiceType invoiceTypeEnum = InvoiceType.getInstance(rspBO.getInvoiceType());
        rspBO.setInvoiceTypeStr(this.enumsService.getDescr(invoiceTypeEnum));
        rspBO.setTaxId(notification.getTaxNo());
        rspBO.setCompanyAddr(notification.getAddr());
        rspBO.setPhone(notification.getPhone());
        rspBO.setOpenBankName(notification.getBankName());
        rspBO.setBankAcctNo(notification.getBankAccNo());
        rspBO.setMailAddr(notification.getAddrDesc());
        if (!(StringUtils.isEmpty((CharSequence)notification.getAddrDesc()) || StringUtils.isEmpty((CharSequence)notification.getCity()) || notification.getAddrDesc().contains(notification.getCity()))) {
            rspBO.setMailAddr(notification.getProvince() + notification.getCity() + notification.getAddrDesc());
        }
        rspBO.setMailPhone(notification.getMobile());
        rspBO.setMailReciever(notification.getName());
        rspBO.setInvoiceResult(notification.getInvoiceResult());
        rspBO.setRows(this.moveOrderInfosToVO(orderInfos));
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        rspBO.setInvoiceStatus(notification.getInvoiceStatus());
        return rspBO;
    }

    @PostMapping(value={"qryNotifyDetailPart2"})
    public BusiQryNtfDetailPart2RspBO qryNotifyDetailPart2(@RequestBody BusiQryNotificationDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u7b2c\u4e8c\u90e8\u5206-\u7535\u5b50\u8d85\u5e02\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillNotificationInfo notification = new BillNotificationInfo();
        try {
            notification = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5355\u5217\u8868-\u901a\u77e5\u5355\u53f7\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868-\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
        }
        if (null == notification) {
            logger.info("billNotificationInfoMapper.selectByPrimaryKey\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + reqBO.getNotificationNo() + "\u6ca1\u6709\u901a\u77e5\u5355\u8bb0\u5f55");
        }
        String orderBy = null;
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder())) {
            if (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder())) {
                logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
                throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            }
            orderBy = reqBO.getSortName() + " " + reqBO.getSortOrder();
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<Object> invoiceList = new LinkedList();
        try {
            invoiceList = this.payInvoiceInfoMapper.selectByNotifyNo(reqBO.getNotificationNo());
        }
        catch (Exception e) {
            logger.info("payInvoiceInfoMapper.selectByNotifyNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff0c\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
        }
        BusiQryNtfDetailPart2RspBO rspBO = new BusiQryNtfDetailPart2RspBO();
        if (invoiceList.isEmpty()) {
            logger.info("payInvoiceInfoMapper.selectByNotifyNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            return rspBO;
        }
        PayInvoiceInfo singleInvoice = (PayInvoiceInfo)invoiceList.get(0);
        rspBO.setAddr(singleInvoice.getAddress());
        rspBO.setBankAcctNo(singleInvoice.getBankAcNo());
        rspBO.setBankName(singleInvoice.getBankName());
        rspBO.setInvoiceAmt(singleInvoice.getAmt());
        rspBO.setInvoiceCode(singleInvoice.getInvoiceCode());
        rspBO.setInvoiceDate(singleInvoice.getInvoiceDate());
        rspBO.setInvoiceNo(singleInvoice.getInvoiceNo());
        rspBO.setName(singleInvoice.getName());
        rspBO.setNoneTaxAmt(singleInvoice.getNotTaxAmt());
        rspBO.setPhone(singleInvoice.getPhone());
        rspBO.setTaxAmt(singleInvoice.getTaxAmt());
        rspBO.setTaxNo(singleInvoice.getTaxNo());
        rspBO.setInvoiceType(singleInvoice.getInvoiceType());
        InvoiceType invoiceTypeEnum = InvoiceType.getInstance(rspBO.getInvoiceType());
        rspBO.setInvoiceTypeStr(this.enumsService.getDescr(invoiceTypeEnum));
        List<Object> invoiceDetails = new LinkedList();
        try {
            invoiceDetails = this.payInvoiceDetailMapper.getPageByInvoiceListPK(singleInvoice.getInvoiceCode(), singleInvoice.getInvoiceNo(), singleInvoice.getInvoiceDate(), (Page<Map<String, Object>>)page, orderBy);
        }
        catch (Exception e) {
            logger.info("payInvoiceDetailMapper.getPageByInvoiceListPK\u67e5\u8be2\u51fa\u9519,\u5165\u53c2\uff1a" + singleInvoice.getInvoiceCode() + "," + singleInvoice.getInvoiceNo() + "," + singleInvoice.getInvoiceDate(), (Throwable)e);
            throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff0c\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u4fe1\u606f\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
        }
        if (invoiceDetails.isEmpty()) {
            logger.info("payInvoiceDetailMapper.getPageByInvoiceListPK\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + singleInvoice.getInvoiceCode() + "," + singleInvoice.getInvoiceNo() + "," + singleInvoice.getInvoiceDate());
            return rspBO;
        }
        LinkedList<InvoiceDetailVO> detailsOut = new LinkedList<InvoiceDetailVO>();
        for (PayInvoiceDetail payInvoiceDetail : invoiceDetails) {
            InvoiceDetailVO invoiceDetailOut = new InvoiceDetailVO();
            BeanUtils.copyProperties((Object)payInvoiceDetail, (Object)invoiceDetailOut);
            detailsOut.add(invoiceDetailOut);
        }
        rspBO.setNotificationNo(notification.getNotificationNo());
        rspBO.setRows(detailsOut);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    @PostMapping(value={"qryNotifyDetailWithItemListPart"})
    public BusiQryNtfDetailRspBO qryNotifyDetailWithItemListPart(@RequestBody BusiQryNotificationDetailReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1\u7b2c\u4e8c\u90e8\u5206-\u7535\u5b50\u8d85\u5e02\u5165\u53c2\uff1a" + reqBO.toString());
        }
        if (null == reqBO.getNotificationNo()) {
            throw new PfscExtBusinessException("0001", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u8be6\u60c5\u4e1a\u52a1\u670d\u52a1-\u5f00\u7968\u901a\u77e5\u5355\u53f7[notificationNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BillNotificationInfo notification = new BillNotificationInfo();
        try {
            notification = this.billNotificationInfoMapper.selectByPrimaryKey(reqBO.getNotificationNo());
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5355\u5217\u8868-\u901a\u77e5\u5355\u53f7\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new PfscExtBusinessException("18000", "\u67e5\u8be2\u5f00\u7968\u901a\u77e5\u5217\u8868-\u6570\u636e\u5e93\u64cd\u4f5c\u9519\u8bef");
        }
        if (null == notification) {
            logger.info("billNotificationInfoMapper.selectByPrimaryKey\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff1a" + reqBO.getNotificationNo() + "\u6ca1\u6709\u901a\u77e5\u5355\u8bb0\u5f55");
        }
        if (!StringUtils.isEmpty((CharSequence)reqBO.getSortName()) && !StringUtils.isEmpty((CharSequence)reqBO.getSortOrder()) && (AntiSqlInjectionManage.sqlValidate(reqBO.getSortName()) || AntiSqlInjectionManage.sqlValidate(reqBO.getSortOrder()))) {
            logger.error("\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
            throw new PfscExtBusinessException("18000", "\u60a8\u53d1\u9001\u8bf7\u6c42\u4e2d\u7684\u53c2\u6570\u4e2d\u542b\u6709\u975e\u6cd5\u5b57\u7b26");
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<Object> invoiceList = new LinkedList();
        try {
            invoiceList = this.payInvoiceInfoMapper.selectByNotifyNo(reqBO.getNotificationNo(), (Page<PayInvoiceInfo>)page);
        }
        catch (Exception e) {
            logger.info("payInvoiceInfoMapper.selectByNotifyNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            throw new PfscExtBusinessException("18001", "\u5f00\u7968\u901a\u77e5\u5355\u53f7\uff0c\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\uff0c\u6570\u636e\u5e93\u64cd\u4f5c\u5931\u8d25");
        }
        BusiQryNtfDetailRspBO rspBO = new BusiQryNtfDetailRspBO();
        if (invoiceList.isEmpty()) {
            logger.info("payInvoiceInfoMapper.selectByNotifyNo\u67e5\u8be2\u8fd4\u56de\u4e3a\u7a7a,\u5165\u53c2\uff1a" + reqBO.getNotificationNo());
            return rspBO;
        }
        ArrayList<InvoiceDetailWithItemListVO> list = new ArrayList<InvoiceDetailWithItemListVO>();
        for (PayInvoiceInfo payInvoiceInfo : invoiceList) {
            InvoiceDetailWithItemListVO vo = new InvoiceDetailWithItemListVO();
            vo.setAddr(payInvoiceInfo.getAddress());
            vo.setBankAcctNo(payInvoiceInfo.getBankAcNo());
            vo.setBankName(payInvoiceInfo.getBankName());
            vo.setInvoiceAmt(payInvoiceInfo.getAmt());
            vo.setInvoiceCode(payInvoiceInfo.getInvoiceCode());
            vo.setInvoiceDate(payInvoiceInfo.getInvoiceDate());
            vo.setInvoiceNo(payInvoiceInfo.getInvoiceNo());
            vo.setName(payInvoiceInfo.getName());
            vo.setNoneTaxAmt(payInvoiceInfo.getNotTaxAmt());
            vo.setPhone(payInvoiceInfo.getPhone());
            vo.setTaxAmt(payInvoiceInfo.getTaxAmt());
            vo.setTaxNo(payInvoiceInfo.getTaxNo());
            vo.setInvoiceType(payInvoiceInfo.getInvoiceType());
            InvoiceType invoiceTypeEnum = InvoiceType.getInstance(vo.getInvoiceType());
            vo.setInvoiceTypeStr(this.enumsService.getDescr(invoiceTypeEnum));
            vo.setNotificationNo(notification.getNotificationNo());
            list.add(vo);
        }
        rspBO.setRows(list);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }

    private List<OrderInfoVO> moveOrderInfosToVO(List<PayPurchaseOrderInfo> orderInfos) {
        LinkedList<OrderInfoVO> infos = new LinkedList<OrderInfoVO>();
        for (PayPurchaseOrderInfo singleInfo : orderInfos) {
            OrderInfoVO singleVO = new OrderInfoVO();
            singleVO.setSupplierNo(singleInfo.getSupplierNo());
            String supplierStr = this.organizationInfoService.querySupplierName(singleVO.getSupplierNo());
            singleVO.setSupplierName(supplierStr);
            singleVO.setConfirmDate(singleInfo.getRecvDate());
            singleVO.setInspectionId(String.valueOf(singleInfo.getInspectionId()));
            singleVO.setLastConfirmDate(singleInfo.getRecvDate());
            singleVO.setOrderAmt(singleInfo.getOrderAmt());
            singleVO.setOrderCreateDate(singleInfo.getOrderDate());
            singleVO.setOrderCreator(singleInfo.getPurchaserName());
            singleVO.setOrderId(String.valueOf(singleInfo.getOrderId()));
            singleVO.setPurchaseOrderCode(singleInfo.getPurchaseOrderCode());
            singleVO.setPurchaseOrderName(singleInfo.getPurchaseOrderName());
            singleVO.setOrderStatus(singleInfo.getOrderStatus());
            singleVO.setExtOrderId(singleInfo.getExtOrderId());
            OrderStatus orderStatusEnum = OrderStatus.getInstance(singleVO.getOrderStatus());
            singleVO.setOrderStatusStr(this.enumsService.getDescr(orderStatusEnum));
            singleVO.setOrderType(singleInfo.getOrderType());
            singleVO.setPurchaseNo(singleInfo.getPurchaseNo());
            String purchaserName = this.organizationInfoService.queryOrgName(singleVO.getPurchaseNo());
            singleVO.setPurchaserName(purchaserName);
            List<PayItemInfo> itemInfos = this.payItemInfoMapper.selectByNotifNoAndOrderId(singleInfo.getNotificationNo(), singleInfo.getOrderId(), null);
            LinkedList<OrderItemVO> itemVOs = new LinkedList<OrderItemVO>();
            for (PayItemInfo itemInfo : itemInfos) {
                OrderItemVO vo = new OrderItemVO();
                vo.setItemName(itemInfo.getItemName());
                vo.setSpec(itemInfo.getSpec());
                vo.setModel(itemInfo.getModel());
                vo.setUnit(itemInfo.getUnitName());
                vo.setUnitId(itemInfo.getUnitId());
                vo.setQuantity(itemInfo.getQuantity());
                vo.setSalePrice(itemInfo.getPurchaseUnitPrice());
                vo.setSumTaxPrice(itemInfo.getUntaxAmt().add(itemInfo.getTaxAmt()));
                vo.setTotalAmt(itemInfo.getAmount());
                itemVOs.add(vo);
            }
            singleVO.setItemList(itemVOs);
            infos.add(singleVO);
        }
        return infos;
    }
}

