/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiQueryInspectionDetailUrlService;
import com.tydic.pfsc.api.busi.bo.BusiQueryInspectionDetailUrlReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQueryInspectionDetailUrlRspBO;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.SaleOrderInfo;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiQueryInspectionDetailUrlService"})
public class BusiQueryInspectionDetailUrlServiceImpl
implements BusiQueryInspectionDetailUrlService {
    private static final Logger LOGGER = LoggerFactory.getLogger(BusiQueryInspectionDetailUrlServiceImpl.class);
    private SaleOrderInfoMapper saleOrderInfoMapper;

    @Autowired
    public BusiQueryInspectionDetailUrlServiceImpl(SaleOrderInfoMapper saleOrderInfoMapper) {
        this.saleOrderInfoMapper = saleOrderInfoMapper;
    }

    @PostMapping(value={"query"})
    public BusiQueryInspectionDetailUrlRspBO query(@RequestBody BusiQueryInspectionDetailUrlReqBO reqBO) {
        Long inspectionId;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("\u67e5\u8be2\u9a8c\u6536\u8be6\u60c5\u9875\u9762\u5730\u5740\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if ((inspectionId = reqBO.getInspectionId()) == null) {
            throw new PfscExtBusinessException("0001", "\u9a8c\u6536\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)reqBO.getReqType())) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2reqType\u4e0d\u80fd\u4e3a\u7a7a");
        }
        SaleOrderInfo saleOrder = new SaleOrderInfo();
        saleOrder.setInspectionId(inspectionId);
        saleOrder = this.saleOrderInfoMapper.getModelBy(saleOrder);
        if (null == saleOrder) {
            BusiQueryInspectionDetailUrlRspBO rspBO = new BusiQueryInspectionDetailUrlRspBO();
            rspBO.setUrl("");
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        String source = saleOrder.getSource();
        StringBuilder url = new StringBuilder();
        if (OrderSource.CONSULT_PRICE.getCode().equals(source) || OrderSource.CONSULT_PRICE_FRAME.getCode().equals(source)) {
            url.append("/html/professionalCompany/order-saleOrder-wz-receiveSendGoods.html?saleOrderId=").append(saleOrder.getOrderId()).append("&purchaserId=").append(saleOrder.getPurchaseNo());
        } else if ("purOrder".equals(reqBO.getReqType())) {
            url.append("?purchaseOrderId=").append(saleOrder.getOrderId()).append("&purchaserId=").append(saleOrder.getPurchaseNo());
        } else {
            url.append("/html/professionalCompany/receiveAndDeliverGoodsDetail.html?id=").append(saleOrder.getOrderId()).append("&purchaserId=").append(saleOrder.getPurchaseNo()).append("&type=0");
        }
        BusiQueryInspectionDetailUrlRspBO rspBO = new BusiQueryInspectionDetailUrlRspBO();
        rspBO.setUrl(url.toString());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

