/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiReceiptUploadService;
import com.tydic.pfsc.api.busi.bo.BusiReceiptUploadReqBO;
import com.tydic.pfsc.api.busi.bo.BusiReceiptUploadRspBO;
import com.tydic.pfsc.dao.AdvanceReceiveMapper;
import com.tydic.pfsc.dao.po.AdvanceReceive;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiReceiptUploadService"})
public class BusiReceiptUploadServiceImpl
implements BusiReceiptUploadService {
    private static final Logger logger = LoggerFactory.getLogger(BusiReceiptUploadServiceImpl.class);
    @Autowired
    private AdvanceReceiveMapper advanceReceiveMapper;

    @PostMapping(value={"process"})
    public BusiReceiptUploadRspBO process(@RequestBody BusiReceiptUploadReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u4e0a\u4f20\u9644\u4ef6\u670d\u52a1\uff08\u5e73\u53f0\u4f7f\u7528\u8d39\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        Boolean isUpdate = reqBO.getIsUpdate();
        Long seq = reqBO.getSeq();
        String originalFilename = reqBO.getOriginalFilename();
        if (isUpdate == null) {
            throw new PfscExtBusinessException("0001", "isUpdate\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (seq == null) {
            throw new PfscExtBusinessException("0001", "\u94f6\u884c\u56de\u5355\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!StringUtils.hasText((String)originalFilename)) {
            throw new PfscExtBusinessException("0001", "\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List<AdvanceReceive> list = this.advanceReceiveMapper.selectReceiveByFileName(originalFilename);
        if (originalFilename.indexOf(",") >= 0) {
            throw new PfscExtBusinessException("0001", "\u6587\u4ef6\u540d\u4e0d\u80fd\u542b\u82f1\u6587\u9017\u53f7");
        }
        if (!list.isEmpty() && list.size() > 0) {
            for (AdvanceReceive po : list) {
                if (po.getSeq().equals(seq)) continue;
                throw new PfscExtBusinessException("0001", "\u6587\u4ef6\u4e0d\u80fd\u91cd\u540d\uff0c\u8bf7\u5220\u9664\u539f\u6709\u6587\u4ef6\u6216\u8005\u91cd\u547d\u540d\u65b0\u6587\u4ef6");
            }
        }
        if (isUpdate.booleanValue()) {
            AdvanceReceive advanceReceive = new AdvanceReceive();
            advanceReceive.setSeq(seq);
            advanceReceive.setReceipt(originalFilename);
            this.advanceReceiveMapper.updateByPrimaryKeySelective(advanceReceive);
        }
        BusiReceiptUploadRspBO rspBO = new BusiReceiptUploadRspBO();
        rspBO.setOssFilename(originalFilename);
        return rspBO;
    }
}

