/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiSubAccountAdjustService;
import com.tydic.pfsc.api.busi.bo.BusiSubAccountAdjustReqBO;
import com.tydic.pfsc.api.busi.bo.BusiSubAccountAdjustRspBO;
import com.tydic.pfsc.dao.po.TranDetail;
import com.tydic.pfsc.enums.BusinessType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.TransactionService;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.busi.BusiSubAccountAdjustService"})
public class BusiSubAccountAdjustServiceImpl
implements BusiSubAccountAdjustService {
    private static final Logger logger = LoggerFactory.getLogger(BusiSubAccountAdjustServiceImpl.class);
    @Autowired
    private TransactionService transactionService;

    @PostMapping(value={"adjustSubAccount"})
    public BusiSubAccountAdjustRspBO adjustSubAccount(@RequestBody BusiSubAccountAdjustReqBO reqBO) {
        BusiSubAccountAdjustRspBO resp = new BusiSubAccountAdjustRspBO();
        if (logger.isDebugEnabled()) {
            logger.debug("\u8c03\u8d26\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.isEmpty((Object)reqBO.getRemark())) {
            reqBO.setRemark(reqBO.getRemark().replaceAll("\r\n", " "));
        } else {
            reqBO.setRemark("");
        }
        String source = reqBO.getSource();
        if (source == null) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u5fc5\u987b\u8f93\u5165");
        }
        Integer adjustType = reqBO.getAdjustType();
        String remark = reqBO.getRemark();
        if (StringUtils.hasText((String)remark)) {
            if (remark.indexOf("[onlypa]") != -1) {
                adjustType = 2;
            } else if (remark.indexOf("[onlyshop]") != -1) {
                adjustType = 1;
            }
        }
        if (adjustType == null) {
            adjustType = 0;
        }
        if (!StringUtils.hasText((String)reqBO.getFromSubAcctNo())) {
            throw new PfscExtBusinessException("0001", "\u8c03\u51fa\u8d26\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (!StringUtils.hasText((String)reqBO.getToSubAcctNo())) {
            throw new PfscExtBusinessException("0001", "\u8c03\u5165\u8d26\u53f7\u5fc5\u987b\u8f93\u5165");
        }
        if (reqBO.getFromSubAcctNo().equals(reqBO.getToSubAcctNo())) {
            throw new PfscExtBusinessException("0001", "\u8c03\u5165\u548c\u8c03\u51fa\u8d26\u53f7\u4e0d\u5141\u8bb8\u76f8\u540c");
        }
        if (reqBO.getAmount() == null || reqBO.getAmount().compareTo(BigDecimal.ZERO) <= 0) {
            throw new PfscExtBusinessException("0001", "\u8f6c\u51fa\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0");
        }
        try {
            if (reqBO.getRemark().getBytes("UTF-8").length > 256) {
                throw new PfscExtBusinessException("0001", "\u5907\u6ce8\u5b57\u6570\u592a\u957f");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u83b7\u53d6\u5907\u6ce8\u5b57\u8282\u6570\u5931\u8d25", (Throwable)e);
        }
        Long orgId = reqBO.getOrgId();
        TranDetail tranDetail = new TranDetail();
        tranDetail.setRecvAcctNo(reqBO.getToSubAcctNo());
        tranDetail.setPayAcctNo(reqBO.getFromSubAcctNo());
        tranDetail.setTranAmt(reqBO.getAmount());
        tranDetail.setBusinessType(BusinessType.ACCOUNT_REGULATION.getCode());
        tranDetail.setRemark(reqBO.getRemark());
        tranDetail.setLoginId(reqBO.getUserId());
        tranDetail.setOrgId(orgId);
        boolean informBank = true;
        HashMap<String, Object> data = null;
        if (adjustType == 1) {
            informBank = false;
            tranDetail.setBusinessType(BusinessType.MALL_RECONCILIATION.getCode());
            tranDetail.setRemark(tranDetail.getRemark() + "(\u5546\u57ce\u5355\u8fb9)");
        } else if (adjustType == 2) {
            data = new HashMap<String, Object>();
            data.put("NOT_CHANGE_SUB_ACCT", "Y");
            tranDetail.setBusinessType(BusinessType.BANK_RECONCILIATION.getCode());
            tranDetail.setRemark(tranDetail.getRemark() + "(\u94f6\u884c\u5355\u8fb9)");
        }
        TranDetail transfer = this.transactionService.transfer(tranDetail, false, informBank, data);
        if (!"0000".equals(transfer.getRespCode())) {
            resp.setRespCode("18000");
            resp.setRespDesc("\u5931\u8d25");
            return resp;
        }
        resp.setRespCode("0000");
        resp.setRespDesc("\u6210\u529f");
        return resp;
    }
}

