/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.zm.impl;

import com.tydic.order.third.intf.constant.BusinessException;
import com.tydic.pfsc.api.zm.MarkInvoiceService;
import com.tydic.pfsc.api.zm.bo.MarkInvoiceReqBO;
import com.tydic.pfsc.api.zm.bo.MarkInvoiceRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"FSC_GROUP_DEV/1.0.0/com.tydic.pfsc.api.zm.MarkInvoiceService"})
public class MarkInvoiceServiceImpl
implements MarkInvoiceService {
    private static final Logger logger = LoggerFactory.getLogger(MarkInvoiceServiceImpl.class);
    private BillApplyInfoMapper billApplyInfoMapper;
    private SaleOrderInfoMapper saleOrderInfoMapper;
    private SaleItemInfoMapper saleItemInfoMapper;

    @Autowired
    public MarkInvoiceServiceImpl(BillApplyInfoMapper billApplyInfoMapper, SaleOrderInfoMapper saleOrderInfoMapper, SaleItemInfoMapper saleItemInfoMapper) {
        this.billApplyInfoMapper = billApplyInfoMapper;
        this.saleOrderInfoMapper = saleOrderInfoMapper;
        this.saleItemInfoMapper = saleItemInfoMapper;
    }

    @PostMapping(value={"markInvoice"})
    public MarkInvoiceRspBO markInvoice(@RequestBody MarkInvoiceReqBO markInvoiceReqBO) {
        MarkInvoiceRspBO rspBO = new MarkInvoiceRspBO();
        if (null == markInvoiceReqBO || markInvoiceReqBO.getApplyNo() == null) {
            throw new BusinessException("18001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (markInvoiceReqBO.getApplyNo() != null && markInvoiceReqBO.getApplyNo().size() > 0) {
            for (String s : markInvoiceReqBO.getApplyNo()) {
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(s);
                if (!billApplyInfo.getBillStatus().equals("00")) {
                    throw new BusinessException("18003", "\u72b6\u6001\u4e0d\u662f\u5df2\u63d0\u4ea4");
                }
                this.billApplyInfoMapper.updateStatusByApplyNo(s, "03");
                this.saleOrderInfoMapper.updateStatusByApplyNo(s, "02");
                this.saleItemInfoMapper.updateStatusByApplyNo(s, "03");
            }
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
        }
        return rspBO;
    }
}

