/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.PayAddTradeServiceFeeService;
import com.tydic.pfsc.api.busi.bo.PayAddTradeServiceFeeReqBO;
import com.tydic.pfsc.base.BasePayService;
import com.tydic.pfsc.base.PfscExtReqBaseBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.enums.InquiryApprovalStatus;
import com.tydic.pfsc.enums.InquiryMailStatus;
import com.tydic.pfsc.enums.InquiryPayFeeType;
import com.tydic.pfsc.enums.InquiryPayFlag;
import com.tydic.pfsc.enums.InquiryPaymentStatus;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.PayAddTradeServiceFeeService"})
public class AddTradeServiceFeePayServiceImpl
extends BasePayService<PfscExtRspBaseBO>
implements PayAddTradeServiceFeeService {
    private static final Logger logger = LoggerFactory.getLogger(AddTradeServiceFeePayServiceImpl.class);
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;

    @PostMapping(value={"addTradeServiceFee"})
    public PfscExtRspBaseBO addTradeServiceFee(@RequestBody PayAddTradeServiceFeeReqBO reqBO) {
        PfscExtRspBaseBO rspBO = (PfscExtRspBaseBO)this.queryRspOrSaveLog((PfscExtReqBaseBO)reqBO);
        if (rspBO != null) {
            return rspBO;
        }
        try {
            rspBO = this.addTradeServiceFee2(reqBO);
        }
        catch (Exception e) {
            logger.error("\u5931\u8d25", (Throwable)e);
            this.updateLog((PfscExtReqBaseBO)reqBO, e);
            throw new PfscExtBusinessException("18000", e.getMessage());
        }
        this.updateLog((PfscExtReqBaseBO)reqBO, rspBO);
        return rspBO;
    }

    private PfscExtRspBaseBO addTradeServiceFee2(PayAddTradeServiceFeeReqBO reqBO) {
        if (null == reqBO.getPayOrderNo()) {
            logger.error("\u7f34\u8d39\u8ba2\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u8ba2\u5355\u53f7[payOrderNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getInquiryNo()) {
            logger.error("\u8be2\u4ef7\u5355\u53f7[inquiryNo]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u8be2\u4ef7\u5355\u53f7[inquiryNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderDate()) {
            logger.error("\u8ba2\u5355\u65e5\u671f[orderDate]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u65e5\u671f[orderDate]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderTotalMoney()) {
            logger.error("\u8ba2\u5355\u603b\u91d1\u989d[totalAmount]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355\u603b\u91d1\u989d[totalAmount]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayMoney()) {
            logger.error("\u7f34\u8d39\u91d1\u989d[payMoney]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u91d1\u989d[payMoney]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayOrderName()) {
            logger.error("\u7f34\u8d39\u8ba2\u5355\u540d\u79f0[payOrderName]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u8ba2\u5355\u540d\u79f0[payOrderName]\u4e3a\u7a7a");
        }
        if (null == reqBO.getCompanyType()) {
            logger.error("\u7f34\u8d39\u5355\u4f4d\u7c7b\u578b[companyType]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u5355\u4f4d\u7c7b\u578b[companyType]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperUnitNo()) {
            logger.error("\u6536\u6b3e\u5355\u4f4d\u673a\u6784\u53f7[operUnitNo]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u6536\u6b3e\u5355\u4f4d\u673a\u6784\u53f7[operUnitNo]\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            logger.error("\u7f34\u8d39\u5355\u4f4d\u7f16\u53f7[supplierId]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u7f34\u8d39\u5355\u4f4d\u7f16\u53f7[supplierId]\u4e3a\u7a7a");
        }
        if (null == reqBO.getOperator()) {
            logger.error("\u7ed3\u7b97\u5458[operator]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u7ed3\u7b97\u5458[operator]\u4e3a\u7a7a");
        }
        if (null == reqBO.getPlanUserId()) {
            logger.error("\u4e1a\u52a1\u5458[planUserId]\u4e3a\u7a7a");
            throw new PfscExtBusinessException("0001", "\u4e1a\u52a1\u5458[planUserId]\u4e3a\u7a7a");
        }
        InquiryPayOrder payOrderInfo = new InquiryPayOrder();
        payOrderInfo.setInquiryNo(reqBO.getInquiryNo());
        payOrderInfo.setPayOrderNo(reqBO.getPayOrderNo());
        payOrderInfo.setOrderTime(reqBO.getOrderDate());
        payOrderInfo.setOrderTotalMoney(reqBO.getOrderTotalMoney());
        payOrderInfo.setPayOrderName(reqBO.getPayOrderName());
        payOrderInfo.setPayMoney(reqBO.getPayMoney());
        payOrderInfo.setCompanyType(reqBO.getCompanyType().getCode());
        payOrderInfo.setOperUnitNo(reqBO.getOperUnitNo());
        payOrderInfo.setSupplierId(reqBO.getSupplierId());
        payOrderInfo.setOperator(reqBO.getOperator());
        payOrderInfo.setPlanUserId(reqBO.getPlanUserId());
        if (null == reqBO.getPayFeeType()) {
            payOrderInfo.setPayFeeType(InquiryPayFeeType.TRADE_SERVICE_FEE.getCode());
        } else {
            payOrderInfo.setPayFeeType(reqBO.getPayFeeType());
        }
        if (reqBO.getPayFlag() == null) {
            payOrderInfo.setPayFlag(InquiryPayFlag.CONFIRMED.getCode());
        } else {
            payOrderInfo.setPayFlag(reqBO.getPayFlag());
        }
        payOrderInfo.setMark(reqBO.getMark());
        payOrderInfo.setPaymentStatus(InquiryPaymentStatus.NO_PAYMENT.getCode());
        payOrderInfo.setMailStatus(InquiryMailStatus.NOT_MAILING.getCode());
        payOrderInfo.setOrderStatus(OrderStatus.NO_APPLY.getCode());
        payOrderInfo.setApprovalStatus(InquiryApprovalStatus.UNSUBMITTED.getCode());
        this.inquiryPayOrderMapper.insert(payOrderInfo);
        return new PfscExtRspBaseBO();
    }

    @Override
    protected PfscExtRspBaseBO fillRspBO(String respPackage) {
        PfscExtRspBaseBO rspBO = new PfscExtRspBaseBO();
        JSONObject jsonObject = JSONObject.fromObject((Object)respPackage);
        rspBO.setRespCode(jsonObject.containsKey((Object)"respCode") ? jsonObject.getString("respCode") : null);
        rspBO.setRespDesc(jsonObject.containsKey((Object)"respDesc") ? jsonObject.getString("respDesc") : null);
        return rspBO;
    }
}

