/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.pfsc.api.busi.BusiQrySaleOrderInfoForApplyService;
import com.tydic.pfsc.api.busi.bo.BusiQrySaleOrderInfoForApplyReqBO;
import com.tydic.pfsc.api.busi.bo.BusiQrySaleOrderInfoForApplyRspBO;
import com.tydic.pfsc.api.busi.bo.SaleOrderInfoForApply;
import com.tydic.pfsc.dao.SaleOrderInfoMapper;
import com.tydic.pfsc.dao.po.ApplySaleOrderInfoRspPO;
import com.tydic.pfsc.dao.vo.SaleOrderInfoForApplyVO;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiQrySaleOrderInfoForApplyService"})
public class BusiQrySaleOrderInfoForApplyServiceImpl
implements BusiQrySaleOrderInfoForApplyService {
    @Autowired
    private SaleOrderInfoMapper saleOrderInfoMapper;
    @Autowired
    private EnumsService enumsService;

    @PostMapping(value={"queryListPage"})
    public BusiQrySaleOrderInfoForApplyRspBO queryListPage(@RequestBody BusiQrySaleOrderInfoForApplyReqBO reqBO) {
        BusiQrySaleOrderInfoForApplyRspBO rspBO = new BusiQrySaleOrderInfoForApplyRspBO();
        SaleOrderInfoForApplyVO saleOrderInfoVO = new SaleOrderInfoForApplyVO();
        BeanUtils.copyProperties((Object)reqBO, (Object)saleOrderInfoVO);
        if (saleOrderInfoVO.getOrderDateEnd() != null) {
            try {
                String orderDateEndString = new SimpleDateFormat("yyyy-MM-dd").format(saleOrderInfoVO.getOrderDateEnd()) + " 23:59:59";
                saleOrderInfoVO.setOrderDateEnd(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(orderDateEndString));
            }
            catch (ParseException e) {
                throw new PfscExtBusinessException("18000", "\u683c\u5f0f\u5316\u65e5\u671f\u51fa\u9519");
            }
        }
        if ("0".equals(reqBO.getIsProfessionalOrgExt())) {
            saleOrderInfoVO.setOperUnitNo(reqBO.getCompanyId());
        } else {
            saleOrderInfoVO.setOperUnitNo(null);
        }
        Page page = new Page(reqBO.getPageNo().intValue(), reqBO.getPageSize().intValue());
        List<ApplySaleOrderInfoRspPO> applyOrderInfoList = this.saleOrderInfoMapper.getListPageForApply(saleOrderInfoVO, (Page<Map<String, Object>>)page);
        ArrayList<SaleOrderInfoForApply> orderList = new ArrayList<SaleOrderInfoForApply>();
        for (ApplySaleOrderInfoRspPO rspPO : applyOrderInfoList) {
            SaleOrderInfoForApply saleOrderInfoForApply = new SaleOrderInfoForApply();
            BeanUtils.copyProperties((Object)rspPO, (Object)saleOrderInfoForApply);
            saleOrderInfoForApply.setOrderStatusDesc(this.enumsService.getDescr(OrderStatus.getInstance(rspPO.getOrderStatus())));
            orderList.add(saleOrderInfoForApply);
        }
        rspBO.setRows(orderList);
        rspBO.setRecordsTotal(Integer.valueOf(page.getTotalCount()));
        rspBO.setTotal(Integer.valueOf(page.getTotalPages()));
        rspBO.setPageNo(Integer.valueOf(page.getPageNo()));
        return rspBO;
    }
}

