/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.DzcsInvoiceReturnQryApplyService;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnInvoiceRspBO;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnQryApplyReqBO;
import com.tydic.pfsc.api.busi.bo.DzcsInvoiceReturnQryApplyRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.InvoiceReturnMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturn;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.dao.vo.SaleInvoiceInfoVO;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.SaleInvoiceInfoInvoiceStatus;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.EnumsService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.DzcsInvoiceReturnQryApplyService"})
public class DzcsInvoiceReturnQryApplyServiceImpl
implements DzcsInvoiceReturnQryApplyService {
    private static final Logger logger = LoggerFactory.getLogger(DzcsInvoiceReturnQryApplyServiceImpl.class);
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private EnumsService enumsService;
    @Autowired
    private InvoiceReturnMapper invoiceReturnMapper;
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    @PostMapping(value={"query"})
    public DzcsInvoiceReturnQryApplyRspBO query(@RequestBody DzcsInvoiceReturnQryApplyReqBO reqBO) {
        String billNo;
        if (logger.isDebugEnabled()) {
            logger.debug("\u67e5\u8be2\u9000\u7968\u7533\u8bf7\u670d\u52a1\uff08\u7535\u5b50\u8d85\u5e02\u9000\u7968\uff09\u5165\u53c2\uff1a" + reqBO);
        }
        if (!StringUtils.hasText((String)(billNo = reqBO.getBillNo()))) {
            throw new PfscExtBusinessException("0001", "\u9000\u7968\u7533\u8bf7\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceReturn invoiceReturn = this.invoiceReturnMapper.selectByPrimaryKey(billNo);
        DzcsInvoiceReturnQryApplyRspBO rspBO = new DzcsInvoiceReturnQryApplyRspBO();
        String invoiceClasses = null;
        String invoiceType = null;
        BeanUtils.copyProperties((Object)invoiceReturn, (Object)rspBO);
        ArrayList<DzcsInvoiceReturnInvoiceRspBO> invoices = new ArrayList<DzcsInvoiceReturnInvoiceRspBO>();
        rspBO.setInvoices(invoices);
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(billNo);
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(vo);
        if (!invoiceReturnDetails.isEmpty()) {
            for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
                String applyNo1 = invoiceReturnDetail.getApplyNo1();
                String invoiceNo = invoiceReturnDetail.getInvoiceNo1();
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                invoiceClasses = billApplyInfo.getInvoiceClasses();
                invoiceType = billApplyInfo.getInvoiceType();
                SaleInvoiceInfo saleInvoiceInfo = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceNo);
                DzcsInvoiceReturnInvoiceRspBO invoice = new DzcsInvoiceReturnInvoiceRspBO();
                invoices.add(invoice);
                BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                invoice.setMatchFlag("1");
                invoice.setSupplierName(this.organizationInfoService.querySupplierName(billApplyInfo.getSupplierNo()));
                invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                invoice.setOperUnitName(this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo()));
                invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                invoice.setAmt(saleInvoiceInfo.getAmt());
                invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
                invoice.setPurchaseProjectName(this.organizationInfoService.queryProjectName(billApplyInfo.getPurchaseProjectId()).getAccountName());
                invoice.setRedOrderNo(saleInvoiceInfo.getRedOrderNo());
            }
        } else {
            List<String> applyNo1s = FscStringUtils.string2List(invoiceReturn.getApplyNo1(), ",");
            for (String applyNo1 : applyNo1s) {
                BillApplyInfo billApplyInfo = this.billApplyInfoMapper.selectByPrimaryKey(applyNo1);
                invoiceClasses = billApplyInfo.getInvoiceClasses();
                invoiceType = billApplyInfo.getInvoiceType();
                SaleInvoiceInfoVO saleInvoiceInfoVO = new SaleInvoiceInfoVO();
                saleInvoiceInfoVO.setApplyNo(applyNo1);
                List<SaleInvoiceInfo> saleInvoiceInfos = this.saleInvoiceInfoMapper.selectBy(saleInvoiceInfoVO);
                for (SaleInvoiceInfo saleInvoiceInfo : saleInvoiceInfos) {
                    DzcsInvoiceReturnInvoiceRspBO invoice = new DzcsInvoiceReturnInvoiceRspBO();
                    invoices.add(invoice);
                    BeanUtils.copyProperties((Object)billApplyInfo, (Object)invoice);
                    invoice.setMatchFlag("0");
                    invoice.setSupplierName(this.organizationInfoService.querySupplierName(billApplyInfo.getSupplierNo()));
                    invoice.setInvoiceTypeDescr(this.enumsService.getDescr(InvoiceType.getInstance(Integer.valueOf(billApplyInfo.getInvoiceType()))));
                    invoice.setOperUnitName(this.organizationInfoService.queryOrgName(billApplyInfo.getOperUnitNo()));
                    invoice.setInvoiceClassesDescr(this.enumsService.getDescr(InvoiceClasses.getInstance(billApplyInfo.getInvoiceClasses())));
                    invoice.setInvoiceNo(saleInvoiceInfo.getInvoiceNo());
                    invoice.setInvoiceCode(saleInvoiceInfo.getInvoiceCode());
                    invoice.setInvoiceDate(saleInvoiceInfo.getInvoiceDate());
                    invoice.setUntaxAmt(saleInvoiceInfo.getUntaxAmt());
                    invoice.setTaxAmt(saleInvoiceInfo.getTaxAmt());
                    invoice.setAmt(saleInvoiceInfo.getAmt());
                    invoice.setInvoiceStatusDescr(this.enumsService.getDescr(SaleInvoiceInfoInvoiceStatus.getInstance(saleInvoiceInfo.getInvoiceStatus())));
                    invoice.setPurchaseProjectName(this.organizationInfoService.queryProjectName(billApplyInfo.getPurchaseProjectId()).getAccountName());
                }
            }
        }
        rspBO.setInvoiceClasses(invoiceClasses);
        rspBO.setNoticeItem(this.enumsService.queryDzcsInvoiceReturnNoticeItem());
        ArrayList files = new ArrayList();
        rspBO.setFiles(files);
        return rspBO;
    }
}

