/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.PayAddCheckingRstService;
import com.tydic.pfsc.api.busi.bo.PayAddCheckingRstReqBO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.InquiryCheckingMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.InquiryTranInfoMapper;
import com.tydic.pfsc.dao.OrgPayConfigMapper;
import com.tydic.pfsc.dao.UnionSettleInfoMapper;
import com.tydic.pfsc.dao.po.InquiryPayOrderExt;
import com.tydic.pfsc.dao.po.UnionSettleInfo;
import com.tydic.pfsc.dao.vo.InquiryTranInfoExt;
import com.tydic.pfsc.dao.vo.InquiryTranInfoVO;
import com.tydic.pfsc.dao.vo.PayAddCheckingRstVO;
import com.tydic.pfsc.dao.vo.PayCheckingRstVO;
import com.tydic.pfsc.enums.InquiryPaymentStatus;
import com.tydic.pfsc.enums.InquiryTradeState;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.utils.DatesUtils;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PayAddCheckingRstServiceImpl
implements PayAddCheckingRstService {
    private static final Logger logger = LoggerFactory.getLogger(PayAddCheckingRstServiceImpl.class);
    @Autowired
    private InquiryCheckingMapper inquiryCheckingMapper;
    @Autowired
    private InquiryTranInfoMapper inquiryTranInfoMapper;
    @Autowired
    private UnionSettleInfoMapper unionSettleInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private OrgPayConfigMapper orgPayConfigMapper;

    public PfscExtRspBaseBO addCheckingRst(PayAddCheckingRstReqBO reqBO) {
        Date settleDate;
        if (logger.isDebugEnabled()) {
            logger.debug("\u8be2\u6bd4\u4ef7\u5bf9\u8d26\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if ((settleDate = reqBO.getSettleDate()) == null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            try {
                settleDate = sdf.parse(sdf.format(DatesUtils.dateBefore(-1)));
            }
            catch (ParseException e) {
                throw new PfscExtBusinessException("18005", "\u5bf9\u8d26\u65e5\u671f\u8f6c\u6362\u5931\u8d25");
            }
        }
        logger.info("\u5bf9\u8d26\u65e5\u671f\uff1a" + settleDate);
        InquiryTranInfoVO inquiryTranInfoVO = new InquiryTranInfoVO();
        inquiryTranInfoVO.setSettleDate(settleDate);
        inquiryTranInfoVO.setTradeState(InquiryTradeState.TRADE_SUCCESS.getCode());
        List<InquiryTranInfoExt> tranInfoList = this.inquiryTranInfoMapper.queryList4Checking(inquiryTranInfoVO);
        HashMap<String, PayAddCheckingRstVO> finalMap = new HashMap<String, PayAddCheckingRstVO>();
        if (tranInfoList.isEmpty() || null == tranInfoList) {
            logger.info("\u4e0d\u5b58\u5728\u5bf9\u8d26\u65e5\u671f\u4e3a:" + settleDate + "\u7684\u5df2\u7f34\u8d39\u8ba2\u5355\u4fe1\u606f\u3002");
        }
        for (InquiryTranInfoExt inquiryTranInfoExt : tranInfoList) {
            PayAddCheckingRstVO checkingVO = new PayAddCheckingRstVO();
            checkingVO.setOrderId(inquiryTranInfoExt.getOrderId());
            checkingVO.setSettleDate(settleDate);
            checkingVO.setOrderNo(inquiryTranInfoExt.getOrderNo());
            checkingVO.setInquiryNo(inquiryTranInfoExt.getInquiryNo());
            checkingVO.setOrderDate(inquiryTranInfoExt.getOrderDate());
            checkingVO.setOrderAmt(inquiryTranInfoExt.getOrderAmt());
            checkingVO.setPaymentStatus(inquiryTranInfoExt.getPaymentStatus());
            checkingVO.setSupplierId(inquiryTranInfoExt.getSupplierId());
            checkingVO.setOperUnitNo(inquiryTranInfoExt.getOperUnitNo());
            checkingVO.setPayPass(inquiryTranInfoExt.getPayType());
            finalMap.put(checkingVO.getOrderId(), checkingVO);
        }
        UnionSettleInfo unionSettleInfo = new UnionSettleInfo();
        unionSettleInfo.setSettleDate(settleDate);
        List<UnionSettleInfo> settleList = this.unionSettleInfoMapper.queryListByCondition(unionSettleInfo);
        if (null == settleList || settleList.isEmpty()) {
            logger.info("\u65e5\u671f:" + settleDate + "\u4e0d\u5b58\u5728\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u4fe1\u606f\u3002");
            if (null == finalMap || finalMap.isEmpty()) {
                logger.info("\u65e5\u671f:" + settleDate + "\u4e0d\u5b58\u5728\u5df2\u7f34\u8d39\u8ba2\u5355\u4fe1\u606f\u548c\u8054\u52a8\u4f18\u52bf\u5bf9\u8d26\u4fe1\u606f\u3002");
                return new PfscExtRspBaseBO();
            }
            this.insertOrderMap(finalMap);
        } else {
            for (UnionSettleInfo settleInfo : settleList) {
                String orderId = settleInfo.getOrderId();
                PayAddCheckingRstVO checkingRst = null;
                if (null == finalMap || finalMap.isEmpty() || null == finalMap.get(orderId)) {
                    logger.info("\u652f\u4ed8\u6d41\u6c34\u4e2d\u4e0d\u5b58\u5728" + orderId);
                    checkingRst = new PayAddCheckingRstVO();
                    Long operUnitNo = this.orgPayConfigMapper.queryOrgIdByMerId(settleInfo.getMerId());
                    checkingRst.setOperUnitNo(operUnitNo);
                    checkingRst.setOrderId(orderId);
                    checkingRst.setMerDate(settleInfo.getMerDate());
                    checkingRst.setPayDate(settleInfo.getPayDate());
                    checkingRst.setPayAmt(settleInfo.getAmount());
                    checkingRst.setSettleDate(settleInfo.getSettleDate());
                    checkingRst.setTransState(settleInfo.getTransState());
                    checkingRst.setTransTime(settleInfo.getTransTime());
                    checkingRst.setOrderPaySameAmt(new BigDecimal(0));
                    checkingRst.setOrderPaySameCount(0L);
                    checkingRst.setCheckingRst('N');
                } else {
                    checkingRst = (PayAddCheckingRstVO)finalMap.get(orderId);
                    checkingRst.setOrderId(settleInfo.getOrderId());
                    checkingRst.setMerDate(settleInfo.getMerDate());
                    checkingRst.setPayDate(settleInfo.getPayDate());
                    checkingRst.setPayAmt(settleInfo.getAmount());
                    checkingRst.setTransState(settleInfo.getTransState());
                    checkingRst.setTransTime(settleInfo.getTransTime());
                    if (null != checkingRst.getOrderAmt() && null != checkingRst.getPayAmt() && checkingRst.getOrderAmt().compareTo(checkingRst.getPayAmt()) == 0) {
                        checkingRst.setOrderPaySameAmt(new BigDecimal(checkingRst.getOrderAmt().toString()));
                        checkingRst.setOrderPaySameCount(1L);
                        checkingRst.setCheckingRst('Y');
                        if (checkingRst.getPaymentStatus().equals(InquiryPaymentStatus.ALREADY_PAID.getCode())) {
                            Date payFinshTime;
                            InquiryPayOrderExt inquiryPayOrderExt = new InquiryPayOrderExt();
                            inquiryPayOrderExt.setPayOrderNo(checkingRst.getOrderNo());
                            StringBuffer payFinshTimeStr = new StringBuffer();
                            payFinshTimeStr.append(new SimpleDateFormat("yyyy-MM-dd").format(checkingRst.getPayDate()) + " ");
                            payFinshTimeStr.append(new SimpleDateFormat("HHmmss").format(checkingRst.getTransTime()));
                            try {
                                payFinshTime = new SimpleDateFormat("yyyy-MM-dd HHmmss").parse(payFinshTimeStr.toString());
                            }
                            catch (ParseException e) {
                                throw new PfscExtBusinessException("18005", "\u652f\u4ed8\u5b8c\u6210\u65e5\u671f\u683c\u5f0f\u5316\u9519\u8bef");
                            }
                            inquiryPayOrderExt.setPayFinshTime(payFinshTime);
                            inquiryPayOrderExt.setPaymentStatus(InquiryPaymentStatus.CHECK_SUCCEED.getCode());
                            this.inquiryPayOrderMapper.updateState(inquiryPayOrderExt);
                        }
                        checkingRst.setPaymentStatus(InquiryPaymentStatus.CHECK_SUCCEED.getCode());
                    } else {
                        checkingRst.setOrderPaySameAmt(new BigDecimal(0));
                        checkingRst.setOrderPaySameCount(0L);
                        checkingRst.setCheckingRst('N');
                    }
                    finalMap.remove(orderId);
                }
                checkingRst.setSettleDate(settleDate);
                PayCheckingRstVO payCheckingRstVO = new PayCheckingRstVO();
                payCheckingRstVO.setOrderId(checkingRst.getOrderId());
                int flg = this.inquiryCheckingMapper.queryCountByConditions(payCheckingRstVO);
                if (0 == flg) {
                    this.inquiryCheckingMapper.addResult(checkingRst);
                    continue;
                }
                this.inquiryCheckingMapper.updateResult(checkingRst);
            }
            this.insertOrderMap(finalMap);
        }
        return new PfscExtRspBaseBO();
    }

    private void insertOrderMap(Map<String, PayAddCheckingRstVO> finalMap) {
        for (Map.Entry<String, PayAddCheckingRstVO> entry : finalMap.entrySet()) {
            PayAddCheckingRstVO checkingRst = entry.getValue();
            String orderId = entry.getKey();
            checkingRst.setOrderPaySameCount(0L);
            checkingRst.setOrderPaySameAmt(BigDecimal.ZERO);
            checkingRst.setCheckingRst('N');
            PayCheckingRstVO payCheckingRstVO = new PayCheckingRstVO();
            payCheckingRstVO.setOrderId(orderId);
            int flg = this.inquiryCheckingMapper.queryCountByConditions(payCheckingRstVO);
            if (0 == flg) {
                this.inquiryCheckingMapper.addResult(checkingRst);
                continue;
            }
            this.inquiryCheckingMapper.updateResult(checkingRst);
        }
    }
}

