/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.comb.impl;

import com.tydic.pfsc.api.busi.FscWfEndDealSynchFinanceBusiService;
import com.tydic.pfsc.api.busi.bo.FscWfEndDealSynchFinanceBusiReqBO;
import com.tydic.pfsc.api.busi.bo.FscWfEndDealSynchFinanceBusiRspBO;
import com.tydic.pfsc.api.busi.bo.WorkFlowDataInfoBO;
import com.tydic.pfsc.api.comb.FscWfEndWithSynchFinanceCombService;
import com.tydic.pfsc.api.comb.bo.FscWfEndWithSynchFinanceCombReqBO;
import com.tydic.pfsc.api.comb.bo.FscWfEndWithSynchFinanceCombRspBO;
import com.tydic.pfsc.dao.WorkFlowDataMapper;
import com.tydic.pfsc.dao.po.WorkFlowDataInfo;
import com.tydic.pfsc.dao.vo.WorkFlowDataInfoVO;
import com.tydic.pfsc.enums.FinancialStatus;
import com.tydic.pfsc.enums.WFBillType;
import com.tydic.pfsc.enums.WFStatus;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="fscWfEndWithSynchFinanceCombService")
public class FscWfEndWithSynchFinanceCombServiceImpl
implements FscWfEndWithSynchFinanceCombService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FscWfEndWithSynchFinanceCombServiceImpl.class);
    private static final boolean IS_DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private WorkFlowDataMapper workFlowDataMapper;
    private FscWfEndDealSynchFinanceBusiService fscWfEndDealSynchFinanceBusiService;

    @Autowired
    public FscWfEndWithSynchFinanceCombServiceImpl(WorkFlowDataMapper workFlowDataMapper, FscWfEndDealSynchFinanceBusiService fscWfEndDealSynchFinanceBusiService) {
        this.workFlowDataMapper = workFlowDataMapper;
        this.fscWfEndDealSynchFinanceBusiService = fscWfEndDealSynchFinanceBusiService;
    }

    public FscWfEndWithSynchFinanceCombRspBO dealWfEndWithSynchFinance(FscWfEndWithSynchFinanceCombReqBO reqBO) {
        List<WorkFlowDataInfo> workFlowDataInfoList;
        FscWfEndWithSynchFinanceCombRspBO rspBO = new FscWfEndWithSynchFinanceCombRspBO();
        WorkFlowDataInfoVO vo = new WorkFlowDataInfoVO();
        ArrayList<String> billTypeNotIn = new ArrayList<String>();
        billTypeNotIn.add(WFBillType.HANDMADE_COLLECTION.getCode());
        vo.setBillTypeNotIn(billTypeNotIn);
        vo.setProcInstId(reqBO.getProcInstId());
        vo.setStatus(WFStatus.APPROVAL_COMPLETE.getCode());
        vo.setFinancialStatus("'" + FinancialStatus.NO_SEND.getCode() + "','" + FinancialStatus.SEND_FAIL.getCode() + "','" + FinancialStatus.SEND_SUCCESS_1.getCode() + "','" + FinancialStatus.SEND_SUCCESS_2.getCode() + "'");
        vo.setTryCount(0);
        try {
            workFlowDataInfoList = this.workFlowDataMapper.selectListByVO(vo);
            if (CollectionUtils.isEmpty(workFlowDataInfoList)) {
                rspBO.setRespCode("18000");
                rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u9700\u8981\u5904\u7406\u7684\u4efb\u52a1");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u67e5\u8be2\u6570\u636e\u5e93workFlowDataMapper\u53d1\u751f\u5f02\u5e38" + e.toString());
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u6570\u636e\u5e93\u5f02\u5e38");
            return rspBO;
        }
        int failed = 0;
        for (WorkFlowDataInfo wfDataInfo : workFlowDataInfoList) {
            String service = wfDataInfo.getFinishEvtService();
            if (!StringUtils.hasLength((String)service)) continue;
            FscWfEndDealSynchFinanceBusiReqBO withSynchFinanceBusiReqBO = new FscWfEndDealSynchFinanceBusiReqBO();
            WorkFlowDataInfoBO workFlowDataInfoBO = new WorkFlowDataInfoBO();
            BeanUtils.copyProperties((Object)wfDataInfo, (Object)workFlowDataInfoBO);
            withSynchFinanceBusiReqBO.setWorkFlowDataInfo(workFlowDataInfoBO);
            FscWfEndDealSynchFinanceBusiRspBO withoutSynchFinanceBusiRspBO = this.fscWfEndDealSynchFinanceBusiService.dealWfEndWithoutSynchFinance(withSynchFinanceBusiReqBO);
            if ("0000".equals(withoutSynchFinanceBusiRspBO.getRespCode())) continue;
            if (IS_DEBUG_ENABLED) {
                LOGGER.debug("\u5ba1\u6279\u7ed3\u675f\u5904\u7406\uff08\u53d1\u9001\u8d22\u52a1\uff09\u670d\u52a1\u5931\u8d25" + withoutSynchFinanceBusiRspBO.getRespDesc());
            }
            ++failed;
        }
        int total = workFlowDataInfoList.size();
        int successed = total - failed;
        if (IS_DEBUG_ENABLED) {
            LOGGER.debug("\u5ba1\u6279\u7ed3\u675f\u5904\u7406\uff08\u53d1\u9001\u8d22\u52a1\uff09\u670d\u52a1\u7ed3\u675f\uff0c\u4e00\u5171\u5904\u7406" + total + "\u6761\uff0c\u5176\u4e2d\u6210\u529f" + successed + "\u6761\uff0c\u5931\u8d25" + failed + "\u6761");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5ba1\u6279\u7ed3\u675f\u5904\u7406\uff08\u53d1\u9001\u8d22\u52a1\uff09\u670d\u52a1\u7ed3\u675f\uff0c\u4e00\u5171\u5904\u7406" + total + "\u6761\uff0c\u5176\u4e2d\u6210\u529f" + successed + "\u6761\uff0c\u5931\u8d25" + failed + "\u6761");
        return rspBO;
    }
}

