/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiAddBillApplyInfoXbjService;
import com.tydic.pfsc.api.busi.bo.BusiAddBillApplyInfoXbjReqBO;
import com.tydic.pfsc.api.busi.vo.InvoiceHeaderXbjVO;
import com.tydic.pfsc.api.busi.vo.InvoiceMailAddrInfoXbjVO;
import com.tydic.pfsc.base.PfscExtRspBaseBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InquiryPayOrderMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InquiryPayOrder;
import com.tydic.pfsc.dao.vo.PayInvoiceVO;
import com.tydic.pfsc.enums.ApplyType;
import com.tydic.pfsc.enums.BillStatus;
import com.tydic.pfsc.enums.BillType;
import com.tydic.pfsc.enums.InquiryPayFeeType;
import com.tydic.pfsc.enums.InvoiceClasses;
import com.tydic.pfsc.enums.OrderSource;
import com.tydic.pfsc.enums.OrderStatus;
import com.tydic.pfsc.enums.RedBlue;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BusiAddBillApplyInfoXbjServiceImpl
implements BusiAddBillApplyInfoXbjService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddBillApplyInfoXbjServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private InquiryPayOrderMapper inquiryPayOrderMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;

    public PfscExtRspBaseBO add(BusiAddBillApplyInfoXbjReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u65b0\u589e\u5f00\u7968\u7533\u8bf7\u670d\u52a1(\u7535\u529b\u4e13\u533a)(\u4e13\u4e1a\u516c\u53f8\u548c\u4f9b\u5e94\u5546\u5171\u7528)\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO == null) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List payOrderNos = reqBO.getPayOrderNos();
        if (payOrderNos == null || payOrderNos.isEmpty()) {
            throw new PfscExtBusinessException("0001", "\u5165\u53c2\u7f34\u8d39\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String payFeeType = this.inquiryPayOrderMapper.queryOrderTypeByOrderNo((String)payOrderNos.get(0));
        if (InquiryPayFeeType.PLAT_USE_FEE.getCode().equals(payFeeType)) {
            this.addBillApplyForPlatUseFee(reqBO, payOrderNos);
        } else if (InquiryPayFeeType.TRADE_SERVICE_FEE.getCode().equals(payFeeType) || InquiryPayFeeType.PURCH_SERVICE_FEE.getCode().equals(payFeeType)) {
            this.addBillApplyForTradeServiceFee(reqBO, payOrderNos);
        }
        return new PfscExtRspBaseBO();
    }

    public void addBillApplyForPlatUseFee(BusiAddBillApplyInfoXbjReqBO reqBO, List<String> payOrderNos) {
        String invoiceClasses = reqBO.getInvoiceClasses();
        if (!StringUtils.hasText((String)invoiceClasses)) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        InvoiceHeaderXbjVO invoiceInfo = reqBO.getInvoiceInfo();
        InvoiceMailAddrInfoXbjVO mailAddrInfo = reqBO.getMailAddrInfo();
        if (invoiceInfo == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)invoiceInfo.getCompName())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses)) {
            if (mailAddrInfo == null) {
                throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
            }
            if (!StringUtils.hasText((String)mailAddrInfo.getName())) {
                throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
            }
        } else if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses)) {
            if (!StringUtils.hasText((String)reqBO.getReceiveInvoicePhone())) {
                throw new PfscExtBusinessException("0001", "\u6536\u7968\u4eba\u624b\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!StringUtils.hasText((String)reqBO.getReceiveInvoiceEmail())) {
                throw new PfscExtBusinessException("0001", "\u6536\u7968\u4eba\u90ae\u7bb1\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        String applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
        BigDecimal amt = BigDecimal.ZERO;
        List<InquiryPayOrder> list = this.inquiryPayOrderMapper.selectByPayOrderNos(payOrderNos);
        if (null == list || list.isEmpty()) {
            throw new PfscExtBusinessException("18000", "\u672a\u67e5\u5230\u6240\u52fe\u9009\u8ba2\u5355\u7684\u4fe1\u606f");
        }
        String payFeeType = list.get(0).getPayFeeType();
        HashSet<Long> operUnitSet = new HashSet<Long>();
        for (InquiryPayOrder inquiryPayOrder : list) {
            if (!OrderStatus.NO_APPLY.getCode().equals(inquiryPayOrder.getOrderStatus())) {
                throw new PfscExtBusinessException("18000", "\u8bf7\u52fe\u9009\u5f00\u7968\u72b6\u6001\u4e3a\u672a\u63d0\u4ea4\u7684\u8ba2\u5355");
            }
            amt = amt.add(inquiryPayOrder.getPayMoney());
            operUnitSet.add(inquiryPayOrder.getOperUnitNo());
        }
        if (1 != operUnitSet.size()) {
            throw new PfscExtBusinessException("18000", "\u4e0d\u652f\u6301\u4e0d\u540c\u4e13\u4e1a\u516c\u53f8\u4fe1\u606f\u7684\u8ba2\u5355\u5408\u5e76\u5f00\u7968");
        }
        Long supplierNo = list.get(0).getSupplierId();
        Long operUnitNo = list.get(0).getOperUnitNo();
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
        billApplyInfo.setSupplierNo(supplierNo);
        billApplyInfo.setOperUnitNo(operUnitNo);
        billApplyInfo.setOperUnitName(this.organizationInfoService.queryOrgName(operUnitNo));
        billApplyInfo.setSupplierName(this.organizationInfoService.querySupplierName(supplierNo));
        billApplyInfo.setPayFeeType(payFeeType);
        billApplyInfo.setInvoiceType(reqBO.getInvoiceType());
        billApplyInfo.setInvoceName(invoiceInfo.getCompName());
        billApplyInfo.setTaxNo(invoiceInfo.getNum());
        billApplyInfo.setAddr(invoiceInfo.getAddress());
        billApplyInfo.setPhone(invoiceInfo.getTel());
        billApplyInfo.setBankName(invoiceInfo.getBankName());
        billApplyInfo.setBankAcctNo(invoiceInfo.getBankAcct());
        if (InvoiceClasses.PAPER_INVOICE.getCode().equals(invoiceClasses)) {
            billApplyInfo.setName(mailAddrInfo.getName());
            billApplyInfo.setProvince(mailAddrInfo.getProvinceName());
            billApplyInfo.setCity(mailAddrInfo.getCityName());
            billApplyInfo.setCounty(mailAddrInfo.getCountyName());
            billApplyInfo.setTown(mailAddrInfo.getTown());
            billApplyInfo.setProvId(mailAddrInfo.getProvId());
            billApplyInfo.setCityId(mailAddrInfo.getCityId());
            billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
            billApplyInfo.setTownId(mailAddrInfo.getTownId());
            billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
            billApplyInfo.setMobile(mailAddrInfo.getTel());
            billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
            billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
        } else if (InvoiceClasses.ELECTRONIC_INVOICE.getCode().equals(invoiceClasses)) {
            billApplyInfo.setReceiveInvoicePhone(reqBO.getReceiveInvoicePhone());
            billApplyInfo.setReceiveInvoiceEmail(reqBO.getReceiveInvoiceEmail());
            billApplyInfo.setInvoiceClasses(InvoiceClasses.ELECTRONIC_INVOICE.getCode());
        }
        billApplyInfo.setApplyNo(applyNo);
        billApplyInfo.setApplyDate(new Date());
        billApplyInfo.setAmt(amt);
        billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
        billApplyInfo.setUserId(reqBO.getUserId());
        billApplyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
        billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ORDER.getCode());
        billApplyInfo.setRedBlue(RedBlue.BLUE.getCode());
        this.billApplyInfoMapper.insert(billApplyInfo);
        PayInvoiceVO payInvoiceVO = new PayInvoiceVO();
        payInvoiceVO.setPayOrderNos(payOrderNos);
        payInvoiceVO.setApplyNo(applyNo);
        payInvoiceVO.setOrderStatus(OrderStatus.APPLIED.getCode());
        this.inquiryPayOrderMapper.updateForBill(payInvoiceVO);
    }

    public void addBillApplyForTradeServiceFee(BusiAddBillApplyInfoXbjReqBO reqBO, List<String> payOrderNos) {
        InvoiceHeaderXbjVO invoiceInfo = reqBO.getInvoiceInfo();
        if (invoiceInfo == null) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (invoiceInfo.getType() == 3) {
            throw new PfscExtBusinessException("18000", "\u6210\u4ea4\u670d\u52a1\u8d39\u4e0d\u652f\u6301\u5f00\u5177\u7535\u5b50\u53d1\u7968");
        }
        InvoiceMailAddrInfoXbjVO mailAddrInfo = reqBO.getMailAddrInfo();
        if (!StringUtils.hasText((String)invoiceInfo.getCompName())) {
            throw new PfscExtBusinessException("0001", "\u53d1\u7968\u7684\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (mailAddrInfo == null) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        if (!StringUtils.hasText((String)mailAddrInfo.getName())) {
            throw new PfscExtBusinessException("0001", "\u90ae\u5bc4\u4fe1\u606f\u4e0d\u6b63\u786e");
        }
        String applyNo = this.billSNService.getSnAsString(BillType.INVOICE_APPLICATION);
        BigDecimal amt = BigDecimal.ZERO;
        List<InquiryPayOrder> list = this.inquiryPayOrderMapper.selectByPayOrderNos(payOrderNos);
        if (null == list || list.isEmpty()) {
            throw new PfscExtBusinessException("18000", "\u672a\u67e5\u5230\u6240\u52fe\u9009\u8ba2\u5355\u7684\u4fe1\u606f");
        }
        String payFeeType = list.get(0).getPayFeeType();
        HashSet<Long> operUnitSet = new HashSet<Long>();
        for (InquiryPayOrder inquiryPayOrder : list) {
            if (!OrderStatus.NO_APPLY.getCode().equals(inquiryPayOrder.getOrderStatus())) {
                throw new PfscExtBusinessException("18000", "\u8bf7\u52fe\u9009\u5f00\u7968\u72b6\u6001\u4e3a\u672a\u63d0\u4ea4\u7684\u8ba2\u5355");
            }
            amt = amt.add(inquiryPayOrder.getPayMoney());
            operUnitSet.add(inquiryPayOrder.getOperUnitNo());
        }
        if (1 != operUnitSet.size()) {
            throw new PfscExtBusinessException("18000", "\u4e0d\u652f\u6301\u4e0d\u540c\u4e13\u4e1a\u516c\u53f8\u4fe1\u606f\u7684\u8ba2\u5355\u5408\u5e76\u5f00\u7968");
        }
        Long supplierNo = list.get(0).getSupplierId();
        Long operUnitNo = list.get(0).getOperUnitNo();
        BillApplyInfo billApplyInfo = new BillApplyInfo();
        billApplyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
        billApplyInfo.setSupplierNo(supplierNo);
        billApplyInfo.setOperUnitNo(operUnitNo);
        billApplyInfo.setOperUnitName(this.organizationInfoService.queryOrgName(operUnitNo));
        billApplyInfo.setSupplierName(this.organizationInfoService.querySupplierName(supplierNo));
        billApplyInfo.setPayFeeType(payFeeType);
        billApplyInfo.setInvoiceType(String.valueOf(invoiceInfo.getType()));
        billApplyInfo.setInvoceName(invoiceInfo.getCompName());
        billApplyInfo.setTaxNo(invoiceInfo.getNum());
        billApplyInfo.setAddr(invoiceInfo.getAddress());
        billApplyInfo.setPhone(invoiceInfo.getTel());
        billApplyInfo.setBankName(invoiceInfo.getBankName());
        billApplyInfo.setBankAcctNo(invoiceInfo.getBankAcct());
        billApplyInfo.setName(mailAddrInfo.getName());
        billApplyInfo.setProvince(mailAddrInfo.getProvinceName());
        billApplyInfo.setCity(mailAddrInfo.getCityName());
        billApplyInfo.setCounty(mailAddrInfo.getCountyName());
        billApplyInfo.setTown(mailAddrInfo.getTown());
        billApplyInfo.setProvId(mailAddrInfo.getProvId());
        billApplyInfo.setCityId(mailAddrInfo.getCityId());
        billApplyInfo.setCountyId(mailAddrInfo.getCountyId());
        billApplyInfo.setTownId(mailAddrInfo.getTownId());
        billApplyInfo.setAddrDesc(mailAddrInfo.getAddrDesc());
        billApplyInfo.setMobile(mailAddrInfo.getTel());
        billApplyInfo.setTel(mailAddrInfo.getSpecialPlane());
        billApplyInfo.setPostCode(mailAddrInfo.getPostCode());
        billApplyInfo.setApplyNo(applyNo);
        billApplyInfo.setApplyDate(new Date());
        billApplyInfo.setAmt(amt);
        billApplyInfo.setBillStatus(BillStatus.NO_APPLY.getCode());
        billApplyInfo.setUserId(reqBO.getUserId());
        billApplyInfo.setSource(OrderSource.CONSULT_PRICE.getCode());
        billApplyInfo.setApplyType(ApplyType.APPLY_TYPE_ORDER.getCode());
        billApplyInfo.setInvoiceClasses(InvoiceClasses.PAPER_INVOICE.getCode());
        billApplyInfo.setRedBlue(RedBlue.BLUE.getCode());
        this.billApplyInfoMapper.insert(billApplyInfo);
        PayInvoiceVO payInvoiceVO = new PayInvoiceVO();
        payInvoiceVO.setPayOrderNos(payOrderNos);
        payInvoiceVO.setApplyNo(applyNo);
        payInvoiceVO.setOrderStatus(OrderStatus.APPLIED.getCode());
        this.inquiryPayOrderMapper.updateForBill(payInvoiceVO);
    }
}

