/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.BusiAddPayAbleService;
import com.tydic.pfsc.api.busi.bo.BusiAddPayAbleReqBO;
import com.tydic.pfsc.api.busi.bo.BusiAddPayAbleRspBO;
import com.tydic.pfsc.dao.PayableDetailMapper;
import com.tydic.pfsc.dao.po.PayableDetailPO;
import com.tydic.pfsc.enums.PayablePayType;
import com.tydic.pfsc.exception.PfscExtBusinessException;
import com.tydic.pfsc.service.atom.BillSNService;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"fscExtService/1.0.0/com.tydic.pfsc.api.busi.BusiAddPayAbleService"})
public class BusiAddPayAbleServiceImpl
implements BusiAddPayAbleService {
    private static final Logger logger = LoggerFactory.getLogger(BusiAddPayAbleServiceImpl.class);
    @Autowired
    private BillSNService billSNService;
    @Autowired
    private PayableDetailMapper payableDetailMapper;

    @PostMapping(value={"createPayAble"})
    public BusiAddPayAbleRspBO createPayAble(@RequestBody BusiAddPayAbleReqBO reqBO) {
        if (logger.isDebugEnabled()) {
            logger.debug("\u751f\u6210\u5e94\u4ed8\u5355\u670d\u52a1\u5165\u53c2\uff1a" + reqBO);
        }
        if (reqBO.getSource() == null || "".equals(reqBO.getSource())) {
            throw new PfscExtBusinessException("0001", "\u6765\u6e90\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getOrderId()) {
            throw new PfscExtBusinessException("0001", "\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayType() || "".equals(reqBO.getPayType())) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayableType()) {
            throw new PfscExtBusinessException("0001", "\u4ed8\u6b3e\u65b9\u5f0f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getPayableAmt()) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u91d1\u989d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BusiAddPayAbleRspBO rspBO = new BusiAddPayAbleRspBO();
        try {
            PayableDetailPO po = new PayableDetailPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)po);
            String snNo = this.getPayInfoId(po.getPayableType());
            po.setPayableNo(snNo);
            po.setPayType(PayablePayType.PAY.getCode());
            po.setPaidAmt(BigDecimal.ZERO);
            po.setPendingAmt(BigDecimal.ZERO);
            po.setPaidDate(new Date());
            this.payableDetailMapper.insert(po);
        }
        catch (Exception e) {
            rspBO.setRespCode("18000");
            rspBO.setRespDesc("\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25:" + e.toString());
            logger.error("\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25:", (Throwable)e);
            throw new PfscExtBusinessException("0001", "\u65b0\u589e\u5e94\u4ed8\u8bb0\u5f55\u5931\u8d25");
        }
        return rspBO;
    }

    private String getPayInfoId(Integer payableType) {
        try {
            SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd");
            String dateL = Long.valueOf(df.format(new Date())).toString();
            String prefix = "CG";
            if (payableType == 2) {
                prefix = "DH";
            } else if (payableType == 3) {
                prefix = "YS";
            }
            String maxNum = this.payableDetailMapper.selectMaxPayNoNum(prefix + dateL);
            String num = "0001";
            if (maxNum != null && !"".equals(maxNum)) {
                num = String.format("%04d", Integer.parseInt(maxNum) + 1);
            }
            StringBuilder sb = new StringBuilder();
            sb.append(prefix).append(dateL).append(num);
            return sb.toString();
        }
        catch (Exception e) {
            throw new PfscExtBusinessException("0001", "\u5e94\u4ed8\u7f16\u53f7\u751f\u6210\u5931\u8d25");
        }
    }
}

