/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.pfsc.service.busi.impl;

import com.tydic.pfsc.api.busi.bo.BusiGetBillDataRspBO;
import com.tydic.pfsc.dao.BillApplyInfoMapper;
import com.tydic.pfsc.dao.InvoiceReturnDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceDetailMapper;
import com.tydic.pfsc.dao.SaleInvoiceInfoMapper;
import com.tydic.pfsc.dao.SaleItemInfoMapper;
import com.tydic.pfsc.dao.po.BillApplyInfo;
import com.tydic.pfsc.dao.po.InvoiceReturnDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceDetail;
import com.tydic.pfsc.dao.po.SaleInvoiceInfo;
import com.tydic.pfsc.dao.vo.InvoiceReturnDetailVO;
import com.tydic.pfsc.enums.InvoiceType;
import com.tydic.pfsc.enums.RedBlue;
import com.tydic.pfsc.service.atom.OrganizationInfoService;
import com.tydic.pfsc.utils.FscStringUtils;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class BusiGetBillDataDzcsInvoiceReturnService {
    private static final Logger logger = LoggerFactory.getLogger(BusiGetBillDataDzcsInvoiceReturnService.class);
    @Autowired
    private InvoiceReturnDetailMapper invoiceReturnDetailMapper;
    @Autowired
    private OrganizationInfoService organizationInfoService;
    @Autowired
    private SaleInvoiceDetailMapper saleInvoiceDetailMapper;
    @Autowired
    private SaleItemInfoMapper saleItemInfoMapper;
    @Autowired
    private BillApplyInfoMapper billApplyInfoMapper;
    @Autowired
    private SaleInvoiceInfoMapper saleInvoiceInfoMapper;

    public List<BusiGetBillDataRspBO.BusiGetBillData> getBills(BillApplyInfo billApplyInfo) {
        List<BusiGetBillDataRspBO.BusiGetBillData> billsList = null;
        String redBlue = billApplyInfo.getRedBlue();
        if (RedBlue.RED.getCode().equals(redBlue)) {
            billsList = this.getRedBills(billApplyInfo);
        } else if (RedBlue.BLUE.getCode().equals(redBlue)) {
            billsList = this.getBlueBills(billApplyInfo);
        }
        return billsList;
    }

    private List<BusiGetBillDataRspBO.BusiGetBillData> getRedBills(BillApplyInfo billApplyInfo) {
        ArrayList<BusiGetBillDataRspBO.BusiGetBillData> redBillsList = new ArrayList<BusiGetBillDataRspBO.BusiGetBillData>();
        InvoiceReturnDetailVO vo = new InvoiceReturnDetailVO();
        vo.setBillNo(billApplyInfo.getBillNo());
        vo.setApplyNo2(billApplyInfo.getApplyNo());
        List<InvoiceReturnDetail> invoiceReturnDetails = this.invoiceReturnDetailMapper.selectList(vo);
        if (CollectionUtils.isEmpty(invoiceReturnDetails)) {
            logger.error("\u5f00\u7968\u7533\u8bf7\u5355\u53f7" + billApplyInfo.getApplyNo() + "\u5bf9\u5e94\u7684\u9000\u7968\u7533\u8bf7\u660e\u7ec6\u4e3a\u7a7a");
            return null;
        }
        for (InvoiceReturnDetail invoiceReturnDetail : invoiceReturnDetails) {
            BusiGetBillDataRspBO rspBO = new BusiGetBillDataRspBO();
            BusiGetBillDataRspBO.BusiGetBillData busiGetBillData = new BusiGetBillDataRspBO.BusiGetBillData(rspBO);
            busiGetBillData.setBill_no(billApplyInfo.getApplyNo() + "-" + invoiceReturnDetail.getInvoiceNo1());
            busiGetBillData.setBuyer_name(billApplyInfo.getInvoceName());
            busiGetBillData.setBuyer_tax(FscStringUtils.valueOf(billApplyInfo.getTaxNo()));
            busiGetBillData.setBuyer_addr(FscStringUtils.valueOf(billApplyInfo.getAddr()));
            busiGetBillData.setBuyer_tel(FscStringUtils.valueOf(billApplyInfo.getPhone()));
            busiGetBillData.setBuyer_bank(FscStringUtils.valueOf(billApplyInfo.getBankName()));
            busiGetBillData.setBuyer_acc(FscStringUtils.valueOf(billApplyInfo.getBankAcctNo()));
            if (InvoiceType.NORMAL.getCode().equals(Integer.valueOf(billApplyInfo.getInvoiceType()))) {
                busiGetBillData.setInvoice_type("2");
            } else {
                busiGetBillData.setInvoice_type("0");
            }
            LinkedList<BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO> detail = new LinkedList<BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO>();
            boolean continueFlag = false;
            List<SaleInvoiceDetail> saleInvoiceDetailList = this.saleInvoiceDetailMapper.selectByInvoiceNo(invoiceReturnDetail.getInvoiceNo1());
            if (CollectionUtils.isEmpty(saleInvoiceDetailList)) {
                logger.error("\u6839\u636e\u53d1\u7968\u53f7\u7801" + invoiceReturnDetail.getInvoiceNo1() + "\u67e5\u8be2\u5230\u7684\u9500\u552e\u53d1\u7968\u660e\u7ec6\u4e3a\u7a7a");
                return null;
            }
            for (SaleInvoiceDetail saleInvoiceDetail : saleInvoiceDetailList) {
                BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO busiBillDataDetail = new BusiGetBillDataRspBO.BusiGetBillData.BusiGetBillDataDetailRspBO(busiGetBillData);
                busiBillDataDetail.setOrder_no(saleInvoiceDetail.getInspectionId());
                busiBillDataDetail.setLines_number(saleInvoiceDetail.getItemNo());
                busiBillDataDetail.setMateriel_unit(saleInvoiceDetail.getUnitName());
                busiBillDataDetail.setTax_class_code(saleInvoiceDetail.getTaxClassCode());
                if (!StringUtils.hasText((String)busiBillDataDetail.getTax_class_code())) {
                    logger.error("\u6ca1\u6709\u83b7\u53d6\u5230\u7a0e\u6536\u5206\u7c7b\u7f16\u7801\u3002\u9a8c\u6536\u5355\u53f7=" + saleInvoiceDetail.getInspectionId() + "\uff0c\u5546\u54c1\u884c\u53f7=" + saleInvoiceDetail.getItemNo());
                    continueFlag = true;
                    break;
                }
                busiBillDataDetail.setPrice(saleInvoiceDetail.getSaleUnitPrice());
                busiBillDataDetail.setQuantity(saleInvoiceDetail.getQuantity().negate());
                busiBillDataDetail.setAmount(saleInvoiceDetail.getAmount().negate());
                busiBillDataDetail.setTax(saleInvoiceDetail.getTaxAmt().negate());
                busiBillDataDetail.setTax_rate(saleInvoiceDetail.getTaxRate());
                busiBillDataDetail.setTax_flag(Integer.valueOf(1));
                String materiel_name = FscStringUtils.valueOf(saleInvoiceDetail.getItemName());
                String materiel_standard = FscStringUtils.valueOf(saleInvoiceDetail.getSpecModel());
                materiel_name = materiel_name.length() > 35 ? materiel_name.substring(0, 35) : materiel_name;
                materiel_standard = materiel_standard.length() > 30 ? materiel_standard.substring(0, 30) : materiel_standard;
                busiBillDataDetail.setMateriel_name(materiel_name);
                busiBillDataDetail.setMateriel_standard(StringUtils.hasText((String)materiel_standard) ? materiel_standard : "\u65e0");
                detail.add(busiBillDataDetail);
            }
            if (continueFlag) {
                return null;
            }
            SaleInvoiceInfo originalInvoice = this.saleInvoiceInfoMapper.selectByPrimaryKey(invoiceReturnDetail.getInvoiceNo1());
            StringBuilder notes = new StringBuilder();
            notes.append("\u5bf9\u5e94\u6574\u6570\u53d1\u7968\u4ee3\u7801\uff1a").append(originalInvoice.getInvoiceCode()).append("\u53f7\u7801\uff1a").append(originalInvoice.getInvoiceNo());
            busiGetBillData.setNotes(notes.length() > 160 ? notes.substring(0, 160) : notes.toString());
            busiGetBillData.setDetail(detail);
            redBillsList.add(busiGetBillData);
        }
        return redBillsList;
    }

    private List<BusiGetBillDataRspBO.BusiGetBillData> getBlueBills(BillApplyInfo billApplyInfo) {
        return null;
    }
}

